/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.ftpserver.gui.PluginPanel;
import org.apache.ftpserver.gui.PluginPanelContainer;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.util.IoUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;

public class LoggerPanel
extends PluginPanel {
    private static final long serialVersionUID = 5988947217051710193L;
    private static final int MAX_CHARS = 8192;
    private static final Color COLOR_DEBUG = new Color(63, 127, 95);
    private static final Color COLOR_INFO = new Color(0, 0, 0);
    private static final Color COLOR_WARN = new Color(245, 150, 45);
    private static final Color COLOR_ERROR = new Color(255, 0, 0);
    private static final Level[] LEVELS = new Level[]{Level.TRACE, Level.DEBUG, Level.INFO, Level.WARN, Level.ERROR, Level.FATAL, Level.OFF};
    private static final int LEVEL_INFO = 2;
    private int logLevel = 2;
    private FtpServerContext serverContext;
    private JComboBox logCombo;
    private JTextPane logTxt;
    private Document doc;
    private SimpleAttributeSet debugAttr = new SimpleAttributeSet();
    private SimpleAttributeSet infoAttr;
    private SimpleAttributeSet warnAttr;
    private SimpleAttributeSet errorAttr;

    public LoggerPanel(PluginPanelContainer container) {
        super(container);
        StyleConstants.setForeground(this.debugAttr, COLOR_DEBUG);
        this.infoAttr = new SimpleAttributeSet();
        StyleConstants.setForeground(this.infoAttr, COLOR_INFO);
        this.warnAttr = new SimpleAttributeSet();
        StyleConstants.setForeground(this.warnAttr, COLOR_WARN);
        this.errorAttr = new SimpleAttributeSet();
        StyleConstants.setForeground(this.errorAttr, COLOR_ERROR);
        this.initComponents();
        LoggerPanelAppender appender = new LoggerPanelAppender();
        LogManager.getRootLogger().addAppender((Appender)appender);
    }

    private SimpleAttributeSet getAttributeSet(Level level) {
        SimpleAttributeSet attr = null;
        attr = level.isGreaterOrEqual((Priority)Level.ERROR) ? this.errorAttr : (level.isGreaterOrEqual((Priority)Level.WARN) ? this.warnAttr : (level.isGreaterOrEqual((Priority)Level.INFO) ? this.infoAttr : this.debugAttr));
        return attr;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel(new FlowLayout(1));
        this.add((Component)topPanel, "North");
        JLabel comboLab = new JLabel("Log Level :: ");
        comboLab.setForeground(Color.black);
        topPanel.add(comboLab);
        this.logCombo = new JComboBox<Level>(LEVELS);
        this.logCombo.setSelectedIndex(2);
        Dimension dim = new Dimension(90, 22);
        this.logCombo.setPreferredSize(dim);
        this.logCombo.setMaximumSize(dim);
        this.logCombo.setToolTipText("Set Log Level");
        this.logCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                LoggerPanel.this.logLevel = LoggerPanel.this.logCombo.getSelectedIndex();
            }
        });
        topPanel.add(this.logCombo);
        this.logTxt = new JTextPane();
        this.logTxt.setFont(new Font("Monospaced", 0, 12));
        this.logTxt.setEditable(false);
        this.doc = this.logTxt.getDocument();
        JPanel noWrapPanel = new JPanel(new BorderLayout());
        noWrapPanel.add(this.logTxt);
        this.add((Component)new JScrollPane(noWrapPanel), "Center");
        JPanel bottomPanel = new JPanel(new FlowLayout(1));
        this.add((Component)bottomPanel, "South");
        JButton clearAction = new JButton("Clear");
        clearAction.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    LoggerPanel.this.doc.remove(0, LoggerPanel.this.doc.getLength());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        bottomPanel.add(clearAction);
    }

    public void refresh(FtpServerContext serverContext) {
        this.serverContext = serverContext;
        try {
            this.doc.remove(0, this.doc.getLength());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean canBeDisplayed() {
        return this.serverContext != null;
    }

    public String toString() {
        return "Log";
    }

    public void dispose() {
    }

    private boolean isEnabled(Level level) {
        Level activeLevel = LEVELS[this.logLevel];
        return level.isGreaterOrEqual((Priority)activeLevel);
    }

    private void write(final Level level, final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    int docLen = LoggerPanel.this.doc.getLength();
                    if (docLen > 8192) {
                        LoggerPanel.this.doc.remove(0, docLen);
                        docLen = 0;
                    }
                    SimpleAttributeSet attr = LoggerPanel.this.getAttributeSet(level);
                    LoggerPanel.this.doc.insertString(docLen, message, attr);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    private class LoggerPanelAppender
    extends AppenderSkeleton {
        private LoggerPanelAppender() {
        }

        protected void append(LoggingEvent event) {
            if (LoggerPanel.this.isEnabled(event.getLevel())) {
                String msg = '[' + event.getLevel().toString() + "] " + event.getMessage().toString() + '\n';
                LoggerPanel.this.write(event.getLevel(), String.valueOf(msg));
                if (event.getThrowableInformation() != null) {
                    LoggerPanel.this.write(event.getLevel(), IoUtils.getStackTrace((Throwable)event.getThrowableInformation().getThrowable()));
                }
            }
        }

        public void close() {
        }

        public boolean requiresLayout() {
            return false;
        }
    }
}

