/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class IPRestrictorTable
extends JPanel
implements TableModel,
ListSelectionListener {
    private static final long serialVersionUID = -7517200112683933776L;
    private static final String[] HEADER = new String[]{"IP Pattern", "Permission"};
    private Vector entries = new Vector();
    private EventListenerList modelListeners = new EventListenerList();
    private JTable table;
    private JButton addButton;
    private JButton insertButton;
    private JButton removeButton;
    private JButton moveUpButton;
    private JButton moveDownButton;

    public IPRestrictorTable() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.table = new JTable(this);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setRowHeight(20);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.getColumnModel().getSelectionModel().addListSelectionListener(this);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.add((Component)scrollPane, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        this.add((Component)buttonPanel, "South");
        this.addButton = new JButton("Add");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IPRestrictorTable.this.addRow();
            }
        });
        buttonPanel.add(this.addButton);
        this.insertButton = new JButton("Insert");
        this.insertButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IPRestrictorTable.this.insertRow();
            }
        });
        buttonPanel.add(this.insertButton);
        this.removeButton = new JButton("Remove");
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IPRestrictorTable.this.removeRow();
            }
        });
        buttonPanel.add(this.removeButton);
        this.moveUpButton = new JButton("Move Up");
        this.moveUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IPRestrictorTable.this.moveUpRow();
            }
        });
        buttonPanel.add(this.moveUpButton);
        this.moveDownButton = new JButton("Move Down");
        this.moveDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IPRestrictorTable.this.moveDownRow();
            }
        });
        buttonPanel.add(this.moveDownButton);
        this.setButtonStatus();
    }

    private void setButtonStatus() {
        this.addButton.setEnabled(this.canBeAdded());
        this.insertButton.setEnabled(this.canBeInserted());
        this.removeButton.setEnabled(this.canBeRemoved());
        this.moveUpButton.setEnabled(this.canBeMovedUp());
        this.moveDownButton.setEnabled(this.canBeMovedDown());
    }

    private boolean canBeAdded() {
        return true;
    }

    private boolean canBeInserted() {
        return true;
    }

    private boolean canBeRemoved() {
        if (this.entries == null || this.entries.size() == 0) {
            return false;
        }
        int selRow = this.table.getSelectedRow();
        return selRow >= 0;
    }

    private boolean canBeMovedUp() {
        if (this.entries == null || this.entries.size() == 0) {
            return false;
        }
        int selRow = this.table.getSelectedRow();
        return selRow > 0;
    }

    private boolean canBeMovedDown() {
        if (this.entries == null || this.entries.size() == 0) {
            return false;
        }
        int selRow = this.table.getSelectedRow();
        if (selRow == -1) {
            return false;
        }
        return selRow != this.entries.size() - 1;
    }

    public void addRow() {
        if (!this.canBeAdded()) {
            return;
        }
        this.stopCellEditing();
        Entry entry = new Entry();
        this.entries.add(entry);
        int lastRow = this.entries.size() - 1;
        this.fireTableChanged(new TableModelEvent(this, lastRow, lastRow, -1, 1));
        this.table.setRowSelectionInterval(lastRow, lastRow);
    }

    public void insertRow() {
        if (!this.canBeInserted()) {
            return;
        }
        this.stopCellEditing();
        int selRow = this.table.getSelectedRow();
        if (selRow == -1) {
            selRow = this.entries.size() - 1;
        }
        if (selRow == -1) {
            selRow = 0;
        }
        Entry entry = new Entry();
        this.entries.add(selRow, entry);
        this.fireTableChanged(new TableModelEvent(this, selRow, selRow, -1, 1));
        this.table.setRowSelectionInterval(selRow, selRow);
    }

    public void removeRow() {
        if (!this.canBeRemoved()) {
            return;
        }
        this.stopCellEditing();
        int selRow = this.table.getSelectedRow();
        if (selRow == -1) {
            selRow = this.entries.size() - 1;
        }
        this.entries.remove(selRow);
        this.fireTableChanged(new TableModelEvent(this, selRow, selRow, -1, -1));
        if (this.entries.isEmpty()) {
            this.setButtonStatus();
        } else {
            if (selRow == this.entries.size()) {
                --selRow;
            }
            this.table.setRowSelectionInterval(selRow, selRow);
        }
    }

    public void moveUpRow() {
        if (!this.canBeMovedUp()) {
            return;
        }
        this.stopCellEditing();
        int selRow = this.table.getSelectedRow();
        Entry ent1 = (Entry)this.entries.get(selRow);
        Entry ent2 = (Entry)this.entries.get(selRow - 1);
        this.entries.set(selRow, ent2);
        this.entries.set(selRow - 1, ent1);
        this.fireTableChanged(new TableModelEvent(this, selRow - 1, selRow, -1, 0));
        this.table.setRowSelectionInterval(selRow - 1, selRow - 1);
    }

    public void moveDownRow() {
        if (!this.canBeMovedDown()) {
            return;
        }
        this.stopCellEditing();
        int selRow = this.table.getSelectedRow();
        Entry ent1 = (Entry)this.entries.get(selRow);
        Entry ent2 = (Entry)this.entries.get(selRow + 1);
        this.entries.set(selRow, ent2);
        this.entries.set(selRow + 1, ent1);
        this.fireTableChanged(new TableModelEvent(this, selRow, selRow + 1, -1, 0));
        this.table.setRowSelectionInterval(selRow + 1, selRow + 1);
    }

    public Object[][] getData() {
        this.stopCellEditing();
        Object[][] retVal = new Object[this.entries.size()][2];
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry entry = (Entry)this.entries.get(i);
            retVal[i][0] = entry.pattern;
            retVal[i][1] = entry.allow;
        }
        return retVal;
    }

    public void setData(Object[][] objs) {
        this.cancelCellEditing();
        this.entries.clear();
        if (objs != null) {
            for (int i = 0; i < objs.length; ++i) {
                Entry entry = new Entry();
                entry.pattern = (String)objs[i][0];
                entry.allow = (Boolean)objs[i][1];
                this.entries.add(entry);
            }
        }
        this.fireTableChanged(new TableModelEvent(this));
        if (this.entries.isEmpty()) {
            this.setButtonStatus();
        } else {
            this.table.setRowSelectionInterval(0, 0);
        }
    }

    public void cancelCellEditing() {
        if (this.table.isEditing()) {
            int row = this.table.getEditingRow();
            int col = this.table.getEditingColumn();
            if (row != -1 && col != -1) {
                TableCellEditor editor = this.table.getCellEditor();
                editor.cancelCellEditing();
            }
        }
    }

    public void stopCellEditing() {
        if (this.table.isEditing()) {
            int row = this.table.getEditingRow();
            int col = this.table.getEditingColumn();
            if (row != -1 && col != -1) {
                TableCellEditor editor = this.table.getCellEditor();
                editor.stopCellEditing();
            }
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        this.setButtonStatus();
    }

    public void addTableModelListener(TableModelListener l) {
        this.modelListeners.add(TableModelListener.class, l);
    }

    public Class getColumnClass(int colIdx) {
        Class type = null;
        type = colIdx == 0 ? String.class : Boolean.class;
        return type;
    }

    public int getColumnCount() {
        return HEADER.length;
    }

    public String getColumnName(int col) {
        return HEADER[col];
    }

    public int getRowCount() {
        return this.entries.size();
    }

    public Object getValueAt(int row, int col) {
        if (this.entries == null) {
            return null;
        }
        Entry entry = (Entry)this.entries.get(row);
        Object retVal = null;
        retVal = col == 0 ? entry.pattern : entry.allow;
        return retVal;
    }

    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public void setValueAt(Object val, int row, int col) {
        if (this.entries == null) {
            return;
        }
        Entry entry = (Entry)this.entries.get(row);
        if (col == 0) {
            entry.pattern = (String)val;
        } else {
            entry.allow = (Boolean)val;
        }
    }

    public void removeTableModelListener(TableModelListener l) {
        this.modelListeners.remove(TableModelListener.class, l);
    }

    private void fireTableChanged(TableModelEvent e) {
        Object[] listeners = this.modelListeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TableModelListener == null ? IPRestrictorTable.class$("javax.swing.event.TableModelListener") : class$javax$swing$event$TableModelListener)) continue;
            ((TableModelListener)listeners[i + 1]).tableChanged(e);
        }
    }

    private static class Entry {
        public String pattern = "*";
        public Boolean allow = Boolean.TRUE;

        private Entry() {
        }
    }
}

