/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec.support;

import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.support.BaseIoSession;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.util.Queue;

public class SimpleProtocolDecoderOutput
implements ProtocolDecoderOutput {
    private final IoFilter.NextFilter nextFilter;
    private final IoSession session;
    private final Queue messageQueue = new Queue();

    public SimpleProtocolDecoderOutput(IoSession session, IoFilter.NextFilter nextFilter) {
        this.nextFilter = nextFilter;
        this.session = session;
    }

    public void write(Object message) {
        this.messageQueue.push(message);
        if (this.session instanceof BaseIoSession) {
            ((BaseIoSession)this.session).increaseReadMessages();
        }
    }

    public void flush() {
        while (!this.messageQueue.isEmpty()) {
            this.nextFilter.messageReceived(this.session, this.messageQueue.pop());
        }
    }
}

