/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.smooks.edi;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.assertion.AssertArgument;
import org.milyn.cdr.ProfileTargetingExpression;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.edisax.EDIParser;
import org.milyn.resource.URIResourceLocator;
import org.milyn.schema.ediMessageMapping10.EdimapDocument;
import org.milyn.xml.SmooksXMLReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmooksEDIParser
extends EDIParser
implements SmooksXMLReader {
    private static Log logger = LogFactory.getLog(SmooksEDIParser.class);
    private static String MAPPING_TABLE_CTX_KEY = SmooksEDIParser.class.getName() + "#MAPPING_TABLE_CTX_KEY";
    public static final String MODEL_CONFIG_KEY = "mapping-model";
    private static URIResourceLocator uriMappingLocator = new URIResourceLocator();
    private SmooksResourceConfiguration configuration;
    private ExecutionContext executionContext;

    public void setConfiguration(SmooksResourceConfiguration configuration) {
        AssertArgument.isNotNull((Object)configuration, (String)"configuration");
        this.configuration = configuration;
    }

    public void setExecutionContext(ExecutionContext executionContext) {
        AssertArgument.isNotNull((Object)executionContext, (String)"executionContext");
        this.executionContext = executionContext;
    }

    public void parse(InputSource ediSource) throws IOException, SAXException {
        EdimapDocument.Edimap edi2xmlMappingModel = this.getMappingModel();
        this.setMappingModel(edi2xmlMappingModel);
        super.parse(ediSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EdimapDocument.Edimap getMappingModel() throws IOException, SAXException {
        EdimapDocument.Edimap edi2xmlMappingModel;
        Hashtable mappings = SmooksEDIParser.getMappingTable(this.executionContext.getContext());
        SmooksResourceConfiguration smooksResourceConfiguration = this.configuration;
        synchronized (smooksResourceConfiguration) {
            edi2xmlMappingModel = (EdimapDocument.Edimap)mappings.get(this.configuration);
            if (edi2xmlMappingModel == null) {
                InputStream mappingConfigData = this.getMappingConfigData();
                try {
                    edi2xmlMappingModel = EDIParser.parseMappingModel((InputStream)mappingConfigData);
                }
                catch (IOException e) {
                    IOException newE = new IOException("Error parsing EDI mapping model [" + this.configuration.getStringParameter(MODEL_CONFIG_KEY) + "].  Target Profile(s) " + this.getTargetProfiles() + ".");
                    newE.initCause(e);
                    throw newE;
                }
                catch (SAXException e) {
                    throw new SAXException("Error parsing EDI mapping model [" + this.configuration.getStringParameter(MODEL_CONFIG_KEY) + "].  Target Profile(s) " + this.getTargetProfiles() + ".", e);
                }
                mappings.put(this.configuration, edi2xmlMappingModel);
                logger.info((Object)("Parsed, validated and cached EDI mapping model [" + edi2xmlMappingModel.getDescription().getName() + ", Version " + edi2xmlMappingModel.getDescription().getVersion() + "].  Target Profile(s) " + this.getTargetProfiles() + "."));
            } else if (logger.isInfoEnabled()) {
                logger.info((Object)("Found EDI mapping model [" + edi2xmlMappingModel.getDescription().getName() + ", Version " + edi2xmlMappingModel.getDescription().getVersion() + "] in the model cache.  Target Profile(s) " + this.getTargetProfiles() + "."));
            }
        }
        return edi2xmlMappingModel;
    }

    protected static Hashtable getMappingTable(ApplicationContext context) {
        Hashtable mappingModelTable = (Hashtable)context.getAttribute((Object)MAPPING_TABLE_CTX_KEY);
        if (mappingModelTable == null) {
            mappingModelTable = new Hashtable();
            context.setAttribute((Object)MAPPING_TABLE_CTX_KEY, mappingModelTable);
        }
        return mappingModelTable;
    }

    private InputStream getMappingConfigData() {
        InputStream configStream = null;
        String modelConfigData = this.configuration.getStringParameter(MODEL_CONFIG_KEY);
        if (modelConfigData == null) {
            throw new IllegalStateException("Mandatory resource configuration parameter [mapping-model] not specified for [" + ((Object)((Object)this)).getClass().getName() + "] parser configuration.  Target Profile(s) " + this.getTargetProfiles() + ".");
        }
        try {
            new URI(modelConfigData);
            configStream = uriMappingLocator.getResource(modelConfigData);
            if (configStream == null) {
                logger.error((Object)("Invalid mapping-model config value '" + modelConfigData + "'. Failed to locate resource!"));
            }
        }
        catch (URISyntaxException e) {
            configStream = new ByteArrayInputStream(modelConfigData.getBytes());
        }
        catch (IOException e) {
            IllegalStateException state = new IllegalStateException("Invalid EDI mapping model config specified for " + ((Object)((Object)this)).getClass().getName() + ".  Unable to access URI based mapping model [" + modelConfigData + "].  Target Profile(s) " + this.getTargetProfiles() + ".");
            state.initCause(e);
            throw state;
        }
        return configStream;
    }

    private List<ProfileTargetingExpression> getTargetProfiles() {
        return Arrays.asList(this.configuration.getProfileTargetingExpressions());
    }
}

