/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeNodeStream;
import org.antlr.test.BaseTest;

public class TestTreeNodeStream
extends BaseTest {
    public TreeNodeStream newStream(Object object) {
        return new CommonTreeNodeStream(object);
    }

    public void testSingleNode() throws Exception {
        CommonTree commonTree = new CommonTree(new CommonToken(101));
        TreeNodeStream treeNodeStream = this.newStream(commonTree);
        String string = " 101";
        String string2 = this.toNodesOnlyString(treeNodeStream);
        TestTreeNodeStream.assertEquals((String)string, (String)string2);
        string = " 101";
        string2 = treeNodeStream.toString();
        TestTreeNodeStream.assertEquals((String)string, (String)string2);
    }

    public void test4Nodes() throws Exception {
        CommonTree commonTree = new CommonTree(new CommonToken(101));
        commonTree.addChild(new CommonTree(new CommonToken(102)));
        commonTree.getChild(0).addChild(new CommonTree(new CommonToken(103)));
        commonTree.addChild(new CommonTree(new CommonToken(104)));
        TreeNodeStream treeNodeStream = this.newStream(commonTree);
        String string = " 101 102 103 104";
        String string2 = this.toNodesOnlyString(treeNodeStream);
        TestTreeNodeStream.assertEquals((String)string, (String)string2);
        string = " 101 2 102 2 103 3 104 3";
        string2 = treeNodeStream.toString();
        TestTreeNodeStream.assertEquals((String)string, (String)string2);
    }

    public void testList() throws Exception {
        CommonTree commonTree = new CommonTree((Token)null);
        CommonTree commonTree2 = new CommonTree(new CommonToken(101));
        commonTree2.addChild(new CommonTree(new CommonToken(102)));
        commonTree2.getChild(0).addChild(new CommonTree(new CommonToken(103)));
        commonTree2.addChild(new CommonTree(new CommonToken(104)));
        CommonTree commonTree3 = new CommonTree(new CommonToken(105));
        commonTree.addChild(commonTree2);
        commonTree.addChild(commonTree3);
        CommonTreeNodeStream commonTreeNodeStream = new CommonTreeNodeStream(commonTree);
        String string = " 101 102 103 104 105";
        String string2 = this.toNodesOnlyString(commonTreeNodeStream);
        TestTreeNodeStream.assertEquals((String)string, (String)string2);
        string = " 101 2 102 2 103 3 104 3 105";
        string2 = commonTreeNodeStream.toString();
        TestTreeNodeStream.assertEquals((String)string, (String)string2);
    }

    public void testFlatList() throws Exception {
        CommonTree commonTree = new CommonTree((Token)null);
        commonTree.addChild(new CommonTree(new CommonToken(101)));
        commonTree.addChild(new CommonTree(new CommonToken(102)));
        commonTree.addChild(new CommonTree(new CommonToken(103)));
        CommonTreeNodeStream commonTreeNodeStream = new CommonTreeNodeStream(commonTree);
        String string = " 101 102 103";
        String string2 = this.toNodesOnlyString(commonTreeNodeStream);
        TestTreeNodeStream.assertEquals((String)string, (String)string2);
        string = " 101 102 103";
        string2 = commonTreeNodeStream.toString();
        TestTreeNodeStream.assertEquals((String)string, (String)string2);
    }

    public void testListWithOneNode() throws Exception {
        CommonTree commonTree = new CommonTree((Token)null);
        commonTree.addChild(new CommonTree(new CommonToken(101)));
        CommonTreeNodeStream commonTreeNodeStream = new CommonTreeNodeStream(commonTree);
        String string = " 101";
        String string2 = this.toNodesOnlyString(commonTreeNodeStream);
        TestTreeNodeStream.assertEquals((String)string, (String)string2);
        string = " 101";
        string2 = commonTreeNodeStream.toString();
        TestTreeNodeStream.assertEquals((String)string, (String)string2);
    }

    public void testAoverB() throws Exception {
        CommonTree commonTree = new CommonTree(new CommonToken(101));
        commonTree.addChild(new CommonTree(new CommonToken(102)));
        TreeNodeStream treeNodeStream = this.newStream(commonTree);
        String string = " 101 102";
        String string2 = this.toNodesOnlyString(treeNodeStream);
        TestTreeNodeStream.assertEquals((String)string, (String)string2);
        string = " 101 2 102 3";
        string2 = treeNodeStream.toString();
        TestTreeNodeStream.assertEquals((String)string, (String)string2);
    }

    public void testLT() throws Exception {
        CommonTree commonTree = new CommonTree(new CommonToken(101));
        commonTree.addChild(new CommonTree(new CommonToken(102)));
        commonTree.getChild(0).addChild(new CommonTree(new CommonToken(103)));
        commonTree.addChild(new CommonTree(new CommonToken(104)));
        TreeNodeStream treeNodeStream = this.newStream(commonTree);
        TestTreeNodeStream.assertEquals((int)101, (int)((Tree)treeNodeStream.LT(1)).getType());
        TestTreeNodeStream.assertEquals((int)2, (int)((Tree)treeNodeStream.LT(2)).getType());
        TestTreeNodeStream.assertEquals((int)102, (int)((Tree)treeNodeStream.LT(3)).getType());
        TestTreeNodeStream.assertEquals((int)2, (int)((Tree)treeNodeStream.LT(4)).getType());
        TestTreeNodeStream.assertEquals((int)103, (int)((Tree)treeNodeStream.LT(5)).getType());
        TestTreeNodeStream.assertEquals((int)3, (int)((Tree)treeNodeStream.LT(6)).getType());
        TestTreeNodeStream.assertEquals((int)104, (int)((Tree)treeNodeStream.LT(7)).getType());
        TestTreeNodeStream.assertEquals((int)3, (int)((Tree)treeNodeStream.LT(8)).getType());
        TestTreeNodeStream.assertEquals((int)-1, (int)((Tree)treeNodeStream.LT(9)).getType());
        TestTreeNodeStream.assertEquals((int)-1, (int)((Tree)treeNodeStream.LT(100)).getType());
    }

    public void testMarkRewindEntire() throws Exception {
        int n;
        CommonTree commonTree = new CommonTree(new CommonToken(101));
        CommonTree commonTree2 = new CommonTree(new CommonToken(102));
        commonTree.addChild(commonTree2);
        commonTree2.addChild(new CommonTree(new CommonToken(103)));
        CommonTree commonTree3 = new CommonTree(new CommonToken(106));
        commonTree3.addChild(new CommonTree(new CommonToken(107)));
        commonTree2.addChild(commonTree3);
        commonTree.addChild(new CommonTree(new CommonToken(104)));
        commonTree.addChild(new CommonTree(new CommonToken(105)));
        CommonTreeNodeStream commonTreeNodeStream = new CommonTreeNodeStream(commonTree);
        int n2 = commonTreeNodeStream.mark();
        for (n = 1; n <= 13; ++n) {
            commonTreeNodeStream.LT(1);
            commonTreeNodeStream.consume();
        }
        TestTreeNodeStream.assertEquals((int)-1, (int)((Tree)commonTreeNodeStream.LT(1)).getType());
        TestTreeNodeStream.assertEquals((int)3, (int)((Tree)commonTreeNodeStream.LT(-1)).getType());
        commonTreeNodeStream.rewind(n2);
        for (n = 1; n <= 13; ++n) {
            commonTreeNodeStream.LT(1);
            commonTreeNodeStream.consume();
        }
        TestTreeNodeStream.assertEquals((int)-1, (int)((Tree)commonTreeNodeStream.LT(1)).getType());
        TestTreeNodeStream.assertEquals((int)3, (int)((Tree)commonTreeNodeStream.LT(-1)).getType());
    }

    public void testMarkRewindInMiddle() throws Exception {
        int n;
        CommonTree commonTree = new CommonTree(new CommonToken(101));
        CommonTree commonTree2 = new CommonTree(new CommonToken(102));
        commonTree.addChild(commonTree2);
        commonTree2.addChild(new CommonTree(new CommonToken(103)));
        CommonTree commonTree3 = new CommonTree(new CommonToken(106));
        commonTree3.addChild(new CommonTree(new CommonToken(107)));
        commonTree2.addChild(commonTree3);
        commonTree.addChild(new CommonTree(new CommonToken(104)));
        commonTree.addChild(new CommonTree(new CommonToken(105)));
        CommonTreeNodeStream commonTreeNodeStream = new CommonTreeNodeStream(commonTree);
        for (n = 1; n <= 7; ++n) {
            commonTreeNodeStream.consume();
        }
        TestTreeNodeStream.assertEquals((int)107, (int)((Tree)commonTreeNodeStream.LT(1)).getType());
        n = commonTreeNodeStream.mark();
        commonTreeNodeStream.consume();
        commonTreeNodeStream.consume();
        commonTreeNodeStream.consume();
        commonTreeNodeStream.consume();
        commonTreeNodeStream.rewind(n);
        TestTreeNodeStream.assertEquals((int)107, (int)((Tree)commonTreeNodeStream.LT(1)).getType());
        commonTreeNodeStream.consume();
        TestTreeNodeStream.assertEquals((int)3, (int)((Tree)commonTreeNodeStream.LT(1)).getType());
        commonTreeNodeStream.consume();
        TestTreeNodeStream.assertEquals((int)3, (int)((Tree)commonTreeNodeStream.LT(1)).getType());
        commonTreeNodeStream.consume();
        TestTreeNodeStream.assertEquals((int)104, (int)((Tree)commonTreeNodeStream.LT(1)).getType());
        commonTreeNodeStream.consume();
        TestTreeNodeStream.assertEquals((int)105, (int)((Tree)commonTreeNodeStream.LT(1)).getType());
        commonTreeNodeStream.consume();
        TestTreeNodeStream.assertEquals((int)3, (int)((Tree)commonTreeNodeStream.LT(1)).getType());
        commonTreeNodeStream.consume();
        TestTreeNodeStream.assertEquals((int)-1, (int)((Tree)commonTreeNodeStream.LT(1)).getType());
        TestTreeNodeStream.assertEquals((int)3, (int)((Tree)commonTreeNodeStream.LT(-1)).getType());
    }

    public void testMarkRewindNested() throws Exception {
        CommonTree commonTree = new CommonTree(new CommonToken(101));
        CommonTree commonTree2 = new CommonTree(new CommonToken(102));
        commonTree.addChild(commonTree2);
        commonTree2.addChild(new CommonTree(new CommonToken(103)));
        CommonTree commonTree3 = new CommonTree(new CommonToken(106));
        commonTree3.addChild(new CommonTree(new CommonToken(107)));
        commonTree2.addChild(commonTree3);
        commonTree.addChild(new CommonTree(new CommonToken(104)));
        commonTree.addChild(new CommonTree(new CommonToken(105)));
        CommonTreeNodeStream commonTreeNodeStream = new CommonTreeNodeStream(commonTree);
        int n = commonTreeNodeStream.mark();
        commonTreeNodeStream.consume();
        commonTreeNodeStream.consume();
        int n2 = commonTreeNodeStream.mark();
        commonTreeNodeStream.consume();
        commonTreeNodeStream.consume();
        commonTreeNodeStream.consume();
        commonTreeNodeStream.consume();
        commonTreeNodeStream.rewind(n2);
        TestTreeNodeStream.assertEquals((int)102, (int)((Tree)commonTreeNodeStream.LT(1)).getType());
        commonTreeNodeStream.consume();
        TestTreeNodeStream.assertEquals((int)2, (int)((Tree)commonTreeNodeStream.LT(1)).getType());
        commonTreeNodeStream.consume();
        commonTreeNodeStream.rewind(n);
        TestTreeNodeStream.assertEquals((int)101, (int)((Tree)commonTreeNodeStream.LT(1)).getType());
        commonTreeNodeStream.consume();
        TestTreeNodeStream.assertEquals((int)2, (int)((Tree)commonTreeNodeStream.LT(1)).getType());
        commonTreeNodeStream.consume();
        TestTreeNodeStream.assertEquals((int)102, (int)((Tree)commonTreeNodeStream.LT(1)).getType());
        commonTreeNodeStream.consume();
        TestTreeNodeStream.assertEquals((int)2, (int)((Tree)commonTreeNodeStream.LT(1)).getType());
    }

    public void testSeek() throws Exception {
        CommonTree commonTree = new CommonTree(new CommonToken(101));
        CommonTree commonTree2 = new CommonTree(new CommonToken(102));
        commonTree.addChild(commonTree2);
        commonTree2.addChild(new CommonTree(new CommonToken(103)));
        CommonTree commonTree3 = new CommonTree(new CommonToken(106));
        commonTree3.addChild(new CommonTree(new CommonToken(107)));
        commonTree2.addChild(commonTree3);
        commonTree.addChild(new CommonTree(new CommonToken(104)));
        commonTree.addChild(new CommonTree(new CommonToken(105)));
        CommonTreeNodeStream commonTreeNodeStream = new CommonTreeNodeStream(commonTree);
        commonTreeNodeStream.consume();
        commonTreeNodeStream.consume();
        commonTreeNodeStream.consume();
        commonTreeNodeStream.seek(7);
        TestTreeNodeStream.assertEquals((int)107, (int)((Tree)commonTreeNodeStream.LT(1)).getType());
        commonTreeNodeStream.consume();
        commonTreeNodeStream.consume();
        commonTreeNodeStream.consume();
        TestTreeNodeStream.assertEquals((int)104, (int)((Tree)commonTreeNodeStream.LT(1)).getType());
    }

    public void testSeekFromStart() throws Exception {
        CommonTree commonTree = new CommonTree(new CommonToken(101));
        CommonTree commonTree2 = new CommonTree(new CommonToken(102));
        commonTree.addChild(commonTree2);
        commonTree2.addChild(new CommonTree(new CommonToken(103)));
        CommonTree commonTree3 = new CommonTree(new CommonToken(106));
        commonTree3.addChild(new CommonTree(new CommonToken(107)));
        commonTree2.addChild(commonTree3);
        commonTree.addChild(new CommonTree(new CommonToken(104)));
        commonTree.addChild(new CommonTree(new CommonToken(105)));
        CommonTreeNodeStream commonTreeNodeStream = new CommonTreeNodeStream(commonTree);
        commonTreeNodeStream.seek(7);
        TestTreeNodeStream.assertEquals((int)107, (int)((Tree)commonTreeNodeStream.LT(1)).getType());
        commonTreeNodeStream.consume();
        commonTreeNodeStream.consume();
        commonTreeNodeStream.consume();
        TestTreeNodeStream.assertEquals((int)104, (int)((Tree)commonTreeNodeStream.LT(1)).getType());
    }

    public String toNodesOnlyString(TreeNodeStream treeNodeStream) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < treeNodeStream.size(); ++i) {
            Object object = treeNodeStream.LT(i + 1);
            int n = treeNodeStream.getTreeAdaptor().getType(object);
            if (n == 2 || n == 3) continue;
            stringBuffer.append(" ");
            stringBuffer.append(n);
        }
        return stringBuffer.toString();
    }
}

