/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class SIZE
extends Protocol {
    final Vector members = new Vector();
    boolean print_msg = false;
    boolean raw_buffer = false;
    long min_size = 0L;
    final ByteArrayOutputStream out_stream = new ByteArrayOutputStream(65535);

    public String getName() {
        return "SIZE";
    }

    public void init() {
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("print_msg");
        if (str != null) {
            this.print_msg = Boolean.valueOf(str);
            props.remove("print_msg");
        }
        if ((str = props.getProperty("raw_buffer")) != null) {
            this.raw_buffer = Boolean.valueOf(str);
            props.remove("raw_buffer");
        }
        if ((str = props.getProperty("min_size")) != null) {
            this.min_size = Integer.parseInt(str);
            props.remove("min_size");
        }
        if (props.size() > 0) {
            this.log.error((Object)("the following properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    public void up(Event evt) {
        int payload_size = 0;
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                payload_size = msg.getLength();
                if (this.raw_buffer) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("size of message buffer is " + payload_size + ", " + this.numHeaders(msg) + " headers"));
                    }
                } else {
                    int serialized_size = this.sizeOf(msg);
                    if ((long)serialized_size > this.min_size && this.log.isTraceEnabled()) {
                        this.log.trace((Object)("size of serialized message is " + serialized_size + ", " + this.numHeaders(msg) + " headers"));
                    }
                }
                if (!this.print_msg || !this.log.isTraceEnabled()) break;
                this.log.trace((Object)("headers are " + msg.getHeaders() + ", payload size=" + payload_size));
            }
        }
        this.passUp(evt);
    }

    public void down(Event evt) {
        int payload_size = 0;
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                payload_size = msg.getLength();
                if (this.raw_buffer) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("size of message buffer is " + payload_size + ", " + this.numHeaders(msg) + " headers"));
                    }
                } else {
                    int serialized_size = this.sizeOf(msg);
                    if ((long)serialized_size > this.min_size && this.log.isTraceEnabled()) {
                        this.log.trace((Object)("size of serialized message is " + serialized_size + ", " + this.numHeaders(msg) + " headers"));
                    }
                }
                if (!this.print_msg || !this.log.isTraceEnabled()) break;
                this.log.trace((Object)("headers are " + msg.getHeaders() + ", payload size=" + payload_size));
            }
        }
        this.passDown(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int sizeOf(Message msg) {
        DataOutputStream out = null;
        ByteArrayOutputStream byteArrayOutputStream = this.out_stream;
        synchronized (byteArrayOutputStream) {
            int n;
            try {
                this.out_stream.reset();
                out = new DataOutputStream(this.out_stream);
                msg.writeTo(out);
                out.flush();
                n = this.out_stream.size();
            }
            catch (Exception e) {
                int n2;
                try {
                    n2 = 0;
                }
                catch (Throwable throwable) {
                    Util.close(out);
                    throw throwable;
                }
                Util.close(out);
                return n2;
            }
            Util.close(out);
            return n;
        }
    }

    int numHeaders(Message msg) {
        if (msg == null) {
            return 0;
        }
        Map hdrs = msg.getHeaders();
        return hdrs != null ? hdrs.size() : 0;
    }
}

