/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.builder;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.drools.base.ClassObjectType;
import org.drools.base.DroolsQuery;
import org.drools.common.InstanceNotEqualsConstraint;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.AlphaNode;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.builder.BuildContext;
import org.drools.reteoo.builder.BuildUtils;
import org.drools.reteoo.builder.ReteooComponentBuilder;
import org.drools.rule.Declaration;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.Pattern;
import org.drools.rule.PatternSource;
import org.drools.rule.RuleConditionElement;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.Constraint;
import org.drools.spi.ObjectType;

public class PatternBuilder
implements ReteooComponentBuilder {
    public void build(BuildContext context, BuildUtils utils, RuleConditionElement rce) {
        Pattern pattern = (Pattern)rce;
        this.attachPattern(context, utils, pattern);
    }

    private void attachPattern(BuildContext context, BuildUtils utils, Pattern pattern) throws InvalidPatternException {
        pattern.setOffset(context.getCurrentPatternOffset());
        LinkedList alphaConstraints = new LinkedList();
        LinkedList betaConstraints = new LinkedList();
        this.createConstraints(context, utils, pattern, alphaConstraints, betaConstraints);
        context.setBetaconstraints(betaConstraints);
        if (pattern.getSource() == null) {
            this.attachAlphaNodes(context, utils, pattern, alphaConstraints);
        } else {
            context.setAlphaConstraints(alphaConstraints);
            int currentOffset = context.getCurrentPatternOffset();
            PatternSource source = pattern.getSource();
            ReteooComponentBuilder builder = utils.getBuilderFor(source);
            builder.build(context, utils, source);
            context.setCurrentPatternOffset(currentOffset);
        }
        context.incrementCurrentPatternOffset();
    }

    private void createConstraints(BuildContext context, BuildUtils utils, Pattern pattern, List alphaConstraints, List betaConstraints) {
        List constraints = pattern.getConstraints();
        this.checkRemoveIdentities(context, pattern, betaConstraints);
        Iterator it = constraints.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof Declaration) continue;
            Constraint constraint = (Constraint)object;
            Declaration[] declarations = constraint.getRequiredDeclarations();
            boolean isAlphaConstraint = true;
            for (int i = 0; isAlphaConstraint && i < declarations.length; ++i) {
                if (declarations[i].isGlobal() || declarations[i].getPattern() == pattern) continue;
                isAlphaConstraint = false;
            }
            if (isAlphaConstraint) {
                alphaConstraints.add(constraint);
                continue;
            }
            utils.checkUnboundDeclarations(context, constraint.getRequiredDeclarations());
            betaConstraints.add(constraint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectTypeNode attachObjectTypeNode(BuildContext context, ObjectType objectType) {
        Map map = context.getRuleBase().getPackagesMap();
        synchronized (map) {
            ObjectTypeNode otn = new ObjectTypeNode(context.getNextId(), objectType, context);
            InternalWorkingMemory[] wms = context.getWorkingMemories();
            if (wms.length > 0) {
                otn.attach(wms);
            } else {
                otn.attach();
            }
            return otn;
        }
    }

    public void attachAlphaNodes(BuildContext context, BuildUtils utils, Pattern pattern, List alphaConstraints) throws InvalidPatternException {
        boolean objectMemory = context.isObjectTypeNodeMemoryEnabled();
        boolean alphaMemory = context.isAlphaMemoryAllowed();
        if (pattern.getObjectType() instanceof ClassObjectType && DroolsQuery.class == ((ClassObjectType)pattern.getObjectType()).getClassType()) {
            context.setTupleMemoryEnabled(false);
            context.setObjectTypeNodeMemoryEnabled(false);
            context.setTerminalNodeMemoryEnabled(false);
            context.setAlphaNodeMemoryAllowed(false);
        }
        context.setObjectSource((ObjectSource)utils.attachNode(context, new ObjectTypeNode(context.getNextId(), pattern.getObjectType(), context)));
        Iterator it = alphaConstraints.iterator();
        while (it.hasNext()) {
            AlphaNodeFieldConstraint constraint = (AlphaNodeFieldConstraint)it.next();
            context.setObjectSource((ObjectSource)utils.attachNode(context, new AlphaNode(context.getNextId(), constraint, context.getObjectSource(), context)));
        }
        context.setObjectTypeNodeMemoryEnabled(objectMemory);
        context.setAlphaNodeMemoryAllowed(alphaMemory);
    }

    private void checkRemoveIdentities(BuildContext context, Pattern pattern, List betaConstraints) {
        if (context.getRuleBase().getConfiguration().isRemoveIdentities() && pattern.getObjectType().getClass() == ClassObjectType.class) {
            Object patterns = null;
            Class thisClass = ((ClassObjectType)pattern.getObjectType()).getClassType();
            Iterator it = context.getObjectType().iterator();
            while (it.hasNext()) {
                Pattern previousPattern = (Pattern)it.next();
                Class previousClass = ((ClassObjectType)previousPattern.getObjectType()).getClassType();
                if (!thisClass.isAssignableFrom(previousClass)) continue;
                betaConstraints.add(new InstanceNotEqualsConstraint(previousPattern));
            }
            context.getObjectType().add(pattern);
        }
    }

    public boolean requiresLeftActivation(BuildUtils utils, RuleConditionElement rce) {
        return ((Pattern)rce).getSource() != null;
    }
}

