/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import org.drools.base.BaseEvaluator;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EvaluatorFactory;
import org.drools.base.evaluators.Operator;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.Extractor;
import org.drools.spi.FieldValue;

public class FactTemplateFactory
implements EvaluatorFactory {
    private static final long serialVersionUID = 400L;
    private static EvaluatorFactory INSTANCE = new FactTemplateFactory();

    private FactTemplateFactory() {
    }

    public static EvaluatorFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FactTemplateFactory();
        }
        return INSTANCE;
    }

    public Evaluator getEvaluator(Operator operator) {
        if (operator == Operator.EQUAL) {
            return FactTemplateEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.NOT_EQUAL) {
            return FactTemplateNotEqualEvaluator.INSTANCE;
        }
        throw new RuntimeException("Operator '" + operator + "' does not exist for FactTemplateEvaluator");
    }

    static class FactTemplateNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new FactTemplateNotEqualEvaluator();

        private FactTemplateNotEqualEvaluator() {
            super(ValueType.FACTTEMPLATE_TYPE, Operator.NOT_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            Object value1 = extractor.getValue(workingMemory, object1);
            Object value2 = object2.getValue();
            if (value1 == null) {
                return value2 != null;
            }
            return !value1.equals(value2);
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            Object value = context.declaration.getExtractor().getValue(workingMemory, left);
            if (value == null) {
                return ((VariableRestriction.ObjectVariableContextEntry)context).right != null;
            }
            return !value.equals(((VariableRestriction.ObjectVariableContextEntry)context).right);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            Object value = context.extractor.getValue(workingMemory, right);
            if (((VariableRestriction.ObjectVariableContextEntry)context).left == null) {
                return value != null;
            }
            return !((VariableRestriction.ObjectVariableContextEntry)context).left.equals(value);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            Object value1 = extractor1.getValue(workingMemory, object1);
            Object value2 = extractor2.getValue(workingMemory, object2);
            if (value1 == null) {
                return value2 != null;
            }
            return !value1.equals(value2);
        }

        public String toString() {
            return "FactTemplate !=";
        }
    }

    static class FactTemplateEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new FactTemplateEqualEvaluator();

        private FactTemplateEqualEvaluator() {
            super(ValueType.FACTTEMPLATE_TYPE, Operator.EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            Object value1 = extractor.getValue(workingMemory, object1);
            Object value2 = object2.getValue();
            if (value1 == null) {
                return value2 == null;
            }
            return value1.equals(value2);
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            Object value = context.declaration.getExtractor().getValue(workingMemory, left);
            if (value == null) {
                return ((VariableRestriction.ObjectVariableContextEntry)context).right == null;
            }
            return value.equals(((VariableRestriction.ObjectVariableContextEntry)context).right);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            Object value = context.extractor.getValue(workingMemory, right);
            if (((VariableRestriction.ObjectVariableContextEntry)context).left == null) {
                return value == null;
            }
            return ((VariableRestriction.ObjectVariableContextEntry)context).left.equals(value);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            Object value1 = extractor1.getValue(workingMemory, object1);
            Object value2 = extractor2.getValue(workingMemory, object2);
            if (value1 == null) {
                return value2 == null;
            }
            return value1.equals(value2);
        }

        public String toString() {
            return "FactTemplate ==";
        }
    }
}

