/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.accumulators;

import org.drools.base.accumulators.AccumulateFunction;

public class CountAccumulateFunction
implements AccumulateFunction {
    public Object createContext() {
        return new CountData();
    }

    public void init(Object context) throws Exception {
        CountData data = (CountData)context;
        data.count = 0L;
    }

    public void accumulate(Object context, Object value) {
        CountData data = (CountData)context;
        ++data.count;
    }

    public void reverse(Object context, Object value) throws Exception {
        CountData data = (CountData)context;
        --data.count;
    }

    public Object getResult(Object context) throws Exception {
        CountData data = (CountData)context;
        return new Long(data.count);
    }

    public boolean supportsReverse() {
        return true;
    }

    protected static class CountData {
        public long count = 0L;

        protected CountData() {
        }
    }
}

