/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.tests.perftests;

import java.io.Serializable;
import ognl.Ognl;
import org.mvel.MVEL;

public class SimplePerfTests {
    public static void main(String[] args) throws Exception {
        String expression = "foo.bar.name";
        int iterations = 100000;
        Base base = new Base();
        Serializable mvelCompiled = MVEL.compileExpression(expression);
        Object ognlCompiled = Ognl.parseExpression((String)expression);
        for (int repeat = 0; repeat < 2; ++repeat) {
            int i;
            long tm = System.currentTimeMillis();
            for (i = 0; i < iterations; ++i) {
                MVEL.executeExpression((Object)mvelCompiled, base);
            }
            if (repeat != 0) {
                System.out.println("MVEL  : " + (System.currentTimeMillis() - tm) + "ms");
            }
            tm = System.currentTimeMillis();
            for (i = 0; i < iterations; ++i) {
                Ognl.getValue((Object)ognlCompiled, (Object)base);
            }
            if (repeat == 0) continue;
            System.out.println("OGNL  : " + (System.currentTimeMillis() - tm) + "ms");
        }
    }

    public static class Bar {
        private String name = "test";

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class Foo {
        private Bar bar = new Bar();

        public Bar getBar() {
            return this.bar;
        }

        public void setBar(Bar bar) {
            this.bar = bar;
        }
    }

    public static class Base {
        private Foo foo = new Foo();

        public Foo getFoo() {
            return this.foo;
        }

        public void setFoo(Foo foo) {
            this.foo = foo;
        }
    }
}

