/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.tests.main;

import java.awt.Dimension;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.mvel.ASTNode;
import org.mvel.CompileException;
import org.mvel.CompiledExpression;
import org.mvel.ExpressionCompiler;
import org.mvel.MVEL;
import org.mvel.MVELRuntime;
import org.mvel.Macro;
import org.mvel.ParserContext;
import org.mvel.PropertyAccessor;
import org.mvel.ast.WithNode;
import org.mvel.debug.DebugTools;
import org.mvel.debug.Debugger;
import org.mvel.debug.Frame;
import org.mvel.integration.Interceptor;
import org.mvel.integration.ResolverTools;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.integration.impl.ClassImportResolverFactory;
import org.mvel.integration.impl.DefaultLocalVariableResolverFactory;
import org.mvel.integration.impl.MapVariableResolverFactory;
import org.mvel.integration.impl.StaticMethodImportResolverFactory;
import org.mvel.optimizers.OptimizerFactory;
import org.mvel.tests.main.AbstractTest;
import org.mvel.tests.main.res.Bar;
import org.mvel.tests.main.res.Base;
import org.mvel.tests.main.res.Cheese;
import org.mvel.tests.main.res.DefaultKnowledgeHelper;
import org.mvel.tests.main.res.Foo;
import org.mvel.tests.main.res.KnowledgeHelper;
import org.mvel.tests.main.res.RuleBaseImpl;
import org.mvel.tests.main.res.WorkingMemoryImpl;
import org.mvel.util.MethodStub;

public class CoreConfidenceTests
extends AbstractTest {
    private Map<Object, Object> outerMap;
    private Map<Object, Object> innerMap;
    private HashMap<String, Object> context = new HashMap();

    public void testSingleProperty() {
        CoreConfidenceTests.assertEquals((Object)false, (Object)this.test("fun"));
    }

    public void testMethodOnValue() {
        CoreConfidenceTests.assertEquals((Object)"DOG", (Object)this.test("foo.bar.name.toUpperCase()"));
    }

    public void testSimpleProperty() {
        CoreConfidenceTests.assertEquals((Object)"dog", (Object)this.test("foo.bar.name"));
    }

    public void testSimpleProperty2() {
        CoreConfidenceTests.assertEquals((Object)"cat", (Object)this.test("DATA"));
    }

    public void testPropertyViaDerivedClass() {
        CoreConfidenceTests.assertEquals((Object)"cat", (Object)this.test("derived.data"));
    }

    public void testDeepAssignment() {
        CoreConfidenceTests.assertEquals((Object)"crap", (Object)this.test("foo.bar.assignTest = 'crap'"));
        CoreConfidenceTests.assertEquals((Object)"crap", (Object)this.test("foo.bar.assignTest"));
    }

    public void testThroughInterface() {
        CoreConfidenceTests.assertEquals((Object)"FOOBAR!", (Object)this.test("testImpl.name"));
    }

    public void testThroughInterface2() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("testImpl.foo"));
    }

    public void testMapAccessWithMethodCall() {
        CoreConfidenceTests.assertEquals((Object)"happyBar", (Object)this.test("funMap['foo'].happy()"));
    }

    public void testSimpleIfStatement() {
        this.test("if (true) { System.out.println(\"test!\") }  \n");
    }

    public void testBooleanOperator() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("foo.bar.woof == true"));
    }

    public void testBooleanOperator2() {
        CoreConfidenceTests.assertEquals((Object)false, (Object)this.test("foo.bar.woof == false"));
    }

    public void testBooleanOperator3() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("foo.bar.woof== true"));
    }

    public void testBooleanOperator4() {
        CoreConfidenceTests.assertEquals((Object)false, (Object)this.test("foo.bar.woof ==false"));
    }

    public void testBooleanOperator5() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("foo.bar.woof == true"));
    }

    public void testBooleanOperator6() {
        CoreConfidenceTests.assertEquals((Object)false, (Object)this.test("foo.bar.woof==false"));
    }

    public void testTextComparison() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("foo.bar.name == 'dog'"));
    }

    public void testNETextComparison() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("foo.bar.name != 'foo'"));
    }

    public void testChor() {
        CoreConfidenceTests.assertEquals((Object)"cat", (Object)this.test("a or b or c"));
    }

    public void testChorWithLiteral() {
        CoreConfidenceTests.assertEquals((Object)"fubar", (Object)this.test("a or 'fubar'"));
    }

    public void testNullCompare() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("c != null"));
    }

    public void testUninitializedInt() {
        CoreConfidenceTests.assertEquals((Object)0, (Object)this.test("sarahl"));
    }

    public void testAnd() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("c != null && foo.bar.name == 'dog' && foo.bar.woof"));
    }

    public void testAnd2() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("c!=null&&foo.bar.name=='dog'&&foo.bar.woof"));
    }

    public void testMath() {
        CoreConfidenceTests.assertEquals((Object)Float.valueOf(188.4f), (Object)this.test("pi * hour"));
    }

    public void testMath2() {
        CoreConfidenceTests.assertEquals((Object)3, (Object)this.test("foo.number-1"));
    }

    public void testPowerOf() {
        CoreConfidenceTests.assertEquals((Object)25, (Object)this.test("5 ** 2"));
    }

    public void testWhileUsingImports() {
        HashMap<String, Object> imports = new HashMap<String, Object>();
        imports.put("ArrayList", ArrayList.class);
        imports.put("List", List.class);
        ParserContext context = new ParserContext(imports, null, "testfile");
        ExpressionCompiler compiler = new ExpressionCompiler("List list = new ArrayList(); return (list == empty)");
        CoreConfidenceTests.assertTrue((boolean)((Boolean)MVEL.executeExpression((Object)compiler.compile(context), new DefaultLocalVariableResolverFactory())));
    }

    public void testComplexExpression() {
        CoreConfidenceTests.assertEquals((Object)"bar", (Object)this.test("a = 'foo'; b = 'bar'; c = 'jim'; list = {a,b,c}; list[1]"));
    }

    public void testComplexAnd() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("(pi * hour) > 0 && foo.happy() == 'happyBar'"));
    }

    public void testShortPathExpression() {
        CoreConfidenceTests.assertEquals(null, (Object)this.test("3 > 4 && foo.toUC('test'); foo.register"));
    }

    public void testShortPathExpression2() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("4 > 3 || foo.toUC('test')"));
    }

    public void testShortPathExpression4() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("4>3||foo.toUC('test')"));
    }

    public void testOrOperator() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("true||true"));
    }

    public void testOrOperator2() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("2 > 3 || 3 > 2"));
    }

    public void testOrOperator3() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("pi > 5 || pi > 6 || pi > 3"));
    }

    public void testShortPathExpression3() {
        CoreConfidenceTests.assertEquals((Object)false, (Object)this.test("defnull != null  && defnull.length() > 0"));
    }

    public void testModulus() {
        CoreConfidenceTests.assertEquals((Object)0, (Object)this.test("38392 % 2"));
    }

    public void testLessThan() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("pi < 3.15"));
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("pi <= 3.14"));
        CoreConfidenceTests.assertEquals((Object)false, (Object)this.test("pi > 3.14"));
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("pi >= 3.14"));
    }

    public void testMethodAccess() {
        CoreConfidenceTests.assertEquals((Object)"happyBar", (Object)this.test("foo.happy()"));
    }

    public void testMethodAccess2() {
        CoreConfidenceTests.assertEquals((Object)"FUBAR", (Object)this.test("foo.toUC( 'fubar' )"));
    }

    public void testMethodAccess3() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("equalityCheck(c, 'cat')"));
    }

    public void testMethodAccess4() {
        CoreConfidenceTests.assertEquals(null, (Object)this.test("readBack(null)"));
    }

    public void testMethodAccess5() {
        CoreConfidenceTests.assertEquals((Object)"nulltest", (Object)this.test("appendTwoStrings(null, 'test')"));
    }

    public void testMethodAccess6() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("   equalityCheck(   c  \n  ,   \n   'cat'      )   "));
    }

    public void testNegation() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("!fun && !fun"));
    }

    public void testNegation2() {
        CoreConfidenceTests.assertEquals((Object)false, (Object)this.test("fun && !fun"));
    }

    public void testNegation3() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("!(fun && fun)"));
    }

    public void testNegation4() {
        CoreConfidenceTests.assertEquals((Object)false, (Object)this.test("(fun && fun)"));
    }

    public void testMultiStatement() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("populate(); barfoo == 'sarah'"));
    }

    public void testAssignment() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("populate(); blahfoo = 'sarah'; blahfoo == 'sarah'"));
    }

    public void testAssignment2() {
        CoreConfidenceTests.assertEquals((Object)"sarah", (Object)this.test("populate(); blahfoo = barfoo"));
    }

    public void testAssignment3() {
        CoreConfidenceTests.assertEquals(Integer.class, this.test("blah = 5").getClass());
    }

    public void testAssignment4() {
        CoreConfidenceTests.assertEquals((Object)102, (Object)this.test("a = 100 + 1 + 1"));
    }

    public void testOr() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("fun || true"));
    }

    public void testLiteralPassThrough() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("true"));
    }

    public void testLiteralPassThrough2() {
        CoreConfidenceTests.assertEquals((Object)false, (Object)this.test("false"));
    }

    public void testLiteralPassThrough3() {
        CoreConfidenceTests.assertEquals(null, (Object)this.test("null"));
    }

    public void testRegEx() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("foo.bar.name ~= '[a-z].+'"));
    }

    public void testRegExNegate() {
        CoreConfidenceTests.assertEquals((Object)false, (Object)this.test("!(foo.bar.name ~= '[a-z].+')"));
    }

    public void testRegEx2() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("foo.bar.name ~= '[a-z].+' && foo.bar.name != null"));
    }

    public void testRegEx3() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("foo.bar.name~='[a-z].+'&&foo.bar.name!=null"));
    }

    public void testBlank() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("'' == empty"));
    }

    public void testBlank2() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("BWAH == empty"));
    }

    public void testBooleanModeOnly2() {
        CoreConfidenceTests.assertEquals((Object)false, (Object)MVEL.evalToBoolean("BWAH", (Object)this.base, this.map));
    }

    public void testBooleanModeOnly4() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)MVEL.evalToBoolean("hour == (hour + 0)", (Object)this.base, this.map));
    }

    public void testTernary() {
        CoreConfidenceTests.assertEquals((Object)"foobie", (Object)this.test("zero==0?'foobie':zero"));
    }

    public void testTernary2() {
        CoreConfidenceTests.assertEquals((Object)"blimpie", (Object)this.test("zero==1?'foobie':'blimpie'"));
    }

    public void testTernary3() {
        CoreConfidenceTests.assertEquals((Object)"foobiebarbie", (Object)this.test("zero==1?'foobie':'foobie'+'barbie'"));
    }

    public void testStrAppend() {
        CoreConfidenceTests.assertEquals((Object)"foobarcar", (Object)this.test("'foo' + 'bar' + 'car'"));
    }

    public void testStrAppend2() {
        CoreConfidenceTests.assertEquals((Object)"foobarcar1", (Object)this.test("'foobar' + 'car' + 1"));
    }

    public void testInstanceCheck1() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("c is java.lang.String"));
    }

    public void testInstanceCheck2() {
        CoreConfidenceTests.assertEquals((Object)false, (Object)this.test("pi is java.lang.Integer"));
    }

    public void testInstanceCheck3() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("foo is org.mvel.tests.main.res.Foo"));
    }

    public void testBitwiseOr1() {
        CoreConfidenceTests.assertEquals((Object)6, (Object)this.test("2|4"));
    }

    public void testBitwiseOr2() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("(2 | 1) > 0"));
    }

    public void testBitwiseOr3() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("(2|1) == 3"));
    }

    public void testBitwiseAnd1() {
        CoreConfidenceTests.assertEquals((Object)2, (Object)this.test("2 & 3"));
    }

    public void testShiftLeft() {
        CoreConfidenceTests.assertEquals((Object)4, (Object)this.test("2 << 1"));
    }

    public void testUnsignedShiftLeft() {
        CoreConfidenceTests.assertEquals((Object)2, (Object)this.test("-2 <<< 0"));
    }

    public void testShiftRight() {
        CoreConfidenceTests.assertEquals((Object)128, (Object)this.test("256 >> 1"));
    }

    public void testXOR() {
        CoreConfidenceTests.assertEquals((Object)3, (Object)this.test("1 ^ 2"));
    }

    public void testContains1() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("list contains 'Happy!'"));
    }

    public void testContains2() {
        CoreConfidenceTests.assertEquals((Object)false, (Object)this.test("list contains 'Foobie'"));
    }

    public void testContains3() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("sentence contains 'fox'"));
    }

    public void testContains4() {
        CoreConfidenceTests.assertEquals((Object)false, (Object)this.test("sentence contains 'mike'"));
    }

    public void testContains5() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("!(sentence contains 'mike')"));
    }

    public void testContains6() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("bwahbwah = 'mikebrock'; testVar10 = 'mike'; bwahbwah contains testVar10"));
    }

    public void testInvert() {
        CoreConfidenceTests.assertEquals((Object)-11, (Object)this.test("~10"));
    }

    public void testInvert2() {
        CoreConfidenceTests.assertEquals((Object)-12, (Object)this.test("~(10 + 1)"));
    }

    public void testInvert3() {
        CoreConfidenceTests.assertEquals((Object)-61, (Object)this.test("~10 + (1 + ~50)"));
    }

    public void testListCreation2() {
        CoreConfidenceTests.assertTrue((boolean)(this.test("[\"test\"]") instanceof List));
    }

    public void testListCreation3() {
        CoreConfidenceTests.assertTrue((boolean)(this.test("[66]") instanceof List));
    }

    public void testListCreation4() {
        List ar = (List)this.test("[   66   , \"test\"   ]");
        CoreConfidenceTests.assertEquals((int)2, (int)ar.size());
        CoreConfidenceTests.assertEquals((Object)66, ar.get(0));
        CoreConfidenceTests.assertEquals((Object)"test", ar.get(1));
    }

    public void testListCreationWithCall() {
        CoreConfidenceTests.assertEquals((Object)1, (Object)this.test("[\"apple\"].size()"));
    }

    public void testArrayCreationWithLength() {
        CoreConfidenceTests.assertEquals((Object)2, (Object)this.test("Array.getLength({'foo', 'bar'})"));
    }

    public void testEmptyList() {
        CoreConfidenceTests.assertTrue((boolean)(this.test("[]") instanceof List));
    }

    public void testEmptyArray() {
        CoreConfidenceTests.assertTrue((((Object[])this.test("{}")).length == 0 ? 1 : 0) != 0);
    }

    public void testEmptyArray2() {
        CoreConfidenceTests.assertTrue((((Object[])this.test("{    }")).length == 0 ? 1 : 0) != 0);
    }

    public void testArrayCreation() {
        CoreConfidenceTests.assertEquals((Object)0, (Object)this.test("arrayTest = {{1, 2, 3}, {2, 1, 0}}; arrayTest[1][2]"));
    }

    public void testMapCreation() {
        CoreConfidenceTests.assertEquals((Object)"sarah", (Object)this.test("map = ['mike':'sarah','tom':'jacquelin']; map['mike']"));
    }

    public void testMapCreation2() {
        CoreConfidenceTests.assertEquals((Object)"sarah", (Object)this.test("map = ['mike' :'sarah'  ,'tom'  :'jacquelin'  ]; map['mike']"));
    }

    public void testMapCreation3() {
        CoreConfidenceTests.assertEquals((Object)"foo", (Object)this.test("map = [1 : 'foo']; map[1]"));
    }

    public void testProjectionSupport() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("(name in things)contains'Bob'"));
    }

    public void testProjectionSupport1() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("(name in things) contains 'Bob'"));
    }

    public void testProjectionSupport2() {
        CoreConfidenceTests.assertEquals((Object)3, (Object)this.test("(name in things).size()"));
    }

    public void testSizeOnInlineArray() {
        CoreConfidenceTests.assertEquals((Object)3, (Object)this.test("{1,2,3}.size()"));
    }

    public void testStaticMethodFromLiteral() {
        CoreConfidenceTests.assertEquals((Object)String.class.getName(), (Object)this.test("String.valueOf(Class.forName('java.lang.String').getName())"));
    }

    public void testObjectInstantiation() {
        this.test("new java.lang.String('foobie')");
    }

    public void testObjectInstantiationWithMethodCall() {
        CoreConfidenceTests.assertEquals((Object)"FOOBIE", (Object)this.test("new String('foobie')  . toUpperCase()"));
    }

    public void testObjectInstantiation2() {
        this.test("new String() is String");
    }

    public void testObjectInstantiation3() {
        this.test("new java.text.SimpleDateFormat('yyyy').format(new java.util.Date(System.currentTimeMillis()))");
    }

    public void testArrayCoercion() {
        CoreConfidenceTests.assertEquals((Object)"gonk", (Object)this.test("funMethod( {'gonk', 'foo'} )"));
    }

    public void testArrayCoercion2() {
        CoreConfidenceTests.assertEquals((Object)10, (Object)this.test("sum({2,2,2,2,2})"));
    }

    public void testMapAccess() {
        CoreConfidenceTests.assertEquals((Object)"dog", (Object)this.test("funMap['foo'].bar.name"));
    }

    public void testMapAccess2() {
        CoreConfidenceTests.assertEquals((Object)"dog", (Object)this.test("funMap.foo.bar.name"));
    }

    public void testSoundex() {
        CoreConfidenceTests.assertTrue((boolean)((Boolean)this.test("'foobar' soundslike 'fubar'")));
    }

    public void testSoundex2() {
        CoreConfidenceTests.assertFalse((boolean)((Boolean)this.test("'flexbar' soundslike 'fubar'")));
    }

    public void testThisReference() {
        CoreConfidenceTests.assertEquals((boolean)true, (boolean)(this.test("this") instanceof Base));
    }

    public void testThisReference2() {
        CoreConfidenceTests.assertEquals((boolean)true, (boolean)(this.test("this.funMap") instanceof Map));
    }

    public void testThisReference3() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("this is org.mvel.tests.main.res.Base"));
    }

    public void testThisReference4() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("this.funMap instanceof java.util.Map"));
    }

    public void testThisReference5() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("this.data == 'cat'"));
    }

    public void testThisReferenceInMethodCall() {
        CoreConfidenceTests.assertEquals((Object)101, (Object)this.test("Integer.parseInt(this.number)"));
    }

    public void testThisReferenceInConstructor() {
        CoreConfidenceTests.assertEquals((Object)"101", (Object)this.test("new String(this.number)"));
    }

    public void testThisReferenceMapVirtualObjects() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "bar");
        MapVariableResolverFactory factory = new MapVariableResolverFactory(new HashMap<String, Object>());
        factory.createVariable("this", map);
        CoreConfidenceTests.assertEquals((Object)true, (Object)MVEL.eval("this.foo == 'bar'", map, (VariableResolverFactory)factory));
    }

    public void testThisReferenceMapVirtualObjects1() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "bar");
        MapVariableResolverFactory factory = new MapVariableResolverFactory(new HashMap<String, Object>());
        factory.createVariable("this", map);
        Serializable compiled = MVEL.compileExpression("this.foo == 'bar'");
        OptimizerFactory.setDefaultOptimizer("reflective");
        CoreConfidenceTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)compiled, map, factory));
    }

    public void testThisReferenceMapVirtualObjects2() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "bar");
        MapVariableResolverFactory factory = new MapVariableResolverFactory(new HashMap<String, Object>());
        factory.createVariable("this", map);
        Serializable compiled = MVEL.compileExpression("this.foo == 'bar'");
        if (!Boolean.getBoolean("mvel.disable.jit")) {
            OptimizerFactory.setDefaultOptimizer("ASM");
        }
        CoreConfidenceTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)compiled, map, factory));
    }

    public void testStringEscaping() {
        CoreConfidenceTests.assertEquals((Object)"\"Mike Brock\"", (Object)this.test("\"\\\"Mike Brock\\\"\""));
    }

    public void testStringEscaping2() {
        CoreConfidenceTests.assertEquals((Object)"MVEL's Parser is Fast", (Object)this.test("'MVEL\\'s Parser is Fast'"));
    }

    public void testEvalToBoolean() {
        CoreConfidenceTests.assertEquals((boolean)true, (boolean)MVEL.evalToBoolean("true ", "true"));
        CoreConfidenceTests.assertEquals((boolean)true, (boolean)MVEL.evalToBoolean("true ", "true"));
    }

    public void testCompiledMapStructures() {
        Serializable compiled = MVEL.compileExpression("['foo':'bar'] contains 'foo'");
        MVEL.executeExpression(compiled, null, null, Boolean.class);
    }

    public void testSubListInMap() {
        CoreConfidenceTests.assertEquals((Object)"pear", (Object)this.test("map = ['test' : 'poo', 'foo' : [c, 'pear']]; map['foo'][1]"));
    }

    public void testCompiledMethodCall() {
        Serializable compiled = MVEL.compileExpression("c.getClass()");
        CoreConfidenceTests.assertEquals(String.class, (Object)MVEL.executeExpression((Object)compiled, (Object)this.base, this.map));
    }

    public void testStaticNamespaceCall() {
        CoreConfidenceTests.assertEquals(ArrayList.class, (Object)this.test("java.util.ArrayList"));
    }

    public void testStaticNamespaceClassWithMethod() {
        CoreConfidenceTests.assertEquals((Object)"FooBar", (Object)this.test("java.lang.String.valueOf('FooBar')"));
    }

    public void testConstructor() {
        CoreConfidenceTests.assertEquals((Object)"foo", (Object)this.test("a = 'foobar'; new String(a.toCharArray(), 0, 3)"));
    }

    public void testStaticNamespaceClassWithField() {
        CoreConfidenceTests.assertEquals((Object)Integer.MAX_VALUE, (Object)this.test("java.lang.Integer.MAX_VALUE"));
    }

    public void testStaticNamespaceClassWithField2() {
        CoreConfidenceTests.assertEquals((Object)Integer.MAX_VALUE, (Object)this.test("Integer.MAX_VALUE"));
    }

    public void testStaticFieldAsMethodParm() {
        CoreConfidenceTests.assertEquals((Object)String.valueOf(Integer.MAX_VALUE), (Object)this.test("String.valueOf(Integer.MAX_VALUE)"));
    }

    public void testEmptyIf() {
        CoreConfidenceTests.assertEquals((Object)5, (Object)this.test("a = 5; if (a == 5) { }; return a;"));
    }

    public void testEmptyIf2() {
        CoreConfidenceTests.assertEquals((Object)5, (Object)this.test("a=5;if(a==5){};return a;"));
    }

    public void testIf() {
        CoreConfidenceTests.assertEquals((Object)10, (Object)this.test("if (5 > 4) { return 10; } else { return 5; }"));
    }

    public void testIf2() {
        CoreConfidenceTests.assertEquals((Object)10, (Object)this.test("if (5 < 4) { return 5; } else { return 10; }"));
    }

    public void testIf3() {
        CoreConfidenceTests.assertEquals((Object)10, (Object)this.test("if(5<4){return 5;}else{return 10;}"));
    }

    public void testIfAndElse() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("if (false) { return false; } else { return true; }"));
    }

    public void testIfAndElseif() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("if (false) { return false; } else if(100 < 50) { return false; } else if (10 > 5) return true;"));
    }

    public void testIfAndElseIfCondensedGrammar() {
        CoreConfidenceTests.assertEquals((Object)"Foo", (Object)this.test("if (false) return 'Bar'; else return 'Foo';"));
    }

    public void testForEach2() {
        CoreConfidenceTests.assertEquals((Object)6, (Object)this.test("total = 0; a = {1,2,3}; foreach(item : a) { total += item }; total"));
    }

    public void testForEach3() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("a = {1,2,3}; foreach (i : a) { if (i == 1) { return true; } }"));
    }

    public void testForEach4() {
        CoreConfidenceTests.assertEquals((Object)"OneTwoThreeFour", (Object)this.test("a = {1,2,3,4}; builder = ''; foreach (i : a) { if (i == 1) { builder += 'One' } else if (i == 2) { builder += 'Two' } else if (i == 3) { builder += 'Three' } else { builder += 'Four' }}; builder;"));
    }

    public void testWith() {
        CoreConfidenceTests.assertEquals((Object)"OneTwo", (Object)this.test("with (foo) {aValue = 'One',bValue='Two'}; foo.aValue + foo.bValue;"));
    }

    public void testWith2() {
        CoreConfidenceTests.assertEquals((Object)"OneTwo", (Object)this.test("with (foo) { \naValue = 'One', \nbValue='Two' \n}; \nfoo.aValue + foo.bValue;"));
    }

    public void testAssertion() {
        try {
            this.test("assert false");
            CoreConfidenceTests.assertTrue((boolean)false);
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    public void testAssertion2() {
        try {
            this.test("assert true;");
        }
        catch (AssertionError error) {
            CoreConfidenceTests.assertTrue((boolean)false);
        }
    }

    public void testMagicArraySize() {
        CoreConfidenceTests.assertEquals((Object)5, (Object)this.test("stringArray.size()"));
    }

    public void testMagicArraySize2() {
        CoreConfidenceTests.assertEquals((Object)5, (Object)this.test("intArray.size()"));
    }

    public void testStaticVarAssignment() {
        CoreConfidenceTests.assertEquals((Object)"1", (Object)this.test("String mikeBrock = 1; mikeBrock"));
    }

    public void testIntentionalFailure() {
        try {
            this.test("int = 0");
            CoreConfidenceTests.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testImport() {
        CoreConfidenceTests.assertEquals(HashMap.class, (Object)this.test("import java.util.HashMap; HashMap;"));
    }

    public void testStaticImport() {
        CoreConfidenceTests.assertEquals((Object)2.0, (Object)this.test("import_static java.lang.Math.sqrt; sqrt(4)"));
    }

    public void testFunctionPointer() {
        CoreConfidenceTests.assertEquals((Object)2.0, (Object)this.test("squareRoot = java.lang.Math.sqrt; squareRoot(4)"));
    }

    public void testFunctionPointerAsParam() {
        CoreConfidenceTests.assertEquals((Object)"2.0", (Object)this.test("squareRoot = Math.sqrt; new String(String.valueOf(squareRoot(4)));"));
    }

    public void testFunctionPointerInAssignment() {
        CoreConfidenceTests.assertEquals((Object)5.0, (Object)this.test("squareRoot = Math.sqrt; i = squareRoot(25); return i;"));
    }

    public void testIncrementOperator() {
        CoreConfidenceTests.assertEquals((Object)2, (Object)this.test("x = 1; x++; x"));
    }

    public void testPreIncrementOperator() {
        CoreConfidenceTests.assertEquals((Object)2, (Object)this.test("x = 1; ++x"));
    }

    public void testDecrementOperator() {
        CoreConfidenceTests.assertEquals((Object)1, (Object)this.test("x = 2; x--; x"));
    }

    public void testPreDecrementOperator() {
        CoreConfidenceTests.assertEquals((Object)1, (Object)this.test("x = 2; --x"));
    }

    public void testQualifiedStaticTyping() {
        CoreConfidenceTests.assertEquals((Object)20, (Object)this.test("java.math.BigDecimal a = new java.math.BigDecimal( 10.0 ); java.math.BigDecimal b = new java.math.BigDecimal( 10.0 ); java.math.BigDecimal c = a + b; return c; "));
    }

    public void testUnQualifiedStaticTyping() {
        CoreConfidenceTests.assertEquals((Object)20, (Object)this.test("import java.math.BigDecimal; BigDecimal a = new BigDecimal( 10.0 ); BigDecimal b = new BigDecimal( 10.0 ); BigDecimal c = a + b; return c; "));
    }

    public void testObjectCreation() {
        CoreConfidenceTests.assertEquals((Object)6, (Object)this.test("new Integer( 6 )"));
    }

    public void testTernary4() {
        CoreConfidenceTests.assertEquals((Object)"<test>", (Object)this.test("true ? '<test>' : '<poo>'"));
    }

    public void testStringAsCollection() {
        CoreConfidenceTests.assertEquals((Object)Character.valueOf('o'), (Object)this.test("abc = 'foo'; abc[1]"));
    }

    public void testSubExpressionIndexer() {
        CoreConfidenceTests.assertEquals((Object)"bar", (Object)this.test("xx = new java.util.HashMap(); xx.put('foo', 'bar'); prop = 'foo'; xx[prop];"));
    }

    public void testCompileTimeLiteralReduction() {
        CoreConfidenceTests.assertEquals((Object)1000, (Object)this.test("10 * 100"));
    }

    public void testInterfaceResolution() {
        Serializable ex = MVEL.compileExpression("foo.collectionTest.size()");
        this.foo.setCollectionTest(new HashSet());
        Object result1 = MVEL.executeExpression((Object)ex, this.map);
        this.foo.setCollectionTest(new ArrayList());
        Object result2 = MVEL.executeExpression((Object)ex, this.map);
        CoreConfidenceTests.assertEquals((Object)result1, (Object)result2);
    }

    public void testCreationOfSet() {
        CoreConfidenceTests.assertEquals((Object)"foo bar foo bar", (Object)this.test("set = new java.util.HashSet(); set.add('foo');set.add('bar');output = '';foreach (item : set) {output = output + item + ' ';} foreach (item : set) {output = output + item + ' ';} output = output.trim();if (set.size() == 2) { return output; }"));
    }

    public void testCreationOfList() {
        CoreConfidenceTests.assertEquals((Object)5, (Object)this.test("l = new java.util.LinkedList();l.add('fun');l.add('happy');l.add('fun');l.add('slide');l.add('crap');poo = new java.util.ArrayList(l);poo.size();"));
    }

    public void testMapOperations() {
        CoreConfidenceTests.assertEquals((Object)"poo5", (Object)this.test("l = new java.util.ArrayList();l.add('plop');l.add('poo');m = new java.util.HashMap();m.put('foo', l);m.put('cah', 'mah');m.put('bar', 'foo');m.put('sarah', 'mike');m.put('edgar', 'poe');if (m.edgar == 'poe') {return m.foo[1] + m.size();}"));
    }

    public void testStackOperations() {
        CoreConfidenceTests.assertEquals((Object)10, (Object)this.test("stk = new java.util.Stack();stk.push(5);stk.push(5);stk.pop() + stk.pop();"));
    }

    public void testSystemOutPrint() {
        this.test("a = 0;\r\nSystem.out.println('This is a test');");
    }

    public void testBreakpoints() {
        ExpressionCompiler compiler = new ExpressionCompiler("a = 5;\nb = 5;\n\nif (a == b) {\n\nSystem.out.println('Good');\nreturn a + b;\n}\n");
        System.out.println("-------\n" + compiler.getExpression() + "\n-------\n");
        compiler.setDebugSymbols(true);
        ParserContext ctx = new ParserContext();
        ctx.setSourceFile("test.mv");
        CompiledExpression compiled = compiler.compile(ctx);
        System.out.println(DebugTools.decompile(compiled));
        MVELRuntime.registerBreakpoint("test.mv", 7);
        Debugger testDebugger = new Debugger(){

            public int onBreak(Frame frame) {
                System.out.println("Breakpoint [source:" + frame.getSourceName() + "; line:" + frame.getLineNumber() + "]");
                return 0;
            }
        };
        MVELRuntime.setThreadDebugger(testDebugger);
        CoreConfidenceTests.assertEquals((Object)10, (Object)MVEL.executeDebugger(compiled, null, new MapVariableResolverFactory(this.map)));
    }

    public void testBreakpoints2() {
        ExpressionCompiler compiler = new ExpressionCompiler("System.out.println('test the debugger');\n a = 0;");
        compiler.setDebugSymbols(true);
        ParserContext ctx = new ParserContext();
        ctx.setSourceFile("test.mv");
        CompiledExpression compiled = compiler.compile(ctx);
        System.out.println(DebugTools.decompile(compiled));
    }

    public void testBreakpoints3() {
        String expr = "System.out.println( \"a1\" );\nSystem.out.println( \"a2\" );\nSystem.out.println( \"a3\" );\nSystem.out.println( \"a4\" );\n";
        ExpressionCompiler compiler = new ExpressionCompiler(expr);
        ParserContext context = new ParserContext();
        context.addImport("System", System.class);
        context.setStrictTypeEnforcement(true);
        context.setDebugSymbols(true);
        context.setSourceFile("mysource");
        CompiledExpression compiledExpression = compiler.compile(context);
        String s = DebugTools.decompile((Serializable)compiledExpression);
        System.out.println("output: " + s);
        int fromIndex = 0;
        int count = 0;
        while ((fromIndex = s.indexOf("DEBUG_SYMBOL", fromIndex + 1)) > -1) {
            ++count;
        }
        CoreConfidenceTests.assertEquals((int)4, (int)count);
    }

    public void testBreakpointsAcrossWith() {
        String line1 = "System.out.println( \"a1\" );\n";
        String line2 = "c = new Cheese();\n";
        String line3 = "with ( c ) { type = 'cheddar',\n             price = 10 };\n";
        String line4 = "System.out.println( \"a1\" );\n";
        String expr = line1 + line2 + line3 + line4;
        System.out.println(expr);
        ExpressionCompiler compiler = new ExpressionCompiler(expr);
        ParserContext context = new ParserContext();
        context.addImport("System", System.class);
        context.addImport("Cheese", Cheese.class);
        context.setStrictTypeEnforcement(true);
        context.setDebugSymbols(true);
        context.setSourceFile("mysource");
        CompiledExpression compiledExpression = compiler.compile(context);
        String s = DebugTools.decompile((Serializable)compiledExpression);
        System.out.println("output: " + s);
        int fromIndex = 0;
        int count = 0;
        while ((fromIndex = s.indexOf("DEBUG_SYMBOL", fromIndex + 1)) > -1) {
            ++count;
        }
        CoreConfidenceTests.assertEquals((int)5, (int)count);
    }

    public void testBreakpointsAcrossComments() {
        String expression = "/** This is a comment\n *  Second comment line\n *  Third Comment Line\n */\nSystem.out.println('4');\nSystem.out.println('5');\na = 0;\nb = 1;\na + b";
        ExpressionCompiler compiler = new ExpressionCompiler(expression);
        compiler.setDebugSymbols(true);
        System.out.println("Expression:\n------------");
        System.out.println(expression);
        System.out.println("------------");
        ParserContext ctx = new ParserContext();
        ctx.setSourceFile("test2.mv");
        CompiledExpression compiled = compiler.compile(ctx);
        System.out.println(DebugTools.decompile(compiled));
        MVELRuntime.registerBreakpoint("test2.mv", 9);
        Debugger testDebugger = new Debugger(){

            public int onBreak(Frame frame) {
                System.out.println("Breakpoint Encountered [source:" + frame.getSourceName() + "; line:" + frame.getLineNumber() + "]");
                System.out.println("vars:" + frame.getFactory().getKnownVariables());
                System.out.println("Resume Execution");
                return 0;
            }
        };
        MVELRuntime.setThreadDebugger(testDebugger);
        CoreConfidenceTests.assertEquals((Object)1, (Object)MVEL.executeDebugger(compiled, null, new MapVariableResolverFactory(this.map)));
    }

    public void testBreakpointsAcrossComments2() {
        ExpressionCompiler compiler = new ExpressionCompiler("// This is a comment\n//Second comment line\n//Third Comment Line\n\n//Test\nSystem.out.println('4');\n//System.out.println('5'); \na = 0;\nb = 1;\n a + b");
        compiler.setDebugSymbols(true);
        ParserContext ctx = new ParserContext();
        ctx.setSourceFile("test2.mv");
        CompiledExpression compiled = compiler.compile(ctx);
        System.out.println(DebugTools.decompile(compiled));
        MVELRuntime.registerBreakpoint("test2.mv", 6);
        MVELRuntime.registerBreakpoint("test2.mv", 8);
        MVELRuntime.registerBreakpoint("test2.mv", 9);
        MVELRuntime.registerBreakpoint("test2.mv", 10);
        Debugger testDebugger = new Debugger(){

            public int onBreak(Frame frame) {
                System.out.println("Breakpoint [source:" + frame.getSourceName() + "; line:" + frame.getLineNumber() + "]");
                return 0;
            }
        };
        MVELRuntime.setThreadDebugger(testDebugger);
        CoreConfidenceTests.assertEquals((Object)1, (Object)MVEL.executeDebugger(compiled, null, new MapVariableResolverFactory(this.map)));
    }

    public void testBreakpoints4() {
        String expression = "System.out.println('foo');\na = new Foo();\nupdate (a) { name = 'bar' };\nSystem.out.println('name:' + a.name);\nreturn a.name;";
        HashMap<String, Interceptor> interceptors = new HashMap<String, Interceptor>();
        HashMap<String, Macro> macros = new HashMap<String, Macro>();
        interceptors.put("Update", new Interceptor(){

            public int doBefore(ASTNode node, VariableResolverFactory factory) {
                ((WithNode)node).getNestedStatement().getValue(null, factory);
                System.out.println("fired update interceptor -- before");
                return 0;
            }

            public int doAfter(Object val, ASTNode node, VariableResolverFactory factory) {
                System.out.println("fired update interceptor -- after");
                return 0;
            }
        });
        macros.put("update", new Macro(){

            public String doMacro() {
                return "@Update with";
            }
        });
        expression = MVEL.parseMacros(expression, macros);
        ExpressionCompiler compiler = new ExpressionCompiler(expression);
        compiler.setDebugSymbols(true);
        ParserContext ctx = new ParserContext();
        ctx.setSourceFile("test2.mv");
        ctx.addImport("Foo", Foo.class);
        ctx.setInterceptors(interceptors);
        CompiledExpression compiled = compiler.compile(ctx);
        System.out.println("\nExpression:------------");
        System.out.println(expression);
        System.out.println("------------");
        System.out.println(DebugTools.decompile(compiled));
        MVELRuntime.registerBreakpoint("test2.mv", 3);
        MVELRuntime.registerBreakpoint("test2.mv", 4);
        MVELRuntime.registerBreakpoint("test2.mv", 5);
        Debugger testDebugger = new Debugger(){

            public int onBreak(Frame frame) {
                System.out.println("Breakpoint [source:" + frame.getSourceName() + "; line:" + frame.getLineNumber() + "]");
                return 0;
            }
        };
        MVELRuntime.setThreadDebugger(testDebugger);
        CoreConfidenceTests.assertEquals((Object)"bar", (Object)MVEL.executeDebugger(compiled, null, new MapVariableResolverFactory(this.map)));
    }

    public void testBreakpoints5() {
        String expression = "System.out.println('foo');\r\na = new Foo();\r\na.name = 'bar'\r\nfoo.happy();\r\nSystem.out.println( 'name:' + a.name );               \r\nSystem.out.println( 'name:' + a.name );         \r\nSystem.out.println( 'name:' + a.name );     \r\nreturn a.name;";
        HashMap<String, Interceptor> interceptors = new HashMap<String, Interceptor>();
        HashMap<String, Macro> macros = new HashMap<String, Macro>();
        interceptors.put("Update", new Interceptor(){

            public int doBefore(ASTNode node, VariableResolverFactory factory) {
                ((WithNode)node).getNestedStatement().getValue(null, factory);
                System.out.println("fired update interceptor -- before");
                return 0;
            }

            public int doAfter(Object val, ASTNode node, VariableResolverFactory factory) {
                System.out.println("fired update interceptor -- after");
                return 0;
            }
        });
        macros.put("update", new Macro(){

            public String doMacro() {
                return "@Update with";
            }
        });
        expression = MVEL.parseMacros(expression, macros);
        ExpressionCompiler compiler = new ExpressionCompiler(expression);
        compiler.setDebugSymbols(true);
        ParserContext ctx = new ParserContext();
        ctx.setSourceFile("test2.mv");
        ctx.addImport("Foo", Foo.class);
        ctx.setInterceptors(interceptors);
        CompiledExpression compiled = compiler.compile(ctx);
        System.out.println("\nExpression:------------");
        System.out.println(expression);
        System.out.println("------------");
        System.out.println(DebugTools.decompile(compiled));
        MVELRuntime.registerBreakpoint("test2.mv", 1);
        Debugger testDebugger = new Debugger(){

            public int onBreak(Frame frame) {
                System.out.println("Breakpoint [source:" + frame.getSourceName() + "; line:" + frame.getLineNumber() + "]");
                return 1;
            }
        };
        MVELRuntime.setThreadDebugger(testDebugger);
        System.out.println("\n==RUN==\n");
        CoreConfidenceTests.assertEquals((Object)"bar", (Object)MVEL.executeDebugger(compiled, null, new MapVariableResolverFactory(this.map)));
    }

    public void testDebugSymbolsWithWindowsLinedEndings() throws Exception {
        String expr = "   System.out.println( \"a1\" );\r\n   System.out.println( \"a2\" );\r\n   System.out.println( \"a3\" );\r\n   System.out.println( \"a4\" );\r\n";
        ExpressionCompiler compiler = new ExpressionCompiler(expr);
        compiler.setDebugSymbols(true);
        ParserContext ctx = new ParserContext();
        ctx.setStrictTypeEnforcement(true);
        ctx.setDebugSymbols(true);
        ctx.setSourceFile("mysource");
        CompiledExpression compiledExpression = compiler.compile(ctx);
        String s = DebugTools.decompile((Serializable)compiledExpression);
        System.out.println(s);
        int fromIndex = 0;
        int count = 0;
        while ((fromIndex = s.indexOf("DEBUG_SYMBOL", fromIndex + 1)) > -1) {
            ++count;
        }
        CoreConfidenceTests.assertEquals((int)4, (int)count);
    }

    public void testDebugSymbolsWithUnixLinedEndings() throws Exception {
        String expr = "   System.out.println( \"a1\" );\n   System.out.println( \"a2\" );\n   System.out.println( \"a3\" );\n   System.out.println( \"a4\" );\n";
        ExpressionCompiler compiler = new ExpressionCompiler(expr);
        compiler.setDebugSymbols(true);
        ParserContext ctx = new ParserContext();
        ctx.setStrictTypeEnforcement(true);
        ctx.setDebugSymbols(true);
        ctx.setSourceFile("mysource");
        CompiledExpression compiledExpression = compiler.compile(ctx);
        String s = DebugTools.decompile((Serializable)compiledExpression);
        int fromIndex = 0;
        int count = 0;
        while ((fromIndex = s.indexOf("DEBUG_SYMBOL", fromIndex + 1)) > -1) {
            ++count;
        }
        CoreConfidenceTests.assertEquals((int)4, (int)count);
    }

    public void testDebugSymbolsWithMixedLinedEndings() throws Exception {
        String expr = "   System.out.println( \"a1\" );\n   System.out.println( \"a2\" );\r\n   System.out.println( \"a3\" );\n   System.out.println( \"a4\" );\r\n";
        ExpressionCompiler compiler = new ExpressionCompiler(expr);
        compiler.setDebugSymbols(true);
        ParserContext ctx = new ParserContext();
        ctx.setStrictTypeEnforcement(true);
        ctx.setDebugSymbols(true);
        ctx.setSourceFile("mysource");
        CompiledExpression compiledExpression = compiler.compile(ctx);
        String s = DebugTools.decompile((Serializable)compiledExpression);
        System.out.println(s);
        int fromIndex = 0;
        int count = 0;
        while ((fromIndex = s.indexOf("DEBUG_SYMBOL", fromIndex + 1)) > -1) {
            ++count;
        }
        CoreConfidenceTests.assertEquals((int)4, (int)count);
    }

    public void testReflectionCache() {
        CoreConfidenceTests.assertEquals((Object)"happyBar", (Object)this.test("foo.happy(); foo.bar.happy()"));
    }

    public void testVarInputs() {
        ExpressionCompiler compiler = new ExpressionCompiler("test != foo && bo.addSomething(trouble); String bleh = foo; twa = bleh;");
        compiler.compile();
        ParserContext pCtx = compiler.getParserContextState();
        CoreConfidenceTests.assertEquals((int)4, (int)pCtx.getInputs().size());
        CoreConfidenceTests.assertTrue((boolean)pCtx.getInputs().containsKey("test"));
        CoreConfidenceTests.assertTrue((boolean)pCtx.getInputs().containsKey("foo"));
        CoreConfidenceTests.assertTrue((boolean)pCtx.getInputs().containsKey("bo"));
        CoreConfidenceTests.assertTrue((boolean)pCtx.getInputs().containsKey("trouble"));
        CoreConfidenceTests.assertEquals((int)2, (int)pCtx.getVariables().size());
        CoreConfidenceTests.assertTrue((boolean)pCtx.getVariables().containsKey("bleh"));
        CoreConfidenceTests.assertTrue((boolean)pCtx.getVariables().containsKey("twa"));
        CoreConfidenceTests.assertEquals(String.class, (Object)pCtx.getVarOrInputType("bleh"));
    }

    public void testVarInputs2() {
        ExpressionCompiler compiler = new ExpressionCompiler("test != foo && bo.addSomething(trouble); String bleh = foo; twa = bleh;");
        ParserContext ctx = new ParserContext();
        ctx.setRetainParserState(true);
        compiler.compile(ctx);
        System.out.println(ctx.getVarOrInputType("bleh"));
    }

    public void testVarInputs3() {
        ExpressionCompiler compiler = new ExpressionCompiler("addresses['home'].street");
        compiler.compile();
        CoreConfidenceTests.assertFalse((boolean)compiler.getParserContextState().getInputs().keySet().contains("home"));
    }

    public void testVarInputs4() {
        ExpressionCompiler compiler = new ExpressionCompiler("System.out.println( message );");
        compiler.compile();
        CoreConfidenceTests.assertTrue((boolean)compiler.getParserContextState().getInputs().keySet().contains("message"));
    }

    public void testAnalyzer() {
        ExpressionCompiler compiler = new ExpressionCompiler("order.id == 10");
        compiler.compile();
        for (String input : compiler.getParserContextState().getInputs().keySet()) {
            System.out.println("input>" + input);
        }
        CoreConfidenceTests.assertEquals((int)1, (int)compiler.getParserContextState().getInputs().size());
        CoreConfidenceTests.assertTrue((boolean)compiler.getParserContextState().getInputs().containsKey("order"));
    }

    public void testClassImportViaFactory() {
        MapVariableResolverFactory mvf = new MapVariableResolverFactory(this.map);
        ClassImportResolverFactory classes = new ClassImportResolverFactory();
        classes.addClass(HashMap.class);
        ResolverTools.appendFactory(mvf, classes);
        Serializable compiled = MVEL.compileExpression("HashMap map = new HashMap()", classes.getImportedClasses());
        CoreConfidenceTests.assertTrue((boolean)(MVEL.executeExpression((Object)compiled, mvf) instanceof HashMap));
    }

    public void testSataticClassImportViaFactory() {
        MapVariableResolverFactory mvf = new MapVariableResolverFactory(this.map);
        ClassImportResolverFactory classes = new ClassImportResolverFactory();
        classes.addClass(AbstractTest.Person.class);
        ResolverTools.appendFactory(mvf, classes);
        Serializable compiled = MVEL.compileExpression("p = new Person('tom'); return p.name;", classes.getImportedClasses());
        CoreConfidenceTests.assertEquals((Object)"tom", (Object)MVEL.executeExpression((Object)compiled, mvf));
    }

    public void testSataticClassImportViaFactoryAndWithModification() {
        MapVariableResolverFactory mvf = new MapVariableResolverFactory(this.map);
        ClassImportResolverFactory classes = new ClassImportResolverFactory();
        classes.addClass(AbstractTest.Person.class);
        ResolverTools.appendFactory(mvf, classes);
        Serializable compiled = MVEL.compileExpression("p = new Person('tom'); p.age = 20; with( p ) { age = p.age + 1 }; return p.age;", classes.getImportedClasses());
        CoreConfidenceTests.assertEquals((Object)21, (Object)MVEL.executeExpression((Object)compiled, mvf));
    }

    public void testCheeseConstructor() {
        MapVariableResolverFactory mvf = new MapVariableResolverFactory(this.map);
        ClassImportResolverFactory classes = new ClassImportResolverFactory();
        classes.addClass(Cheese.class);
        ResolverTools.appendFactory(mvf, classes);
        Serializable compiled = MVEL.compileExpression("cheese = new Cheese(\"cheddar\", 15);", classes.getImportedClasses());
        CoreConfidenceTests.assertTrue((boolean)(MVEL.executeExpression((Object)compiled, mvf) instanceof Cheese));
    }

    public void testInterceptors() {
        Interceptor testInterceptor = new Interceptor(){

            public int doBefore(ASTNode node, VariableResolverFactory factory) {
                System.out.println("BEFORE Node: " + node.getName());
                return 0;
            }

            public int doAfter(Object val, ASTNode node, VariableResolverFactory factory) {
                System.out.println("AFTER Node: " + node.getName());
                return 0;
            }
        };
        HashMap<String, Interceptor> interceptors = new HashMap<String, Interceptor>();
        interceptors.put("test", testInterceptor);
        Serializable compiled = MVEL.compileExpression("@test System.out.println('MIDDLE');", null, interceptors);
        MVEL.executeExpression(compiled);
    }

    public void testMacroSupport() {
        HashMap<String, Foo> vars = new HashMap<String, Foo>();
        vars.put("foo", new Foo());
        HashMap<String, Interceptor> interceptors = new HashMap<String, Interceptor>();
        HashMap<String, Macro> macros = new HashMap<String, Macro>();
        interceptors.put("Modify", new Interceptor(){

            public int doBefore(ASTNode node, VariableResolverFactory factory) {
                ((WithNode)node).getNestedStatement().getValue(null, factory);
                factory.createVariable("mod", "FOOBAR!");
                return 0;
            }

            public int doAfter(Object val, ASTNode node, VariableResolverFactory factory) {
                return 0;
            }
        });
        macros.put("modify", new Macro(){

            public String doMacro() {
                return "@Modify with";
            }
        });
        ExpressionCompiler compiler = new ExpressionCompiler(MVEL.parseMacros("modify (foo) { aValue = 'poo' }; mod", macros));
        compiler.setDebugSymbols(true);
        ParserContext ctx = new ParserContext(null, interceptors, null);
        ctx.setSourceFile("test.mv");
        CompiledExpression compiled = compiler.compile(ctx);
        CoreConfidenceTests.assertEquals((Object)"FOOBAR!", (Object)MVEL.executeExpression((Object)compiled, null, vars));
    }

    public void testMacroSupportWithDebugging() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("foo", new Foo());
        HashMap<String, Interceptor> interceptors = new HashMap<String, Interceptor>();
        HashMap<String, Macro> macros = new HashMap<String, Macro>();
        interceptors.put("Modify", new Interceptor(){

            public int doBefore(ASTNode node, VariableResolverFactory factory) {
                ((WithNode)node).getNestedStatement().getValue(null, factory);
                factory.createVariable("mod", "FOOBAR!");
                return 0;
            }

            public int doAfter(Object val, ASTNode node, VariableResolverFactory factory) {
                return 0;
            }
        });
        macros.put("modify", new Macro(){

            public String doMacro() {
                return "@Modify with";
            }
        });
        ExpressionCompiler compiler = new ExpressionCompiler(MVEL.parseMacros("System.out.println('hello');\nSystem.out.println('bye');\nmodify (foo) { aValue = 'poo', \n aValue = 'poo' };\n mod", macros));
        compiler.setDebugSymbols(true);
        ParserContext ctx = new ParserContext(null, interceptors, null);
        ctx.setSourceFile("test.mv");
        CompiledExpression compiled = compiler.compile(ctx);
        MVELRuntime.setThreadDebugger(new Debugger(){

            public int onBreak(Frame frame) {
                System.out.println(frame.getSourceName() + ":" + frame.getLineNumber());
                return 1;
            }
        });
        MVELRuntime.registerBreakpoint("test.mv", 3);
        System.out.println(DebugTools.decompile(compiled));
        CoreConfidenceTests.assertEquals((Object)"FOOBAR!", (Object)MVEL.executeDebugger(compiled, null, new MapVariableResolverFactory(vars)));
    }

    public void testExecuteCoercionTwice() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("foo", new Foo());
        vars.put("$value", new Long(5L));
        ExpressionCompiler compiler = new ExpressionCompiler("with (foo) { countTest = $value };");
        compiler.setDebugSymbols(true);
        ParserContext ctx = new ParserContext();
        ctx.setSourceFile("test.mv");
        CompiledExpression compiled = compiler.compile(ctx);
        MVEL.executeExpression((Object)compiled, null, vars);
        MVEL.executeExpression((Object)compiled, null, vars);
    }

    public void testComments() {
        CoreConfidenceTests.assertEquals((Object)10, (Object)this.test("// This is a comment\n5 + 5"));
    }

    public void testComments2() {
        CoreConfidenceTests.assertEquals((Object)20, (Object)this.test("10 + 10; // This is a comment"));
    }

    public void testComments3() {
        CoreConfidenceTests.assertEquals((Object)30, (Object)this.test("/* This is a test of\r\nMVEL's support for\r\nmulti-line comments\r\n*/\r\n 15 + 15"));
    }

    public void testComments4() {
        CoreConfidenceTests.assertEquals((Object)50, (Object)this.test("/** This is a fun test script **/\r\na = 10;\r\n/**\r\n* Here is a useful variable\r\n*/\r\nb = 20; // set b to '20'\r\nreturn ((a + b) * 2) - 10;\r\n// last comment\n"));
    }

    public void testSubtractNoSpace1() {
        CoreConfidenceTests.assertEquals((Object)59, (Object)this.test("hour-1"));
    }

    public void testStrictTypingCompilation() {
        ExpressionCompiler compiler = new ExpressionCompiler("a.foo;\nb.foo;\n x = 5");
        ParserContext ctx = new ParserContext();
        ctx.setStrictTypeEnforcement(true);
        try {
            compiler.compile(ctx);
        }
        catch (CompileException e) {
            e.printStackTrace();
            CoreConfidenceTests.assertEquals((int)2, (int)e.getErrors().size());
            return;
        }
        CoreConfidenceTests.assertTrue((boolean)false);
    }

    public void testStrictStaticMethodCall() {
        ExpressionCompiler compiler = new ExpressionCompiler("Bar.staticMethod()");
        ParserContext ctx = new ParserContext();
        ctx.addImport("Bar", Bar.class);
        ctx.setStrictTypeEnforcement(true);
        CompiledExpression s = compiler.compile(ctx);
        DebugTools.decompile((Serializable)s);
        CoreConfidenceTests.assertEquals((Object)1, (Object)MVEL.executeExpression(s));
    }

    public void testStrictTypingCompilation2() throws Exception {
        ParserContext ctx = new ParserContext();
        ctx.addImport("getRuntime", new MethodStub(Runtime.class.getMethod("getRuntime", new Class[0])));
        ctx.setStrictTypeEnforcement(true);
        ExpressionCompiler compiler = new ExpressionCompiler("getRuntime()");
        StaticMethodImportResolverFactory si = new StaticMethodImportResolverFactory(ctx);
        CompiledExpression expression = compiler.compile(ctx);
        CoreConfidenceTests.serializationTest(expression);
        CoreConfidenceTests.assertTrue((boolean)(MVEL.executeExpression((Object)expression, si) instanceof Runtime));
    }

    public void testStrictTypingCompilation3() throws NoSuchMethodException {
        ParserContext ctx = new ParserContext();
        ctx.setStrictTypeEnforcement(true);
        ExpressionCompiler compiler = new ExpressionCompiler("message='Hello';b=7;\nSystem.out.println(message + ';' + b);\nSystem.out.println(message + ';' + b); b");
        CoreConfidenceTests.assertEquals((Object)7, (Object)MVEL.executeExpression((Object)compiler.compile(ctx), new DefaultLocalVariableResolverFactory()));
    }

    public void testProvidedExternalTypes() {
        ExpressionCompiler compiler = new ExpressionCompiler("foo.bar");
        ParserContext ctx = new ParserContext();
        ctx.setStrictTypeEnforcement(true);
        ctx.addInput("foo", Foo.class);
        compiler.compile(ctx);
    }

    public void testEqualityRegression() {
        ExpressionCompiler compiler = new ExpressionCompiler("price == (new Integer( 5 ) + 5 ) ");
        compiler.compile();
    }

    public void testEvaluationRegression() {
        ExpressionCompiler compiler = new ExpressionCompiler("(p.age * 2)");
        compiler.compile();
        CoreConfidenceTests.assertTrue((boolean)compiler.getParserContextState().getInputs().containsKey("p"));
    }

    public void testAssignmentRegression() {
        ExpressionCompiler compiler = new ExpressionCompiler("total = total + $cheese.price");
        compiler.compile();
    }

    public void testTypeRegression() {
        ExpressionCompiler compiler = new ExpressionCompiler("total = 0");
        ParserContext ctx = new ParserContext();
        ctx.setStrictTypeEnforcement(true);
        compiler.compile(ctx);
        CoreConfidenceTests.assertEquals(Integer.class, (Object)compiler.getParserContextState().getVarOrInputType("total"));
    }

    public void testDateComparison() {
        this.map.put("dt1", new Date(System.currentTimeMillis() - 100000L));
        this.map.put("dt2", new Date(System.currentTimeMillis()));
        CoreConfidenceTests.assertTrue((boolean)((Boolean)this.test("dt1 < dt2")));
    }

    public void testDynamicDeop() {
        Serializable s = MVEL.compileExpression("name");
        CoreConfidenceTests.assertEquals((Object)"dog", (Object)MVEL.executeExpression((Object)s, this.foo));
        CoreConfidenceTests.assertEquals((Object)"dog", (Object)MVEL.executeExpression((Object)s, this.foo.getBar()));
    }

    public void testVirtProperty() {
        HashMap<String, String> testMap = new HashMap<String, String>();
        testMap.put("test", "foo");
        HashMap<String, HashMap<String, String>> vars = new HashMap<String, HashMap<String, String>>();
        vars.put("mp", testMap);
        CoreConfidenceTests.assertEquals((Object)"bar", (Object)MVEL.executeExpression((Object)MVEL.compileExpression("mp.test = 'bar'; mp.test"), vars));
    }

    public void testMapPropertyCreateCondensed() {
        CoreConfidenceTests.assertEquals((Object)"foo", (Object)this.test("map = new java.util.HashMap(); map['test'] = 'foo'; map['test'];"));
    }

    public void testClassLiteral() {
        CoreConfidenceTests.assertEquals(String.class, (Object)this.test("java.lang.String"));
    }

    public void testDeepMethod() {
        CoreConfidenceTests.assertEquals((Object)false, (Object)this.test("foo.bar.testList.add(new String()); foo.bar.testList == empty"));
    }

    public void testArrayAccessorAssign() {
        CoreConfidenceTests.assertEquals((Object)"foo", (Object)this.test("a = {'f00', 'bar'}; a[0] = 'foo'; a[0]"));
    }

    public void testListAccessorAssign() {
        CoreConfidenceTests.assertEquals((Object)"bar", (Object)this.test("a = new java.util.ArrayList(); a.add('foo'); a.add('BAR'); a[1] = 'bar'; a[1]"));
    }

    public void testBracketInString() {
        this.test("System.out.println('1)your guess was:');");
    }

    public void testNesting() {
        CoreConfidenceTests.assertEquals((Object)"foo", (Object)this.test("new String(new String(new String(\"foo\")));"));
    }

    public void testDeepPropertyAdd() {
        CoreConfidenceTests.assertEquals((Object)10, (Object)this.test("foo.countTest+ 10"));
    }

    public void testDeepAssignmentIncrement() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("foo.countTest += 5; if (foo.countTest == 5) { foo.countTest = 0; return true; } else { foo.countTest = 0; return false; }"));
    }

    public void testDeepAssignmentWithBlock() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("with (foo) { countTest += 5 }; if (foo.countTest == 5) { foo.countTest = 0; return true; } else { foo.countTest = 0; return false; }"));
    }

    public void testTypeCast() {
        CoreConfidenceTests.assertEquals((Object)"10", (Object)this.test("(String) 10"));
    }

    public void testMapAccessSemantics() {
        HashMap outermap = new HashMap();
        HashMap<String, String> innermap = new HashMap<String, String>();
        innermap.put("test", "foo");
        outermap.put("innermap", innermap);
        CoreConfidenceTests.assertEquals((Object)"foo", (Object)this.test("innermap['test']", outermap, null));
    }

    public void testMapBindingSemantics() {
        HashMap outermap = new HashMap();
        HashMap<String, String> innermap = new HashMap<String, String>();
        innermap.put("test", "foo");
        outermap.put("innermap", innermap);
        MVEL.setProperty(outermap, "innermap['test']", "bar");
        CoreConfidenceTests.assertEquals((Object)"bar", (Object)this.test("innermap['test']", outermap, null));
    }

    public void testSetSemantics() {
        Bar bar = new Bar();
        Foo foo = new Foo();
        CoreConfidenceTests.assertEquals((Object)"dog", (Object)MVEL.getProperty("name", bar));
        CoreConfidenceTests.assertEquals((Object)"dog", (Object)MVEL.getProperty("name", foo));
    }

    public void testMapBindingSemantics2() {
        HashMap outermap = new HashMap();
        HashMap<String, String> innermap = new HashMap<String, String>();
        innermap.put("test", "foo");
        outermap.put("innermap", innermap);
        Serializable s = MVEL.compileSetExpression("innermap['test']");
        MVEL.executeSetExpression(s, outermap, "bar");
        CoreConfidenceTests.assertEquals((Object)"bar", (Object)this.test("innermap['test']", outermap, null));
    }

    public void testDynamicImports() {
        ParserContext ctx = new ParserContext();
        ctx.addPackageImport("java.util");
        ExpressionCompiler compiler = new ExpressionCompiler("HashMap");
        CompiledExpression s = compiler.compile(ctx);
        CoreConfidenceTests.assertEquals(HashMap.class, (Object)MVEL.executeExpression(s));
        compiler = new ExpressionCompiler("map = new HashMap(); map.size()");
        s = compiler.compile(ctx);
        CoreConfidenceTests.assertEquals((Object)0, (Object)MVEL.executeExpression((Object)s, new DefaultLocalVariableResolverFactory()));
    }

    public void testDynamicImportsWithIdentifierSameAsClassWithDiffCase() {
        ParserContext ctx = new ParserContext();
        ctx.addPackageImport("org.mvel.tests.main.res");
        ctx.setStrictTypeEnforcement(false);
        ExpressionCompiler compiler = new ExpressionCompiler("bar.add(\"hello\")");
        CompiledExpression s = compiler.compile(ctx);
    }

    public void testTypedAssignment() {
        CoreConfidenceTests.assertEquals((Object)"foobar", (Object)this.test("java.util.Map map = new java.util.HashMap(); map.put('conan', 'foobar'); map['conan'];"));
    }

    public void testFQCNwithStaticInList() {
        CoreConfidenceTests.assertEquals((Object)Integer.MIN_VALUE, (Object)this.test("list = [java.lang.Integer.MIN_VALUE]; list[0]"));
    }

    public void testPrecedenceOrder() {
        CoreConfidenceTests.assertTrue((boolean)((Boolean)this.test("5 > 6 && 2 < 1 || 10 > 9")));
    }

    public void testDifferentImplSameCompile() {
        Serializable compiled = MVEL.compileExpression("a.funMap.hello");
        HashMap<String, Base> testMap = new HashMap<String, Base>();
        for (int i = 0; i < 100; ++i) {
            Base b = new Base();
            b.funMap.put("hello", "dog");
            testMap.put("a", b);
            CoreConfidenceTests.assertEquals((Object)"dog", (Object)MVEL.executeExpression((Object)compiled, testMap));
            b = new Base();
            b.funMap.put("hello", "cat");
            testMap.put("a", b);
            CoreConfidenceTests.assertEquals((Object)"cat", (Object)MVEL.executeExpression((Object)compiled, testMap));
        }
    }

    public void testInterfaceMethodCallWithSpace() {
        Serializable compiled = MVEL.compileExpression("drools.retract (cheese)");
        HashMap<String, Object> map = new HashMap<String, Object>();
        DefaultKnowledgeHelper helper = new DefaultKnowledgeHelper();
        map.put("drools", helper);
        Cheese cheese = new Cheese("stilton", 15);
        map.put("cheese", cheese);
        MVEL.executeExpression((Object)compiled, map);
        CoreConfidenceTests.assertSame((Object)cheese, helper.retracted.get(0));
    }

    public void testInterfaceMethodCallWithMacro() {
        HashMap<String, Macro> macros = new HashMap<String, Macro>(1);
        macros.put("retract", new Macro(){

            public String doMacro() {
                return "drools.retract";
            }
        });
        Serializable compiled = MVEL.compileExpression(MVEL.parseMacros("retract(cheese)", macros));
        HashMap<String, Object> map = new HashMap<String, Object>();
        DefaultKnowledgeHelper helper = new DefaultKnowledgeHelper();
        map.put("drools", helper);
        Cheese cheese = new Cheese("stilton", 15);
        map.put("cheese", cheese);
        MVEL.executeExpression((Object)compiled, map);
        CoreConfidenceTests.assertSame((Object)cheese, helper.retracted.get(0));
    }

    public void testToList() {
        String text = "misc.toList(foo.bar.name, 'hello', 42, ['key1' : 'value1', c : [ foo.bar.age, 'car', 42 ]], [42, [c : 'value1']] )";
        List list = (List)this.test(text);
        CoreConfidenceTests.assertSame((Object)"dog", list.get(0));
        CoreConfidenceTests.assertEquals((Object)"hello", list.get(1));
        CoreConfidenceTests.assertEquals((Object)new Integer(42), list.get(2));
        Map map = (Map)list.get(3);
        CoreConfidenceTests.assertEquals((Object)"value1", map.get("key1"));
        List nestedList = (List)map.get("cat");
        CoreConfidenceTests.assertEquals((Object)14, nestedList.get(0));
        CoreConfidenceTests.assertEquals((Object)"car", nestedList.get(1));
        CoreConfidenceTests.assertEquals((Object)42, nestedList.get(2));
        nestedList = (List)list.get(4);
        CoreConfidenceTests.assertEquals((Object)42, nestedList.get(0));
        map = (Map)nestedList.get(1);
        CoreConfidenceTests.assertEquals((Object)"value1", map.get("cat"));
    }

    public void testToListStrictMode() {
        String text = "misc.toList(foo.bar.name, 'hello', 42, ['key1' : 'value1', c : [ foo.bar.age, 'car', 42 ]], [42, [c : 'value1']] )";
        ParserContext ctx = new ParserContext();
        ctx.addInput("misc", AbstractTest.MiscTestClass.class);
        ctx.addInput("foo", Foo.class);
        ctx.addInput("c", String.class);
        ctx.setStrictTypeEnforcement(true);
        ExpressionCompiler compiler = new ExpressionCompiler(text);
        CompiledExpression expr = compiler.compile(ctx);
        List list = (List)MVEL.executeExpression((Object)expr, this.map);
        CoreConfidenceTests.assertSame((Object)"dog", list.get(0));
        CoreConfidenceTests.assertEquals((Object)"hello", list.get(1));
        CoreConfidenceTests.assertEquals((Object)new Integer(42), list.get(2));
        Map map = (Map)list.get(3);
        CoreConfidenceTests.assertEquals((Object)"value1", map.get("key1"));
        List nestedList = (List)map.get("cat");
        CoreConfidenceTests.assertEquals((Object)14, nestedList.get(0));
        CoreConfidenceTests.assertEquals((Object)"car", nestedList.get(1));
        CoreConfidenceTests.assertEquals((Object)42, nestedList.get(2));
        nestedList = (List)list.get(4);
        CoreConfidenceTests.assertEquals((Object)42, nestedList.get(0));
        map = (Map)nestedList.get(1);
        CoreConfidenceTests.assertEquals((Object)"value1", map.get("cat"));
    }

    public void testParsingStability1() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("( order.number == 1 || order.number == ( 1+1) || order.number == $id )"));
    }

    public void testParsingStability2() {
        ExpressionCompiler compiler = new ExpressionCompiler("( dim.height == 1 || dim.height == ( 1+1) || dim.height == x )");
        HashMap<String, Object> imports = new HashMap<String, Object>();
        imports.put("java.awt.Dimension", Dimension.class);
        ParserContext parserContext = new ParserContext(imports, null, "sourceFile");
        parserContext.setStrictTypeEnforcement(false);
        compiler.compile(parserContext);
    }

    public void testParsingStability3() {
        CoreConfidenceTests.assertEquals((Object)false, (Object)this.test("!( [\"X\", \"Y\"] contains \"Y\" )"));
    }

    public void testParsingStability4() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("vv=\"Edson\"; !(vv ~= \"Mark\")"));
    }

    public void testConcatWithLineBreaks() {
        ExpressionCompiler parser = new ExpressionCompiler("\"foo\"+\n\"bar\"");
        ParserContext ctx = new ParserContext();
        ctx.setDebugSymbols(true);
        ctx.setSourceFile("source.mv");
        CompiledExpression c = parser.compile(ctx);
        CoreConfidenceTests.assertEquals((Object)"foobar", (Object)MVEL.executeExpression(c));
    }

    public void testCalculateAge() {
        Calendar c1 = Calendar.getInstance();
        c1.set(1999, 0, 10);
        HashMap objectMap = new HashMap(1);
        HashMap<String, Date> propertyMap = new HashMap<String, Date>(1);
        propertyMap.put("GEBDAT", c1.getTime());
        objectMap.put("EV_VI_ANT1", propertyMap);
        CoreConfidenceTests.assertEquals((Object)"N", (Object)this.test("new org.mvel.tests.main.res.PDFFieldUtil().calculateAge(EV_VI_ANT1.GEBDAT) >= 25 ? 'Y' : 'N'", null, objectMap));
    }

    public void testMethodResolutionWithNullParameter() {
        AbstractTest.Context ctx = new AbstractTest.Context();
        ctx.setBean(new AbstractTest.Bean());
        HashMap vars = new HashMap();
        System.out.println("bean.today: " + MVEL.eval("bean.today", (Object)ctx, vars));
        System.out.println("formatDate(bean.today): " + MVEL.eval("formatDate(bean.today)", (Object)ctx, vars));
        System.out.println("formatString(bean.nullString): " + MVEL.eval("formatString(bean.nullString)", (Object)ctx, vars));
        System.out.println("bean.myDate = bean.nullDate: " + MVEL.eval("bean.myDate = bean.nullDate; return bean.nullDate;", (Object)ctx, vars));
        System.out.println("formatDate(bean.myDate): " + MVEL.eval("formatDate(bean.myDate)", (Object)ctx, vars));
        System.out.println(MVEL.eval("formatDate(bean.nullDate)", (Object)ctx, vars));
    }

    public void testCompileParserContextShouldNotLoopIndefinitelyOnValidJavaExpression() {
        String expr = "\t\tSystem.out.println( message );\nm.setMessage( \"Goodbye cruel world\" );\nSystem.out.println(m.getStatus());\nm.setStatus( Message.GOODBYE );\n";
        ExpressionCompiler compiler = new ExpressionCompiler(expr);
        ParserContext context = new ParserContext();
        context.setStrictTypeEnforcement(false);
        context.addImport("Message", AbstractTest.Message.class);
        context.addInput("System", Void.TYPE);
        context.addInput("message", Object.class);
        context.addInput("m", Object.class);
        compiler.compile(context);
    }

    public void testStaticNested() {
        CoreConfidenceTests.assertEquals((Object)1, (Object)MVEL.eval("org.mvel.tests.main.AbstractTest$Message.GOODBYE", new HashMap()));
    }

    public void testStaticNestedWithImport() {
        String expr = "Message.GOODBYE;\n";
        ExpressionCompiler compiler = new ExpressionCompiler(expr);
        ParserContext context = new ParserContext();
        context.setStrictTypeEnforcement(false);
        context.addImport("Message", AbstractTest.Message.class);
        CompiledExpression compiledExpression = compiler.compile(context);
        CoreConfidenceTests.assertEquals((Object)1, (Object)MVEL.executeExpression(compiledExpression));
    }

    public void testStaticNestedWithMethodCall() {
        String expr = "item = new Item( \"Some Item\"); $msg.addItem( item ); return $msg";
        ExpressionCompiler compiler = new ExpressionCompiler(expr);
        ParserContext context = new ParserContext();
        context.setStrictTypeEnforcement(false);
        context.addImport("Message", AbstractTest.Message.class);
        context.addImport("Item", AbstractTest.Item.class);
        CompiledExpression compiledExpression = compiler.compile(context);
        HashMap<String, AbstractTest.Message> vars = new HashMap<String, AbstractTest.Message>();
        vars.put("$msg", new AbstractTest.Message());
        AbstractTest.Message msg = (AbstractTest.Message)MVEL.executeExpression((Object)compiledExpression, vars);
        AbstractTest.Item item = (AbstractTest.Item)msg.getItems().get(0);
        CoreConfidenceTests.assertEquals((String)"Some Item", (String)item.getName());
    }

    public void testsequentialAccessorsThenMethodCall() {
        String expr = "System.out.println(drools.workingMemory); drools.workingMemory.ruleBase.removeRule(\"org.drools.examples\", \"some rule\"); ";
        ExpressionCompiler compiler = new ExpressionCompiler(expr);
        ParserContext context = new ParserContext();
        context.setStrictTypeEnforcement(true);
        context.addInput("drools", KnowledgeHelper.class);
        RuleBaseImpl ruleBase = new RuleBaseImpl();
        WorkingMemoryImpl wm = new WorkingMemoryImpl(ruleBase);
        DefaultKnowledgeHelper drools = new DefaultKnowledgeHelper(wm);
        CompiledExpression compiledExpression = compiler.compile(context);
        HashMap<String, DefaultKnowledgeHelper> vars = new HashMap<String, DefaultKnowledgeHelper>();
        vars.put("drools", drools);
        MVEL.executeExpression((Object)compiledExpression, vars);
    }

    public void testPropertyVerfierShoudldNotLoopIndefinately() {
        String expr = "\t\tmodel.latestHeadlines = $list;\nmodel.latestHeadlines.add( 0, (model.latestHeadlines[2]) );";
        ExpressionCompiler compiler = new ExpressionCompiler(expr);
        compiler.setVerifying(true);
        ParserContext pCtx = new ParserContext();
        pCtx.addInput("$list", List.class);
        pCtx.addInput("model", AbstractTest.Model.class);
        compiler.compile(pCtx);
    }

    public void testCompileWithNewInsideMethodCall() {
        String expr = "     p.name = \"goober\";\n     System.out.println(p.name);\n     drools.insert(new Address(\"Latona\"));\n";
        ExpressionCompiler compiler = new ExpressionCompiler(expr);
        ParserContext context = new ParserContext();
        context.setStrictTypeEnforcement(false);
        context.addImport("Person", AbstractTest.Person.class);
        context.addImport("Address", AbstractTest.Address.class);
        context.addInput("p", AbstractTest.Person.class);
        context.addInput("drools", AbstractTest.Drools.class);
        compiler.compile(context);
    }

    public void testBug4() {
        AbstractTest.ClassA A = new AbstractTest.ClassA();
        AbstractTest.ClassB B = new AbstractTest.ClassB();
        System.out.println(MVEL.getProperty("date", A));
        System.out.println(MVEL.getProperty("date", B));
    }

    public void testInlineCollectionParser1() {
        CoreConfidenceTests.assertEquals((Object)"q", ((Map)this.test("['Person.age' : [1, 2, 3, 4],'Person.rating' : 'q']")).get("Person.rating"));
        CoreConfidenceTests.assertEquals((Object)"q", ((Map)this.test("['Person.age' : [1, 2, 3, 4], 'Person.rating' : 'q']")).get("Person.rating"));
    }

    public void testIndexer() {
        CoreConfidenceTests.assertEquals((Object)"foobar", (Object)this.test("import java.util.LinkedHashMap; LinkedHashMap map = new LinkedHashMap(); map.put('a', 'foo'); map.put('b', 'bar'); s = ''; foreach (key : map.keySet()) { System.out.println(map[key]); s += map[key]; }; return s;"));
    }

    public void testLateResolveOfClass() {
        ExpressionCompiler compiler = new ExpressionCompiler("System.out.println(new Foo());");
        ParserContext ctx = new ParserContext();
        ctx.addImport(Foo.class);
        CompiledExpression s = compiler.compile(ctx);
        compiler.removeParserContext();
        System.out.println(MVEL.executeExpression(s));
    }

    public void testClassAliasing() {
        CoreConfidenceTests.assertEquals((Object)"foobar", (Object)this.test("Foo = String; new Foo('foobar')"));
    }

    public void testRandomExpression1() {
        CoreConfidenceTests.assertEquals((Object)"HelloWorld", (Object)this.test("if ((x15 = foo.bar) == foo.bar && x15 == foo.bar) { return 'HelloWorld'; } else { return 'GoodbyeWorld' } "));
    }

    public void testRandomExpression2() {
        CoreConfidenceTests.assertEquals((Object)11, (Object)this.test("counterX = 0; foreach (item:{1,2,3,4,5,6,7,8,9,10}) { counterX++; }; return counterX + 1;"));
    }

    public void testRandomExpression3() {
        CoreConfidenceTests.assertEquals((Object)0, (Object)this.test("counterX = 10; foreach (item:{1,1,1,1,1,1,1,1,1,1}) { counterX -= item; } return counterX;"));
    }

    public void testRandomExpression4() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("result = org.mvel.MVEL.eval('10 * 3'); result == (10 * 3);"));
    }

    public void testRandomExpression5() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("FooClassRef = foo.getClass(); fooInst = new FooClassRef(); name = org.mvel.MVEL.eval('name', fooInst); return name == 'dog'"));
    }

    public void testRandomExpression6() {
        CoreConfidenceTests.assertEquals((Object)500, (Object)this.test("exprString = '250' + ' ' + '*' + ' ' + '2'; compiledExpr = org.mvel.MVEL.compileExpression(exprString); return org.mvel.MVEL.executeExpression(compiledExpr);"));
    }

    public void testRandomExpression7() {
        CoreConfidenceTests.assertEquals((Object)"FOOBAR", (Object)this.test("'foobar'.toUpperCase();"));
    }

    public void testRandomExpression8() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("'someString'.intern(); 'someString'.hashCode() == 'someString'.hashCode();"));
    }

    public void testRandomExpression9() {
        CoreConfidenceTests.assertEquals((Object)false, (Object)this.test("_abc = 'someString'.hashCode(); _xyz = _abc + 1; _abc == _xyz"));
    }

    public void testRandomExpression10() {
        CoreConfidenceTests.assertEquals((Object)false, (Object)this.test("(_abc = (_xyz = 'someString'.hashCode()) + 1); _abc == _xyz"));
    }

    public void testAddIntToMapWithMapSyntax() throws Throwable {
        this.outerMap = new HashMap<Object, Object>();
        this.innerMap = new HashMap<Object, Object>();
        this.outerMap.put("innerMap", this.innerMap);
        PropertyAccessor.set(this.outerMap, "innerMap['foo']", 42);
        CoreConfidenceTests.assertEquals((Object)42, (Object)this.innerMap.get("foo"));
    }

    public void testUpdateIntInMapWithMapSyntax() throws Throwable {
        this.outerMap = new HashMap<Object, Object>();
        this.innerMap = new HashMap<Object, Object>();
        this.outerMap.put("innerMap", this.innerMap);
        this.innerMap.put("foo", 21);
        PropertyAccessor.set(this.outerMap, "innerMap['foo']", 42);
        CoreConfidenceTests.assertEquals((Object)42, (Object)this.innerMap.get("foo"));
    }

    public void before() {
        HashMap<String, MyBean> map = new HashMap<String, MyBean>();
        MyBean bean = new MyBean();
        bean.setVar(4);
        map.put("bean", bean);
        this.context.put("map", map);
    }

    public void testDeepProperty() {
        this.before();
        Serializable compiled = MVEL.compileExpression("map.bean.var");
        Object obj = MVEL.executeExpression((Object)compiled, this.context);
        CoreConfidenceTests.assertEquals((Object)4, (Object)obj);
    }

    public void testDeepProperty2() {
        this.before();
        Serializable compiled = MVEL.compileExpression("map.bean.getVar()");
        Object obj = MVEL.executeExpression((Object)compiled, this.context);
        CoreConfidenceTests.assertEquals((Object)4, (Object)obj);
    }

    public void testNestedMethodCall() {
        ArrayList<TargetClass> elements = new ArrayList<TargetClass>();
        elements.add(new TargetClass());
        HashMap<String, ArrayList<TargetClass>> variableMap = new HashMap<String, ArrayList<TargetClass>>();
        variableMap.put("elements", elements);
        MVEL.eval("results = new java.util.ArrayList(); foreach (element : elements) { if( {5} contains element.targetValue.intValue()) { results.add(element); } }; results", variableMap);
    }

    public void testBooleanEvaluation() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("true||false||false"));
    }

    public void testBooleanEvaluation2() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("equalityCheck(1,1)||fun||ackbar"));
    }

    public void testFailing() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("os", "windows");
        CoreConfidenceTests.assertTrue((boolean)((Boolean)MVEL.eval("os ~= 'windows|unix'", map)));
    }

    public void testSuccess() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("os", "windows");
        CoreConfidenceTests.assertTrue((boolean)((Boolean)MVEL.eval("'windows' ~= 'windows|unix'", map)));
        CoreConfidenceTests.assertFalse((boolean)((Boolean)MVEL.eval("time ~= 'windows|unix'", new Date())));
    }

    public void testBooleanStrAppend() {
        CoreConfidenceTests.assertEquals((Object)"footrue", (Object)this.test("\"foo\" + true"));
    }

    public static class TargetClass {
        private short _targetValue = (short)5;

        public short getTargetValue() {
            return this._targetValue;
        }
    }

    public class MyBean {
        int var;

        public int getVar() {
            return this.var;
        }

        public void setVar(int var) {
            this.var = var;
        }
    }
}

