/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.mvel.CompileException;
import org.mvel.ConversionException;
import org.mvel.DataConversion;
import org.mvel.math.MathProcessor;
import org.mvel.util.ParseTools;
import org.mvel.util.PropertyTools;

public class JDK14CompatabilityMath
implements MathProcessor {
    public static final int ROUND_MODE = 2;
    public static final int SCALE = 128;

    public Object doOperation(Object val1, int operation, Object val2) {
        int type2;
        int type1 = val1 == null ? -1 : ParseTools.resolveType(val1.getClass());
        int n = type2 = val2 == null ? -1 : ParseTools.resolveType(val2.getClass());
        if (type1 == 110) {
            if (type2 == 110) {
                return JDK14CompatabilityMath.doBigDecimalArithmetic((BigDecimal)val1, operation, (BigDecimal)val2);
            }
            if (type2 > 99) {
                return JDK14CompatabilityMath.doBigDecimalArithmetic((BigDecimal)val1, operation, JDK14CompatabilityMath.getBigDecimalFromType(val2, type2));
            }
            return JDK14CompatabilityMath._doOperations(type1, val1, operation, type2, val2);
        }
        if (type2 == 110 && (type1 > 99 || type1 == 1 && PropertyTools.isNumber(val1))) {
            return JDK14CompatabilityMath.doBigDecimalArithmetic(JDK14CompatabilityMath.getBigDecimalFromType(val1, type1), operation, (BigDecimal)val2);
        }
        return JDK14CompatabilityMath._doOperations(type1, val1, operation, type2, val2);
    }

    private static Object doBigDecimalArithmetic(BigDecimal val1, int operation, BigDecimal val2) {
        switch (operation) {
            case 0: {
                return val1.add(val2);
            }
            case 3: {
                return val1.divide(val2, 128, 2);
            }
            case 1: {
                return val1.subtract(val2);
            }
            case 2: {
                return val1.multiply(val2);
            }
            case 9: {
                return Math.pow(val1.doubleValue(), val2.doubleValue());
            }
            case 4: {
                return val1.doubleValue() % val2.doubleValue();
            }
            case 6: {
                return val1.compareTo(val2) == 1 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 8: {
                return val1.compareTo(val2) >= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return val1.compareTo(val2) == -1 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 7: {
                return val1.compareTo(val2) <= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 10: {
                return val1.compareTo(val2) == 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 11: {
                return val1.compareTo(val2) != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return null;
    }

    private static Object _doOperations(int type1, Object val1, int operation, int type2, Object val2) {
        if (operation < 10 || operation == 10 || operation == 11) {
            if (type1 > 99 && type1 == type2) {
                return JDK14CompatabilityMath.doOperationsSameType(type1, val1, operation, val2);
            }
            if (type1 > 99 && type2 > 99 || PropertyTools.isNumber(val1) && PropertyTools.isNumber(val2)) {
                return JDK14CompatabilityMath.doBigDecimalArithmetic(JDK14CompatabilityMath.getBigDecimalFromType(val1, type1), operation, JDK14CompatabilityMath.getBigDecimalFromType(val2, type2));
            }
            if ((type1 == 15 || type2 == 15) && type1 != type2) {
                return JDK14CompatabilityMath.doOperationNonNumeric(DataConversion.convert(val1, Boolean.class), operation, DataConversion.convert(val2, Boolean.class));
            }
        }
        return JDK14CompatabilityMath.doOperationNonNumeric(val1, operation, val2);
    }

    private static Object doOperationNonNumeric(Object val1, int operation, Object val2) {
        switch (operation) {
            case 0: {
                return String.valueOf(val1) + String.valueOf(val2);
            }
            case 10: {
                return JDK14CompatabilityMath.safeEquals(val2, val1);
            }
            case 11: {
                return JDK14CompatabilityMath.safeNotEquals(val2, val1);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                throw new CompileException("could not perform numeric operation on non-numeric types: left-type=" + (val1 != null ? val1.getClass().getName() : "null") + "; right-type=" + (val2 != null ? val2.getClass().getName() : "null"));
            }
        }
        throw new CompileException("unable to perform operation");
    }

    private static Boolean safeEquals(Object val1, Object val2) {
        if (val1 != null) {
            return val1.equals(val2);
        }
        if (val2 != null) {
            return val2.equals(val1);
        }
        return val1 == val2;
    }

    private static Boolean safeNotEquals(Object val1, Object val2) {
        if (val1 != null) {
            return !val1.equals(val2);
        }
        return val2 != null && !val2.equals(val1);
    }

    private static Object doOperationsSameType(int type1, Object val1, int operation, Object val2) {
        switch (type1) {
            case 101: 
            case 106: {
                switch (operation) {
                    case 0: {
                        return (Integer)val1 + (Integer)val2;
                    }
                    case 1: {
                        return (Integer)val1 - (Integer)val2;
                    }
                    case 3: {
                        return new BigDecimal((Integer)val1).divide(new BigDecimal((Integer)val2), 128, 2);
                    }
                    case 2: {
                        return (Integer)val1 * (Integer)val2;
                    }
                    case 9: {
                        double d = Math.pow(((Integer)val1).intValue(), ((Integer)val2).intValue());
                        if (d > 2.147483647E9) {
                            return d;
                        }
                        return (int)d;
                    }
                    case 4: {
                        return (Integer)val1 % (Integer)val2;
                    }
                    case 6: {
                        return (Integer)val1 > (Integer)val2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 8: {
                        return (Integer)val1 >= (Integer)val2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 5: {
                        return (Integer)val1 < (Integer)val2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 7: {
                        return (Integer)val1 <= (Integer)val2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 10: {
                        return ((Integer)val1).intValue() == ((Integer)val2).intValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 11: {
                        return ((Integer)val1).intValue() != ((Integer)val2).intValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                }
            }
            case 100: 
            case 105: {
                switch (operation) {
                    case 0: {
                        return (Short)val1 + (Short)val2;
                    }
                    case 1: {
                        return (Short)val1 - (Short)val2;
                    }
                    case 3: {
                        return new BigDecimal(((Short)val1).shortValue()).divide(new BigDecimal(((Short)val2).shortValue()), 128, 2);
                    }
                    case 2: {
                        return (Short)val1 * (Short)val2;
                    }
                    case 9: {
                        double d = Math.pow(((Short)val1).shortValue(), ((Short)val2).shortValue());
                        if (d > 32767.0) {
                            return d;
                        }
                        return (short)d;
                    }
                    case 4: {
                        return (Short)val1 % (Short)val2;
                    }
                    case 6: {
                        return (Short)val1 > (Short)val2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 8: {
                        return (Short)val1 >= (Short)val2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 5: {
                        return (Short)val1 < (Short)val2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 7: {
                        return (Short)val1 <= (Short)val2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 10: {
                        return ((Short)val1).shortValue() == ((Short)val2).shortValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 11: {
                        return ((Short)val1).shortValue() != ((Short)val2).shortValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                }
            }
            case 102: 
            case 107: {
                switch (operation) {
                    case 0: {
                        return (Long)val1 + (Long)val2;
                    }
                    case 1: {
                        return (Long)val1 - (Long)val2;
                    }
                    case 3: {
                        return new BigDecimal((Long)val1).divide(new BigDecimal((Long)val2), 128, 2);
                    }
                    case 2: {
                        return (Long)val1 * (Long)val2;
                    }
                    case 9: {
                        double d = Math.pow(((Long)val1).longValue(), ((Long)val2).longValue());
                        if (d > 9.223372036854776E18) {
                            return d;
                        }
                        return (long)d;
                    }
                    case 4: {
                        return (Long)val1 % (Long)val2;
                    }
                    case 6: {
                        return (Long)val1 > (Long)val2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 8: {
                        return (Long)val1 >= (Long)val2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 5: {
                        return (Long)val1 < (Long)val2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 7: {
                        return (Long)val1 <= (Long)val2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 10: {
                        return ((Long)val1).longValue() == ((Long)val2).longValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 11: {
                        return ((Long)val1).longValue() != ((Long)val2).longValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                }
            }
            case 103: 
            case 108: {
                switch (operation) {
                    case 0: {
                        return (Double)val1 + (Double)val2;
                    }
                    case 1: {
                        return (Double)val1 - (Double)val2;
                    }
                    case 3: {
                        return new BigDecimal((Double)val1).divide(new BigDecimal((Double)val2), 128, 2);
                    }
                    case 2: {
                        return (Double)val1 * (Double)val2;
                    }
                    case 9: {
                        return Math.pow((Double)val1, (Double)val2);
                    }
                    case 4: {
                        return (Double)val1 % (Double)val2;
                    }
                    case 6: {
                        return (Double)val1 > (Double)val2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 8: {
                        return (Double)val1 >= (Double)val2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 5: {
                        return (Double)val1 < (Double)val2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 7: {
                        return (Double)val1 <= (Double)val2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 10: {
                        return ((Double)val1).doubleValue() == ((Double)val2).doubleValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 11: {
                        return ((Double)val1).doubleValue() != ((Double)val2).doubleValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                }
            }
            case 104: 
            case 109: {
                switch (operation) {
                    case 0: {
                        return Float.valueOf(((Float)val1).floatValue() + ((Float)val2).floatValue());
                    }
                    case 1: {
                        return Float.valueOf(((Float)val1).floatValue() - ((Float)val2).floatValue());
                    }
                    case 3: {
                        return new BigDecimal(((Float)val1).floatValue()).divide(new BigDecimal(((Float)val2).floatValue()), 128, 2);
                    }
                    case 2: {
                        return Float.valueOf(((Float)val1).floatValue() * ((Float)val2).floatValue());
                    }
                    case 9: {
                        Math.pow(((Float)val1).floatValue(), ((Float)val2).floatValue());
                    }
                    case 4: {
                        return Float.valueOf(((Float)val1).floatValue() % ((Float)val2).floatValue());
                    }
                    case 6: {
                        return ((Float)val1).floatValue() > ((Float)val2).floatValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 8: {
                        return ((Float)val1).floatValue() >= ((Float)val2).floatValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 5: {
                        return ((Float)val1).floatValue() < ((Float)val2).floatValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 7: {
                        return ((Float)val1).floatValue() <= ((Float)val2).floatValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 10: {
                        return ((Float)val1).floatValue() == ((Float)val2).floatValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 11: {
                        return ((Float)val1).floatValue() != ((Float)val2).floatValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                }
            }
            case 111: {
                switch (operation) {
                    case 0: {
                        return ((BigInteger)val1).add((BigInteger)val2);
                    }
                    case 1: {
                        return ((BigInteger)val1).subtract((BigInteger)val2);
                    }
                    case 3: {
                        return ((BigInteger)val1).divide((BigInteger)val2);
                    }
                    case 2: {
                        return ((BigInteger)val1).multiply((BigInteger)val2);
                    }
                    case 9: {
                        return ((BigInteger)val1).pow(((BigInteger)val2).intValue());
                    }
                    case 4: {
                        return ((BigInteger)val1).remainder((BigInteger)val2);
                    }
                    case 6: {
                        return ((BigInteger)val1).compareTo((BigInteger)val2) == 1 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 8: {
                        return ((BigInteger)val1).compareTo((BigInteger)val2) >= 0 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 5: {
                        return ((BigInteger)val1).compareTo((BigInteger)val2) == -1 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 7: {
                        return ((BigInteger)val1).compareTo((BigInteger)val2) <= 0 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 10: {
                        return ((BigInteger)val1).compareTo((BigInteger)val2) == 0 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 11: {
                        return ((BigInteger)val1).compareTo((BigInteger)val2) != 0 ? Boolean.TRUE : Boolean.FALSE;
                    }
                }
            }
        }
        switch (operation) {
            case 10: {
                return JDK14CompatabilityMath.safeEquals(val2, val1) != false ? Boolean.TRUE : Boolean.FALSE;
            }
            case 11: {
                return JDK14CompatabilityMath.safeNotEquals(val2, val1) != false ? Boolean.TRUE : Boolean.FALSE;
            }
            case 0: {
                return String.valueOf(val1) + String.valueOf(val2);
            }
        }
        return null;
    }

    public static BigDecimal getBigDecimalFromType(Object in, int type) {
        if (in == null) {
            return new BigDecimal(0);
        }
        switch (type) {
            case 110: {
                return (BigDecimal)in;
            }
            case 111: {
                return new BigDecimal((BigInteger)in);
            }
            case 106: {
                return BigDecimal.valueOf(((Integer)in).intValue());
            }
            case 107: {
                return BigDecimal.valueOf((Long)in);
            }
            case 1: {
                return new BigDecimal((String)in);
            }
            case 109: {
                return new BigDecimal(((Float)in).floatValue());
            }
            case 108: {
                return new BigDecimal((Double)in);
            }
            case 105: {
                return BigDecimal.valueOf(((Short)in).shortValue());
            }
            case 15: {
                return BigDecimal.valueOf((Boolean)in != false ? 1L : 0L);
            }
        }
        throw new ConversionException("cannot convert <" + in + "> to a numeric type");
    }
}

