/*
 * Decompiled with CFR 0.152.
 */
package org.mvel;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.mvel.ASTNode;
import org.mvel.BlankLiteral;
import org.mvel.CompileException;
import org.mvel.ErrorDetail;
import org.mvel.MVEL;
import org.mvel.ParseException;
import org.mvel.ParserContext;
import org.mvel.ast.AssertNode;
import org.mvel.ast.AssignAdd;
import org.mvel.ast.AssignDiv;
import org.mvel.ast.AssignMult;
import org.mvel.ast.AssignSub;
import org.mvel.ast.AssignmentNode;
import org.mvel.ast.DeepAssignmentNode;
import org.mvel.ast.EndOfStatement;
import org.mvel.ast.ForEachNode;
import org.mvel.ast.IfNode;
import org.mvel.ast.ImportNode;
import org.mvel.ast.InlineCollectionNode;
import org.mvel.ast.InterceptorWrapper;
import org.mvel.ast.LineLabel;
import org.mvel.ast.LiteralDeepPropertyNode;
import org.mvel.ast.LiteralNode;
import org.mvel.ast.NewObjectNode;
import org.mvel.ast.PostFixDecNode;
import org.mvel.ast.PostFixIncNode;
import org.mvel.ast.PreFixDecNode;
import org.mvel.ast.PreFixIncNode;
import org.mvel.ast.PropertyASTNode;
import org.mvel.ast.RegExMatch;
import org.mvel.ast.ReturnNode;
import org.mvel.ast.StaticImportNode;
import org.mvel.ast.Substatement;
import org.mvel.ast.ThisValDeepPropertyNode;
import org.mvel.ast.TypeCast;
import org.mvel.ast.TypedVarNode;
import org.mvel.ast.Union;
import org.mvel.ast.WithNode;
import org.mvel.util.ArrayTools;
import org.mvel.util.ExecutionStack;
import org.mvel.util.ParseTools;
import org.mvel.util.PropertyTools;
import org.mvel.util.Stack;
import org.mvel.util.ThisLiteral;

public class AbstractParser
implements Serializable {
    protected char[] expr;
    protected int cursor;
    protected int length;
    protected int fields;
    protected boolean greedy = true;
    protected boolean lastWasIdentifier = false;
    protected boolean lastWasLineLabel = false;
    protected boolean lastWasComment = false;
    protected boolean debugSymbols = false;
    private int line = 1;
    protected ASTNode lastNode;
    private static Map<String, char[]> EX_PRECACHE;
    public static final Map<String, Object> LITERALS;
    public static final Map<String, Integer> OPERATORS;
    protected Stack stk;
    protected ExecutionStack splitAccumulator = new ExecutionStack();
    protected static ThreadLocal<ParserContext> parserContext;
    protected static final int SET = 0;
    protected static final int REMOVE = 1;
    protected static final int GET = 2;
    protected static final int GET_OR_CREATE = 3;
    public static final int LEVEL_5_CONTROL_FLOW = 5;
    public static final int LEVEL_4_ASSIGNMENT = 4;
    public static final int LEVEL_3_ITERATION = 3;
    public static final int LEVEL_2_MULTI_STATEMENT = 2;
    public static final int LEVEL_1_BASIC_LANG = 1;
    public static final int LEVEL_0_PROPERTY_ONLY = 0;

    static void configureFactory() {
        EX_PRECACHE = MVEL.THREAD_SAFE ? Collections.synchronizedMap(new WeakHashMap(10)) : new WeakHashMap<String, char[]>(10);
    }

    protected ASTNode nextTokenSkipSymbols() {
        ASTNode n = this.nextToken();
        if (n != null && n.getFields() == -1) {
            n = this.nextToken();
        }
        return n;
    }

    protected ASTNode nextToken() {
        if (this.cursor >= this.length) {
            return null;
        }
        if (!this.splitAccumulator.isEmpty()) {
            this.lastNode = (ASTNode)this.splitAccumulator.pop();
            return this.lastNode;
        }
        int start = this.cursor;
        this.fields &= 0x8010;
        boolean capture = false;
        boolean union = false;
        if (this.debugSymbols) {
            if (!this.lastWasLineLabel) {
                if (this.getParserContext().getSourceFile() == null) {
                    throw new CompileException("unable to produce debugging symbols: source name must be provided.");
                }
                ParserContext pCtx = this.getParserContext();
                this.line = pCtx.getLineCount();
                this.skipWhitespaceWithLineAccounting();
                if (!pCtx.isKnownLine(pCtx.getSourceFile(), pCtx.setLineCount(this.line)) && !pCtx.isBlockSymbols()) {
                    this.lastWasLineLabel = true;
                    pCtx.setLineAndOffset(this.line, this.cursor);
                    pCtx.addKnownLine(this.line);
                    this.lastNode = pCtx.setLastLineLabel(new LineLabel(pCtx.getSourceFile(), this.line));
                    return this.lastNode;
                }
            } else {
                this.lastWasLineLabel = false;
                this.lastWasComment = false;
            }
        }
        while (start < this.length && Character.isWhitespace(this.expr[start])) {
            ++start;
        }
        this.cursor = start;
        block72: while (this.cursor < this.length) {
            int brace;
            if (PropertyTools.isIdentifierPart(this.expr[this.cursor])) {
                capture = true;
                ++this.cursor;
                continue;
            }
            if (capture) {
                String t = new String(this.expr, start, this.cursor - start);
                if (OPERATORS.containsKey(t)) {
                    switch (OPERATORS.get(t)) {
                        case 33: {
                            start = this.cursor + 1;
                            this.captureToEOT();
                            this.lastNode = new NewObjectNode(this.subArray(start, this.cursor), this.fields);
                            return this.lastNode;
                        }
                        case 97: {
                            start = this.cursor + 1;
                            this.captureToEOS();
                            this.lastNode = new AssertNode(this.subArray(start, this.cursor--), this.fields);
                            return this.lastNode;
                        }
                        case 99: {
                            start = this.cursor + 1;
                            this.captureToEOS();
                            this.lastNode = new ReturnNode(this.subArray(start, this.cursor), this.fields);
                            return this.lastNode;
                        }
                        case 38: {
                            this.fields |= 0x40000;
                            return this.captureCodeBlock();
                        }
                        case 37: {
                            this.fields |= 0x80000;
                            return this.captureCodeBlock();
                        }
                        case 44: {
                            this.fields |= 0x100000;
                            return this.captureCodeBlock();
                        }
                        case 96: {
                            start = this.cursor + 1;
                            this.captureToEOS();
                            ImportNode importNode = new ImportNode(this.subArray(start, this.cursor--), this.fields);
                            this.getParserContext().addImport(ParseTools.getSimpleClassName(importNode.getImportClass()), importNode.getImportClass());
                            return importNode;
                        }
                        case 95: {
                            start = this.cursor + 1;
                            this.captureToEOS();
                            this.lastNode = new StaticImportNode(this.subArray(start, this.cursor--), this.fields);
                            return this.lastNode;
                        }
                    }
                }
                this.skipWhitespace();
                if (this.expr[this.cursor] == '(') {
                    this.fields |= 0x400;
                    ++this.cursor;
                    brace = 1;
                    while (this.cursor < this.length && brace > 0) {
                        switch (this.expr[this.cursor++]) {
                            case '(': {
                                ++brace;
                                break;
                            }
                            case ')': {
                                --brace;
                                break;
                            }
                            case '\'': {
                                this.cursor = ParseTools.captureStringLiteral('\'', this.expr, this.cursor, this.length) + 1;
                                break;
                            }
                            case '\"': {
                                this.cursor = ParseTools.captureStringLiteral('\"', this.expr, this.cursor, this.length) + 1;
                            }
                        }
                    }
                    if (brace > 0) {
                        throw new CompileException("unbalanced braces in expression: (" + brace + "):", this.expr, this.cursor);
                    }
                }
                if (this.cursor < this.length) {
                    switch (this.expr[this.cursor]) {
                        case '+': {
                            switch (this.lookAhead(1)) {
                                case '+': {
                                    PostFixIncNode n = new PostFixIncNode(this.subArray(start, this.cursor), this.fields);
                                    this.cursor += 2;
                                    this.lastNode = n;
                                    return this.lastNode;
                                }
                                case '=': {
                                    String name = new String(this.expr, start, this.trimLeft(this.cursor) - start);
                                    start = this.cursor += 2;
                                    this.captureToEOS();
                                    if (union) {
                                        this.lastNode = new DeepAssignmentNode(this.subArray(start, this.cursor), this.fields, 0, t);
                                        return this.lastNode;
                                    }
                                    this.lastNode = new AssignmentNode(this.subArray(start, this.cursor), this.fields, 0, name);
                                    return this.lastNode;
                                }
                            }
                            break;
                        }
                        case '-': {
                            switch (this.lookAhead(1)) {
                                case '-': {
                                    PostFixDecNode n = new PostFixDecNode(this.subArray(start, this.cursor), this.fields);
                                    this.cursor += 2;
                                    this.lastNode = n;
                                    return this.lastNode;
                                }
                                case '=': {
                                    String name = new String(this.expr, start, this.trimLeft(this.cursor) - start);
                                    start = this.cursor += 2;
                                    this.captureToEOS();
                                    this.lastNode = new AssignSub(this.subArray(start, this.cursor), this.fields, name);
                                    return this.lastNode;
                                }
                            }
                            break;
                        }
                        case '*': {
                            if (!this.isAt('=', 1)) break;
                            String name = new String(this.expr, start, this.trimLeft(this.cursor) - start);
                            start = this.cursor += 2;
                            this.captureToEOS();
                            this.lastNode = new AssignMult(this.subArray(start, this.cursor), this.fields, name);
                            return this.lastNode;
                        }
                        case '/': {
                            if (!this.isAt('=', 1)) break;
                            String name = new String(this.expr, start, this.trimLeft(this.cursor) - start);
                            start = this.cursor += 2;
                            this.captureToEOS();
                            this.lastNode = new AssignDiv(this.subArray(start, this.cursor), this.fields, name);
                            return this.lastNode;
                        }
                        case '[': 
                        case ']': {
                            this.cursor = ParseTools.balancedCapture(this.expr, this.cursor, '[') + 1;
                            continue block72;
                        }
                        case '.': {
                            union = true;
                            ++this.cursor;
                            continue block72;
                        }
                        case '~': {
                            if (!this.isAt('=', 1)) break;
                            char[] stmt = this.subArray(start, this.trimLeft(this.cursor));
                            start = this.cursor += 2;
                            this.skipWhitespace();
                            this.cursor = ParseTools.balancedCapture(this.expr, this.cursor, this.expr[this.cursor]) + 1;
                            this.lastNode = new RegExMatch(stmt, this.fields, this.subArray(start, this.cursor));
                            return this.lastNode;
                        }
                        case '=': {
                            if (this.isAt('+', 1)) {
                                String name = new String(this.expr, start, this.trimLeft(this.cursor) - start);
                                start = this.cursor += 2;
                                this.captureToEOS();
                                this.lastNode = new AssignAdd(this.subArray(start, this.cursor), this.fields, name);
                                return this.lastNode;
                            }
                            if (!this.greedy || this.isAt('=', 1)) break;
                            ++this.cursor;
                            this.fields |= 0x800;
                            this.skipWhitespace();
                            this.captureToEOS();
                            if (union) {
                                this.lastNode = new DeepAssignmentNode(this.subArray(start, this.cursor), this.fields);
                                return this.lastNode;
                            }
                            if (this.lastWasIdentifier) {
                                if (this.lastNode.getLiteralValue() instanceof String) {
                                    if (this.getParserContext().hasImport((String)this.lastNode.getLiteralValue())) {
                                        this.lastNode.setLiteralValue(this.getParserContext().getImport((String)this.lastNode.getLiteralValue()));
                                        this.lastNode.setAsLiteral();
                                        this.lastNode.discard();
                                    } else if (this.stk != null && this.stk.peek() instanceof Class) {
                                        this.lastNode.setLiteralValue(this.stk.pop());
                                        this.lastNode.setAsLiteral();
                                        this.lastNode.discard();
                                    } else {
                                        try {
                                            this.lastNode.setLiteralValue(ParseTools.createClass((String)this.lastNode.getLiteralValue()));
                                            this.lastNode.setAsLiteral();
                                            this.lastNode.discard();
                                        }
                                        catch (ClassNotFoundException e) {
                                            // empty catch block
                                        }
                                    }
                                }
                                if (this.lastNode.isLiteral() && this.lastNode.getLiteralValue() instanceof Class) {
                                    this.lastNode.discard();
                                    this.captureToEOS();
                                    return new TypedVarNode(this.subArray(start, this.cursor), this.fields, (Class)this.lastNode.getLiteralValue());
                                }
                                throw new ParseException("unknown class: " + this.lastNode.getLiteralValue());
                            }
                            this.lastNode = new AssignmentNode(this.subArray(start, this.cursor), this.fields);
                            return this.lastNode;
                        }
                    }
                }
                this.trimWhitespace();
                return this.createPropertyToken(start, this.cursor);
            }
            switch (this.expr[this.cursor]) {
                case '@': {
                    this.captureToEOT();
                    String interceptorName = new String(this.expr, ++start, this.cursor - start);
                    if (this.getParserContext().getInterceptors() == null || !this.getParserContext().getInterceptors().containsKey(interceptorName)) {
                        throw new CompileException("reference to undefined interceptor: " + interceptorName, this.expr, this.cursor);
                    }
                    this.lastNode = new InterceptorWrapper(this.getParserContext().getInterceptors().get(interceptorName), this.nextToken());
                    return this.lastNode;
                }
                case '=': {
                    return this.createToken(this.expr, start, this.cursor += 2, this.fields);
                }
                case '-': {
                    if (this.isAt('-', 1)) {
                        start = this.cursor += 2;
                        this.captureToEOT();
                        this.lastNode = new PreFixDecNode(this.subArray(start, this.cursor), this.fields);
                        return this.lastNode;
                    }
                    if (this.cursor > 0 && !Character.isWhitespace(this.lookBehind(1)) || !PropertyTools.isDigit(this.lookAhead(1))) {
                        return this.createToken(this.expr, start, this.cursor++ + 1, this.fields);
                    }
                    if (this.cursor - 1 < 0 || !PropertyTools.isDigit(this.lookBehind(1)) && PropertyTools.isDigit(this.lookAhead(1))) {
                        ++this.cursor;
                        continue block72;
                    }
                }
                case '+': {
                    if (this.isAt('+', 1)) {
                        start = this.cursor += 2;
                        this.captureToEOT();
                        this.lastNode = new PreFixIncNode(this.subArray(start, this.cursor), this.fields);
                        return this.lastNode;
                    }
                    return this.createToken(this.expr, start, this.cursor++ + 1, this.fields);
                }
                case '*': {
                    if (this.isAt('*', 1)) {
                        ++this.cursor;
                    }
                    return this.createToken(this.expr, start, this.cursor++ + 1, this.fields);
                }
                case ';': {
                    ++this.cursor;
                    this.lastWasIdentifier = false;
                    this.lastNode = new EndOfStatement();
                    return this.lastNode;
                }
                case '#': 
                case '/': {
                    if (this.isAt(this.expr[this.cursor], 1)) {
                        while (this.cursor < this.length && this.expr[this.cursor] != '\n') {
                            ++this.cursor;
                        }
                        if (this.debugSymbols) {
                            this.line = this.getParserContext().getLineCount();
                            this.skipWhitespaceWithLineAccounting();
                            if (this.lastNode instanceof LineLabel) {
                                this.getParserContext().getLastLineLabel().setLineNumber(this.line);
                                this.getParserContext().addKnownLine(this.line);
                            }
                            this.lastWasComment = true;
                            this.getParserContext().setLineCount(this.line);
                        } else if (this.cursor < this.length) {
                            this.skipWhitespace();
                        }
                        if ((start = this.cursor) < this.length) continue block72;
                        return null;
                    }
                    if (this.expr[this.cursor] == '/' && this.isAt('*', 1)) {
                        int len = this.length - 1;
                        if (this.debugSymbols) {
                            this.line = this.getParserContext().getLineCount();
                        }
                        do {
                            ++this.cursor;
                            if (this.debugSymbols) {
                                this.skipWhitespaceWithLineAccounting();
                            }
                            if (this.cursor != len) continue;
                            throw new CompileException("unterminated block comment", this.expr, this.cursor);
                        } while (this.expr[this.cursor] != '*' || !this.isAt('/', 1));
                        if ((this.cursor += 2) >= this.length) {
                            return null;
                        }
                        this.skipWhitespaceWithLineAccounting();
                        start = this.cursor;
                        if (!this.debugSymbols) continue block72;
                        this.getParserContext().setLineCount(this.line);
                        if (this.lastNode instanceof LineLabel) {
                            this.getParserContext().getLastLineLabel().setLineNumber(this.line);
                            this.getParserContext().addKnownLine(this.line);
                        }
                        this.lastWasComment = true;
                        continue block72;
                    }
                }
                case '%': 
                case ':': 
                case '?': 
                case '^': {
                    return this.createToken(this.expr, start, this.cursor++ + 1, this.fields);
                }
                case '(': {
                    ++this.cursor;
                    boolean singleToken = true;
                    boolean lastWS = false;
                    this.skipWhitespace();
                    brace = 1;
                    while (this.cursor < this.length && brace > 0) {
                        switch (this.expr[this.cursor]) {
                            case '(': {
                                ++brace;
                                break;
                            }
                            case ')': {
                                --brace;
                                break;
                            }
                            case '\'': {
                                this.cursor = ParseTools.captureStringLiteral('\'', this.expr, this.cursor, this.length);
                                break;
                            }
                            case '\"': {
                                this.cursor = ParseTools.captureStringLiteral('\"', this.expr, this.cursor, this.length);
                                break;
                            }
                            case 'i': {
                                if (!this.isAt('n', 1) || !Character.isWhitespace(this.lookAhead(2))) break;
                                this.fields |= 0x200;
                                int level = brace;
                                while (this.cursor < this.length) {
                                    switch (this.expr[this.cursor]) {
                                        case '(': {
                                            ++brace;
                                            break;
                                        }
                                        case ')': {
                                            if (--brace >= level) break;
                                            if (this.lookAhead(1) == '.') {
                                                int n = this.trimRight(start + 1);
                                                start = this.cursor++;
                                                ASTNode node = this.createToken(this.expr, n, start, 512);
                                                this.captureToEOT();
                                                this.lastNode = new Union(this.expr, this.trimRight(start + 2), this.cursor, this.fields, node);
                                                return this.lastNode;
                                            }
                                            return this.createToken(this.expr, this.trimRight(start + 1), this.cursor++, 512);
                                        }
                                        case '\'': {
                                            this.cursor = ParseTools.captureStringLiteral('\'', this.expr, this.cursor, this.length);
                                            break;
                                        }
                                        case '\"': {
                                            this.cursor = ParseTools.captureStringLiteral('\'', this.expr, this.cursor, this.length);
                                        }
                                    }
                                    ++this.cursor;
                                }
                                break;
                            }
                            default: {
                                if (lastWS || !PropertyTools.isIdentifierPart(this.expr[this.cursor])) {
                                    singleToken = false;
                                    break;
                                }
                                if (!Character.isWhitespace(this.expr[this.cursor])) break;
                                lastWS = true;
                                this.skipWhitespace();
                                --this.cursor;
                            }
                        }
                        ++this.cursor;
                    }
                    if (brace > 0) {
                        throw new CompileException("unbalanced braces in expression: (" + brace + "):", this.expr, this.cursor);
                    }
                    char[] _subset = null;
                    if (singleToken) {
                        int st = this.trimRight(start + 1);
                        _subset = ParseTools.subset(this.expr, st, this.trimLeft(this.cursor - 1) - st);
                        String tokenStr = new String(_subset);
                        if (this.getParserContext().hasImport(tokenStr)) {
                            start = this.cursor;
                            this.captureToEOS();
                            this.lastNode = new TypeCast(this.expr, start, this.cursor, this.fields, this.getParserContext().getImport(tokenStr));
                            return this.lastNode;
                        }
                        try {
                            int _start = this.cursor;
                            this.captureToEOS();
                            this.lastNode = new TypeCast(this.expr, _start, this.cursor, this.fields, ParseTools.createClass(tokenStr));
                            return this.lastNode;
                        }
                        catch (ClassNotFoundException e) {
                            // empty catch block
                        }
                    }
                    if (_subset != null) {
                        return this.handleUnion(new Substatement(_subset, this.fields));
                    }
                    start = this.trimRight(start + 1);
                    return this.handleUnion(new Substatement(ParseTools.subset(this.expr, start, this.trimLeft(this.cursor - 1) - start), this.fields));
                }
                case ')': 
                case ']': 
                case '}': {
                    throw new ParseException("unbalanced braces", this.expr, this.cursor);
                }
                case '>': {
                    if (this.expr[this.cursor + 1] == '>') {
                        if (this.expr[this.cursor += 2] == '>') {
                            ++this.cursor;
                        }
                        return this.createToken(this.expr, start, this.cursor, this.fields);
                    }
                    if (this.expr[this.cursor + 1] == '=') {
                        return this.createToken(this.expr, start, this.cursor += 2, this.fields);
                    }
                    return this.createToken(this.expr, start, ++this.cursor, this.fields);
                }
                case '<': {
                    if (this.expr[++this.cursor] == '<') {
                        if (this.expr[++this.cursor] == '<') {
                            ++this.cursor;
                        }
                        return this.createToken(this.expr, start, this.cursor, this.fields);
                    }
                    if (this.expr[this.cursor] == '=') {
                        return this.createToken(this.expr, start, ++this.cursor, this.fields);
                    }
                    return this.createToken(this.expr, start, this.cursor, this.fields);
                }
                case '\"': 
                case '\'': {
                    this.cursor = ParseTools.captureStringLiteral(this.expr[this.cursor], this.expr, this.cursor, this.length);
                    this.lastNode = new LiteralNode(ParseTools.handleStringEscapes(ParseTools.subset(this.expr, start + 1, this.cursor++ - start - 1)), String.class);
                    if (this.tokenContinues()) {
                        return this.handleUnion(this.lastNode);
                    }
                    return this.lastNode;
                }
                case '&': {
                    if (this.expr[this.cursor++ + 1] == '&') {
                        return this.createToken(this.expr, start, ++this.cursor, this.fields);
                    }
                    return this.createToken(this.expr, start, this.cursor, this.fields);
                }
                case '|': {
                    if (this.expr[this.cursor++ + 1] == '|') {
                        return this.createToken(this.expr, start, ++this.cursor, this.fields);
                    }
                    return this.createToken(this.expr, start, this.cursor, this.fields);
                }
                case '~': {
                    if ((this.cursor - 1 < 0 || !PropertyTools.isIdentifierPart(this.lookBehind(1))) && PropertyTools.isDigit(this.expr[this.cursor + 1])) {
                        this.fields |= 0x100;
                        ++start;
                        ++this.cursor;
                        continue block72;
                    }
                    if (this.expr[this.cursor + 1] == '(') {
                        this.fields |= 0x100;
                        start = ++this.cursor;
                        continue block72;
                    }
                    if (this.expr[this.cursor + 1] == '=') {
                        ++this.cursor;
                    }
                    return this.createToken(this.expr, start, ++this.cursor, this.fields);
                }
                case '!': {
                    if (PropertyTools.isIdentifierPart(this.expr[++this.cursor]) || this.expr[this.cursor] == '(') {
                        start = this.cursor;
                        this.fields |= 0x40;
                        continue block72;
                    }
                    if (this.expr[this.cursor] != '=') {
                        throw new CompileException("unexpected operator '!'", this.expr, this.cursor, null);
                    }
                    return this.createToken(this.expr, start, ++this.cursor, this.fields);
                }
                case '[': 
                case '{': {
                    this.cursor = ParseTools.balancedCapture(this.expr, this.cursor, this.expr[this.cursor]);
                    if (this.cursor == -1) {
                        if (this.cursor >= this.length) {
                            --this.cursor;
                        }
                        throw new CompileException("unbalanced brace: in inline map/list/array creation", this.expr, this.cursor);
                    }
                    ++this.cursor;
                    if (this.tokenContinues()) {
                        int n = start;
                        start = this.cursor;
                        InlineCollectionNode n2 = new InlineCollectionNode(this.expr, n, start, this.fields);
                        this.captureToEOT();
                        this.lastNode = new Union(this.expr, start + 1, this.cursor, this.fields, n2);
                        return this.lastNode;
                    }
                    this.lastNode = new InlineCollectionNode(this.expr, start, this.cursor, this.fields);
                    return this.lastNode;
                }
            }
            ++this.cursor;
        }
        if (start == this.cursor) {
            return null;
        }
        return this.createPropertyToken(start, this.cursor);
    }

    protected ASTNode handleUnion(ASTNode node) {
        if (this.cursor < this.length) {
            this.skipWhitespace();
            if (this.expr[this.cursor] == '.') {
                int union = this.cursor + 1;
                this.captureToEOT();
                this.lastNode = new Union(this.expr, union, this.cursor, this.fields, node);
                return this.lastNode;
            }
        }
        this.lastNode = node;
        return this.lastNode;
    }

    private ASTNode createToken(char[] expr, int start, int end, int fields) {
        ASTNode tk = new ASTNode(expr, start, end, fields);
        this.lastWasIdentifier = tk.isIdentifier();
        this.lastNode = tk;
        return this.lastNode;
    }

    private char[] subArray(int start, int end) {
        char[] newA = new char[end - start];
        System.arraycopy(this.expr, start, newA, 0, newA.length);
        return newA;
    }

    /*
     * Enabled aggressive block sorting
     */
    private ASTNode createPropertyToken(int start, int end) {
        block7: {
            this.lastWasIdentifier = true;
            if (parserContext != null && parserContext.get() != null && parserContext.get().hasImports()) {
                char[] _subset = ParseTools.subset(this.expr, start, this.cursor - start);
                int offset = ArrayTools.findFirst('.', _subset);
                if (offset != -1) {
                    String iStr = new String(_subset, 0, offset);
                    if ("this".equals(iStr)) {
                        this.lastNode = new ThisValDeepPropertyNode(ParseTools.subset(_subset, offset + 1, _subset.length - offset - 1), this.fields);
                        return this.lastNode;
                    }
                    if (this.getParserContext().hasImport(iStr)) {
                        this.lastNode = new LiteralDeepPropertyNode(ParseTools.subset(_subset, offset + 1, _subset.length - offset - 1), this.fields, this.getParserContext().getImport(iStr));
                        return this.lastNode;
                    }
                    break block7;
                } else {
                    String iStr = new String(_subset);
                    if (this.getParserContext().hasImport(iStr)) {
                        this.lastNode = new LiteralNode(this.getParserContext().getImport(iStr), Class.class);
                        return this.lastNode;
                    }
                    ASTNode node = new ASTNode(_subset, 0, _subset.length, this.fields);
                    this.lastWasIdentifier = node.isIdentifier();
                    this.lastNode = node;
                    return this.lastNode;
                }
            }
            if ((this.fields & 0x400) != 0) {
                this.lastNode = new ASTNode(this.expr, start, end, this.fields);
                return this.lastNode;
            }
        }
        this.lastNode = new PropertyASTNode(this.expr, start, end, this.fields);
        return this.lastNode;
    }

    private ASTNode createBlockToken(int condStart, int condEnd, int blockStart, int blockEnd) {
        this.lastWasIdentifier = false;
        ++this.cursor;
        if (!this.isStatementManuallyTerminated()) {
            this.splitAccumulator.add(new EndOfStatement());
        }
        if (this.isFlag(262144)) {
            return new IfNode(this.subArray(condStart, condEnd), this.subArray(blockStart, blockEnd), this.fields);
        }
        if (this.isFlag(524288)) {
            return new ForEachNode(this.subArray(condStart, condEnd), this.subArray(blockStart, blockEnd), this.fields);
        }
        return new WithNode(this.subArray(condStart, condEnd), this.subArray(blockStart, blockEnd), this.fields);
    }

    private ASTNode captureCodeBlock() {
        boolean cond = true;
        ASTNode first = null;
        ASTNode tk = null;
        if (this.isFlag(262144)) {
            do {
                if (tk != null) {
                    this.skipToNextTokenJunction();
                    this.skipWhitespace();
                    boolean bl = cond = this.expr[this.cursor] != '{' && this.expr[this.cursor] == 'i' && this.expr[++this.cursor] == 'f' && (Character.isWhitespace(this.expr[++this.cursor]) || this.expr[this.cursor] == '(');
                }
                if (((IfNode)(tk = this._captureBlock(tk, this.expr, cond))).getElseBlock() != null) {
                    ++this.cursor;
                    return first;
                }
                if (first == null) {
                    first = tk;
                }
                if (this.cursor >= this.length || this.expr[this.cursor] == ';') continue;
                ++this.cursor;
            } while (this.blockContinues());
        } else if (this.isFlag(524288) || this.isFlag(0x100000)) {
            this.skipToNextTokenJunction();
            if (this.debugSymbols) {
                this.skipWhitespaceWithLineAccounting();
            } else {
                this.skipWhitespace();
            }
            return this._captureBlock(null, this.expr, true);
        }
        return first;
    }

    private ASTNode _captureBlock(ASTNode node, char[] expr, boolean cond) {
        int blockEnd;
        int blockStart;
        this.skipWhitespace();
        int startCond = 0;
        int endCond = 0;
        if (cond) {
            if (this.debugSymbols) {
                startCond = this.cursor;
                int[] cap = ParseTools.balancedCaptureWithLineAccounting(expr, startCond, '(');
                this.cursor = cap[0];
                endCond = this.cursor++;
                ++startCond;
                this.line = this.getParserContext().getLineCount();
                this.line += cap[1];
                this.getParserContext().setLineCount(this.line);
            } else {
                startCond = this.cursor;
                this.cursor = ParseTools.balancedCapture(expr, startCond, '(');
                endCond = this.cursor++;
                ++startCond;
            }
        }
        this.skipWhitespace();
        if (this.cursor >= this.length) {
            throw new CompileException("unbalanced braces", expr, this.cursor);
        }
        if (expr[this.cursor] == '{') {
            blockStart = this.cursor;
            if (this.debugSymbols) {
                int[] cap = ParseTools.balancedCaptureWithLineAccounting(expr, this.cursor, '{');
                if (cap[0] == -1) {
                    throw new CompileException("unbalanced braces { }", expr, this.cursor);
                }
                blockEnd = this.cursor = cap[0];
                System.out.println(new String(expr, blockStart, blockEnd - blockStart));
                this.line = this.getParserContext().getLineCount();
                this.line += cap[1];
                this.getParserContext().setLineCount(this.line);
            } else {
                blockEnd = this.cursor = ParseTools.balancedCapture(expr, this.cursor, '{');
                if (this.cursor == -1) {
                    throw new CompileException("unbalanced braces { }", expr, this.cursor);
                }
            }
        } else {
            blockStart = this.cursor - 1;
            this.captureToEOLorOF();
            blockEnd = this.cursor + 1;
        }
        if (this.isFlag(262144)) {
            IfNode ifNode = (IfNode)node;
            if (node != null) {
                if (!cond) {
                    return ifNode.setElseBlock(this.subArray(this.trimRight(blockStart + 1), this.trimLeft(blockEnd - 1)));
                }
                return ifNode.setElseIf((IfNode)this.createBlockToken(startCond, endCond, this.trimRight(blockStart + 1), this.trimLeft(blockEnd)));
            }
            return this.createBlockToken(startCond, endCond, blockStart + 1, blockEnd);
        }
        return this.createBlockToken(startCond, endCond, this.trimRight(blockStart + 1), this.trimLeft(blockEnd));
    }

    protected boolean blockContinues() {
        if (this.cursor + 4 < this.length) {
            if (this.expr[this.cursor] != ';') {
                --this.cursor;
            }
            this.skipWhitespace();
            return this.expr[this.cursor] == 'e' && this.expr[this.cursor + 1] == 'l' && this.expr[this.cursor + 2] == 's' && this.expr[this.cursor + 3] == 'e' && (Character.isWhitespace(this.expr[this.cursor + 4]) || this.expr[this.cursor + 4] == '{');
        }
        return false;
    }

    protected boolean tokenContinues() {
        if (this.cursor >= this.length) {
            return false;
        }
        if (this.expr[this.cursor] == '.') {
            return true;
        }
        if (Character.isWhitespace(this.expr[this.cursor])) {
            int markCurrent = this.cursor;
            this.skipWhitespace();
            if (this.cursor < this.length && this.expr[this.cursor] == '.') {
                return true;
            }
            this.cursor = markCurrent;
        }
        return false;
    }

    protected void captureToEOS() {
        while (this.cursor < this.length && this.expr[this.cursor] != ';') {
            ++this.cursor;
        }
    }

    protected void captureToEOLorOF() {
        while (this.cursor < this.length && this.expr[this.cursor] != '\n' && this.expr[this.cursor] != '\r' && this.expr[this.cursor] != ';') {
            ++this.cursor;
        }
    }

    protected void captureToEOT() {
        this.skipWhitespace();
        block5: while (++this.cursor < this.length) {
            switch (this.expr[this.cursor]) {
                case '(': 
                case '[': 
                case '{': {
                    this.cursor = ParseTools.balancedCapture(this.expr, this.cursor, this.expr[this.cursor]);
                    if (this.cursor != -1) continue block5;
                    throw new CompileException("unbalanced braces", this.expr, this.cursor);
                }
                case '&': 
                case ';': 
                case '=': 
                case '|': {
                    return;
                }
                case '.': {
                    this.skipWhitespace();
                    continue block5;
                }
            }
            if (!Character.isWhitespace(this.expr[this.cursor])) continue;
            this.skipWhitespace();
            if (this.expr[this.cursor] == '.') {
                if (this.cursor < this.length) {
                    ++this.cursor;
                }
                this.skipWhitespace();
                continue;
            }
            this.trimWhitespace();
            return;
        }
    }

    protected int trimLeft(int pos) {
        while (pos > 0 && Character.isWhitespace(this.expr[pos - 1])) {
            --pos;
        }
        return pos;
    }

    protected int trimRight(int pos) {
        while (pos < this.length && Character.isWhitespace(this.expr[pos])) {
            ++pos;
        }
        return pos;
    }

    protected void skipWhitespace() {
        while (this.cursor < this.length && Character.isWhitespace(this.expr[this.cursor])) {
            ++this.cursor;
        }
    }

    protected void skipWhitespaceWithLineAccounting() {
        block4: while (this.cursor < this.length && Character.isWhitespace(this.expr[this.cursor])) {
            switch (this.expr[this.cursor]) {
                case '\r': {
                    ++this.cursor;
                    continue block4;
                }
                case '\n': {
                    ++this.cursor;
                    ++this.line;
                    continue block4;
                }
            }
            ++this.cursor;
        }
    }

    protected void skipToNextTokenJunction() {
        while (this.cursor < this.length) {
            switch (this.expr[this.cursor]) {
                case '(': 
                case '{': {
                    return;
                }
            }
            if (Character.isWhitespace(this.expr[this.cursor])) {
                return;
            }
            ++this.cursor;
        }
    }

    protected void trimWhitespace() {
        while (this.cursor > 0 && Character.isWhitespace(this.expr[this.cursor - 1])) {
            --this.cursor;
        }
    }

    protected ASTNode captureTokenToEOS() {
        int start = this.cursor;
        this.captureToEOS();
        this.lastNode = new ASTNode(this.expr, start, this.cursor, 0);
        return this.lastNode;
    }

    protected void setExpression(String expression) {
        if (expression != null && !"".equals(expression)) {
            if (!EX_PRECACHE.containsKey(expression)) {
                this.expr = expression.toCharArray();
                this.length = this.expr.length;
                while (this.length != 0 && Character.isWhitespace(this.expr[this.length - 1])) {
                    --this.length;
                }
                char[] e = new char[this.length];
                System.arraycopy(this.expr, 0, e, 0, this.length);
                EX_PRECACHE.put(expression, e);
            } else {
                this.expr = EX_PRECACHE.get(expression);
                this.length = this.expr.length;
            }
        }
    }

    protected void setExpression(char[] expression) {
        this.expr = expression;
        this.length = expression.length;
        while (this.length != 0 && Character.isWhitespace(this.expr[this.length - 1])) {
            --this.length;
        }
    }

    private boolean isFlag(int bit) {
        return (this.fields & bit) != 0;
    }

    public static boolean isReservedWord(String name) {
        return LITERALS.containsKey(name) || OPERATORS.containsKey(name);
    }

    protected char lookBehind(int range) {
        if (this.cursor - range <= 0) {
            return '\u0000';
        }
        return this.expr[this.cursor - range];
    }

    protected char lookAhead(int range) {
        if (this.cursor + range >= this.length) {
            return '\u0000';
        }
        return this.expr[this.cursor + range];
    }

    protected boolean isStatementManuallyTerminated() {
        int c;
        for (c = this.cursor; c < this.length && Character.isWhitespace(this.expr[c]); ++c) {
        }
        return c < this.length && this.expr[c] == ';';
    }

    protected boolean isRemain(int range) {
        return this.cursor + range < this.length;
    }

    protected boolean isAt(char c, int range) {
        return this.lookAhead(range) == c;
    }

    protected ParserContext getParserContext() {
        if (parserContext == null || parserContext.get() == null) {
            this.newContext();
        }
        return parserContext.get();
    }

    public static ParserContext getCurrentThreadParserContext() {
        return AbstractParser.contextControl(3, null, null);
    }

    protected void newContext() {
        AbstractParser.contextControl(0, new ParserContext(), this);
    }

    protected void newContext(ParserContext pCtx) {
        AbstractParser.contextControl(0, pCtx, this);
    }

    protected void removeContext() {
        AbstractParser.contextControl(1, null, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ParserContext contextControl(int operation, ParserContext pCtx, AbstractParser parser) {
        Runtime runtime = Runtime.getRuntime();
        synchronized (runtime) {
            if (parserContext == null) {
                parserContext = new ThreadLocal();
            }
            switch (operation) {
                case 0: {
                    pCtx.setRootParser(parser);
                    parserContext.set(pCtx);
                    return null;
                }
                case 1: {
                    parserContext.set(null);
                    return null;
                }
                case 3: {
                    if (parserContext.get() == null) {
                        parserContext.set(new ParserContext(parser));
                    }
                }
                case 2: {
                    return parserContext.get();
                }
            }
        }
        return null;
    }

    public boolean isDebugSymbols() {
        return this.debugSymbols;
    }

    public void setDebugSymbols(boolean debugSymbols) {
        this.debugSymbols = debugSymbols;
    }

    protected static String getCurrentSourceFileName() {
        if (parserContext != null && parserContext.get() != null) {
            return parserContext.get().getSourceFile();
        }
        return null;
    }

    protected void addFatalError(String message) {
        this.getParserContext().addError(new ErrorDetail(this.getParserContext().getLineCount(), this.cursor - this.getParserContext().getLineOffset(), true, message));
    }

    protected void addFatalError(String message, int row, int cols) {
        this.getParserContext().addError(new ErrorDetail(row, cols, true, message));
    }

    protected void addWarning(String message) {
        this.getParserContext().addError(new ErrorDetail(message, false));
    }

    public static void setLanguageLevel(int level) {
        OPERATORS.clear();
        AbstractParser._loadLanguageFeaturesByLevel(level);
    }

    private static void _loadLanguageFeaturesByLevel(int languageLevel) {
        switch (languageLevel) {
            case 5: {
                OPERATORS.put("if", 38);
                OPERATORS.put("else", 39);
                OPERATORS.put("?", 28);
                OPERATORS.put("switch", 42);
            }
            case 4: {
                OPERATORS.put("=", 30);
                OPERATORS.put("var", 98);
                OPERATORS.put("+=", 52);
                OPERATORS.put("-=", 53);
            }
            case 3: {
                OPERATORS.put("foreach", 37);
                OPERATORS.put("while", 40);
                OPERATORS.put("for", 41);
                OPERATORS.put("do", 43);
            }
            case 2: {
                OPERATORS.put("return", 99);
                OPERATORS.put(";", 36);
            }
            case 1: {
                OPERATORS.put("+", 0);
                OPERATORS.put("-", 1);
                OPERATORS.put("*", 2);
                OPERATORS.put("**", 9);
                OPERATORS.put("/", 3);
                OPERATORS.put("%", 4);
                OPERATORS.put("==", 10);
                OPERATORS.put("!=", 11);
                OPERATORS.put(">", 6);
                OPERATORS.put(">=", 8);
                OPERATORS.put("<", 5);
                OPERATORS.put("<=", 7);
                OPERATORS.put("&&", 12);
                OPERATORS.put("and", 12);
                OPERATORS.put("||", 13);
                OPERATORS.put("or", 14);
                OPERATORS.put("~=", 15);
                OPERATORS.put("instanceof", 16);
                OPERATORS.put("is", 16);
                OPERATORS.put("contains", 17);
                OPERATORS.put("soundslike", 19);
                OPERATORS.put("strsim", 20);
                OPERATORS.put("convertable_to", 35);
                OPERATORS.put("#", 18);
                OPERATORS.put("&", 21);
                OPERATORS.put("|", 22);
                OPERATORS.put("^", 23);
                OPERATORS.put("<<", 25);
                OPERATORS.put("<<<", 27);
                OPERATORS.put(">>", 24);
                OPERATORS.put(">>>", 26);
                OPERATORS.put("new", 33);
                OPERATORS.put("in", 34);
                OPERATORS.put("with", 44);
                OPERATORS.put("assert", 97);
                OPERATORS.put("import", 96);
                OPERATORS.put("import_static", 95);
                OPERATORS.put("++", 50);
                OPERATORS.put("--", 51);
            }
            case 0: {
                OPERATORS.put(":", 29);
            }
        }
    }

    public static void resetParserContext() {
        AbstractParser.contextControl(1, null, null);
    }

    static {
        LITERALS = new HashMap<String, Object>(35, 0.4f);
        OPERATORS = new HashMap<String, Integer>(50, 0.4f);
        AbstractParser.configureFactory();
        LITERALS.put("true", Boolean.TRUE);
        LITERALS.put("false", Boolean.FALSE);
        LITERALS.put("null", null);
        LITERALS.put("nil", null);
        LITERALS.put("empty", BlankLiteral.INSTANCE);
        LITERALS.put("this", ThisLiteral.class);
        LITERALS.put("System", System.class);
        LITERALS.put("String", String.class);
        LITERALS.put("Integer", Integer.class);
        LITERALS.put("int", Integer.class);
        LITERALS.put("Long", Long.class);
        LITERALS.put("long", Long.class);
        LITERALS.put("Boolean", Boolean.class);
        LITERALS.put("boolean", Boolean.class);
        LITERALS.put("Short", Short.class);
        LITERALS.put("short", Short.class);
        LITERALS.put("Character", Character.class);
        LITERALS.put("char", Character.class);
        LITERALS.put("Double", Double.class);
        LITERALS.put("double", Double.TYPE);
        LITERALS.put("Float", Float.class);
        LITERALS.put("float", Float.TYPE);
        LITERALS.put("Math", Math.class);
        LITERALS.put("Void", Void.class);
        LITERALS.put("Object", Object.class);
        LITERALS.put("Class", Class.class);
        LITERALS.put("ClassLoader", ClassLoader.class);
        LITERALS.put("Runtime", Runtime.class);
        LITERALS.put("Thread", Thread.class);
        LITERALS.put("Compiler", Compiler.class);
        LITERALS.put("StringBuffer", StringBuffer.class);
        LITERALS.put("ThreadLocal", ThreadLocal.class);
        LITERALS.put("SecurityManager", SecurityManager.class);
        LITERALS.put("StrictMath", StrictMath.class);
        LITERALS.put("Array", Array.class);
        if ((double)Float.parseFloat(System.getProperty("java.version").substring(0, 2)) >= 1.5) {
            try {
                LITERALS.put("StringBuilder", Thread.currentThread().getContextClassLoader().loadClass("java.lang.StringBuilder"));
            }
            catch (Exception e) {
                throw new RuntimeException("cannot resolve a built-in literal", e);
            }
        }
        AbstractParser._loadLanguageFeaturesByLevel(5);
    }
}

