/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.apache.jackrabbit.core.ItemLifeCycleListener;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.apache.jackrabbit.core.version.InternalVersionHistory;
import org.apache.jackrabbit.core.version.VersionImpl;
import org.apache.jackrabbit.core.version.VersionIteratorImpl;
import org.apache.jackrabbit.name.IllegalNameException;
import org.apache.jackrabbit.name.NameFormat;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.NoPrefixDeclaredException;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.name.UnknownPrefixException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionHistoryImpl
extends NodeImpl
implements VersionHistory {
    private static Logger log = LoggerFactory.getLogger((Class)VersionHistoryImpl.class);

    public VersionHistoryImpl(ItemManager itemMgr, SessionImpl session, NodeId id, NodeState state, NodeDefinition definition, ItemLifeCycleListener[] listeners) {
        super(itemMgr, session, id, state, definition, listeners);
    }

    protected InternalVersionHistory getInternalVersionHistory() throws RepositoryException {
        InternalVersionHistory history = this.session.getVersionManager().getVersionHistory((NodeId)this.id);
        if (history == null) {
            throw new InvalidItemStateException(this.id + ": the item does not exist anymore");
        }
        return history;
    }

    public Version getRootVersion() throws RepositoryException {
        return (Version)this.session.getNodeById(this.getInternalVersionHistory().getRootVersion().getId());
    }

    public VersionIterator getAllVersions() throws RepositoryException {
        return new VersionIteratorImpl(this.session, this.getInternalVersionHistory().getRootVersion());
    }

    public Version getVersion(String versionName) throws VersionException, RepositoryException {
        try {
            QName name = NameFormat.parse((String)versionName, (NamespaceResolver)this.session.getNamespaceResolver());
            InternalVersion v = this.getInternalVersionHistory().getVersion(name);
            if (v == null) {
                throw new VersionException("No version with name '" + versionName + "' exists in this version history.");
            }
            return (Version)this.session.getNodeById(v.getId());
        }
        catch (IllegalNameException e) {
            throw new VersionException((Throwable)e);
        }
        catch (UnknownPrefixException e) {
            throw new VersionException((Throwable)e);
        }
    }

    public Version getVersionByLabel(String label) throws RepositoryException {
        try {
            QName qLabel = NameFormat.parse((String)label, (NamespaceResolver)this.session.getNamespaceResolver());
            InternalVersion v = this.getInternalVersionHistory().getVersionByLabel(qLabel);
            if (v == null) {
                throw new VersionException("No version with label '" + label + "' exists in this version history.");
            }
            return (Version)this.session.getNodeById(v.getId());
        }
        catch (IllegalNameException e) {
            throw new VersionException((Throwable)e);
        }
        catch (UnknownPrefixException e) {
            throw new VersionException((Throwable)e);
        }
    }

    public void addVersionLabel(String versionName, String label, boolean move) throws VersionException, RepositoryException {
        try {
            this.session.getVersionManager().setVersionLabel(this, NameFormat.parse((String)versionName, (NamespaceResolver)this.session.getNamespaceResolver()), NameFormat.parse((String)label, (NamespaceResolver)this.session.getNamespaceResolver()), move);
        }
        catch (IllegalNameException e) {
            throw new VersionException((Throwable)e);
        }
        catch (UnknownPrefixException e) {
            throw new VersionException((Throwable)e);
        }
    }

    public void removeVersionLabel(String label) throws RepositoryException {
        try {
            Version existing = this.session.getVersionManager().setVersionLabel(this, null, NameFormat.parse((String)label, (NamespaceResolver)this.session.getNamespaceResolver()), true);
            if (existing == null) {
                throw new VersionException("No version with label '" + label + "' exists in this version history.");
            }
        }
        catch (IllegalNameException e) {
            throw new VersionException((Throwable)e);
        }
        catch (UnknownPrefixException e) {
            throw new VersionException((Throwable)e);
        }
    }

    public String[] getVersionLabels() throws RepositoryException {
        try {
            QName[] labels = this.getInternalVersionHistory().getVersionLabels();
            String[] ret = new String[labels.length];
            for (int i = 0; i < labels.length; ++i) {
                ret[i] = NameFormat.format((QName)labels[i], (NamespaceResolver)this.session.getNamespaceResolver());
            }
            return ret;
        }
        catch (NoPrefixDeclaredException e) {
            throw new IllegalArgumentException("Unable to resolve label name: " + e.toString());
        }
    }

    public String[] getVersionLabels(Version version) throws VersionException, RepositoryException {
        this.checkOwnVersion(version);
        try {
            QName[] labels = ((VersionImpl)version).getInternalVersion().getLabels();
            String[] ret = new String[labels.length];
            for (int i = 0; i < labels.length; ++i) {
                ret[i] = NameFormat.format((QName)labels[i], (NamespaceResolver)this.session.getNamespaceResolver());
            }
            return ret;
        }
        catch (NoPrefixDeclaredException e) {
            throw new IllegalArgumentException("Unable to resolve label name: " + e.toString());
        }
    }

    public boolean hasVersionLabel(String label) throws RepositoryException {
        try {
            QName qLabel = NameFormat.parse((String)label, (NamespaceResolver)this.session.getNamespaceResolver());
            return this.getInternalVersionHistory().getVersionByLabel(qLabel) != null;
        }
        catch (IllegalNameException e) {
            throw new IllegalArgumentException("Unable to resolve label: " + (Object)((Object)e));
        }
        catch (UnknownPrefixException e) {
            throw new IllegalArgumentException("Unable to resolve label: " + (Object)((Object)e));
        }
    }

    public boolean hasVersionLabel(Version version, String label) throws VersionException, RepositoryException {
        this.checkOwnVersion(version);
        try {
            QName qLabel = NameFormat.parse((String)label, (NamespaceResolver)this.session.getNamespaceResolver());
            return ((VersionImpl)version).getInternalVersion().hasLabel(qLabel);
        }
        catch (IllegalNameException e) {
            throw new VersionException((Throwable)e);
        }
        catch (UnknownPrefixException e) {
            throw new VersionException((Throwable)e);
        }
    }

    public void removeVersion(String versionName) throws UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        try {
            this.session.getVersionManager().removeVersion(this, NameFormat.parse((String)versionName, (NamespaceResolver)this.session.getNamespaceResolver()));
        }
        catch (IllegalNameException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (UnknownPrefixException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public boolean isSame(Item otherItem) {
        if (otherItem instanceof VersionHistoryImpl) {
            try {
                InternalVersionHistory other = ((VersionHistoryImpl)otherItem).getInternalVersionHistory();
                return other.getId().equals(this.getInternalVersionHistory().getId());
            }
            catch (RepositoryException e) {
                log.warn("Unable to retrieve internal version history objects: " + e.getMessage());
                log.debug("Stack dump:", (Throwable)e);
            }
        }
        return false;
    }

    public String getVersionableUUID() throws RepositoryException {
        return this.getInternalVersionHistory().getVersionableUUID().toString();
    }

    private void checkOwnVersion(Version version) throws VersionException, RepositoryException {
        if (!version.getParent().isSame((Item)this)) {
            throw new VersionException("Specified version not contained in this history.");
        }
    }

    public void update(String srcWorkspaceName) throws ConstraintViolationException {
        String msg = "update operation not allowed on a version history node: " + this.safeGetJCRPath();
        log.debug(msg);
        throw new ConstraintViolationException(msg);
    }

    public NodeIterator merge(String srcWorkspace, boolean bestEffort) throws ConstraintViolationException {
        String msg = "merge operation not allowed on a version history node: " + this.safeGetJCRPath();
        log.debug(msg);
        throw new ConstraintViolationException(msg);
    }
}

