/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.ReentrantWriterPreferenceReadWriteLock;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.LocalItemStateManager;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.apache.jackrabbit.core.version.InternalVersionHistory;
import org.apache.jackrabbit.core.version.InternalVersionHistoryImpl;
import org.apache.jackrabbit.core.version.InternalVersionImpl;
import org.apache.jackrabbit.core.version.InternalVersionItem;
import org.apache.jackrabbit.core.version.NodeStateEx;
import org.apache.jackrabbit.core.version.VersionManager;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.uuid.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractVersionManager
implements VersionManager {
    private static Logger log = LoggerFactory.getLogger((Class)AbstractVersionManager.class);
    protected LocalItemStateManager stateMgr;
    protected NodeStateEx historyRoot;
    private final ReadWriteLock rwLock = new ReentrantWriterPreferenceReadWriteLock(){

        protected boolean allowReader() {
            return this.activeWriter_ == null || this.activeWriter_ == Thread.currentThread();
        }
    };

    AbstractVersionManager() {
    }

    public InternalVersion getVersion(NodeId id) throws RepositoryException {
        InternalVersion v = (InternalVersion)this.getItem(id);
        if (v == null) {
            log.warn("Versioning item not found: " + id);
        }
        return v;
    }

    public InternalVersionHistory getVersionHistory(NodeId id) throws RepositoryException {
        return (InternalVersionHistory)this.getItem(id);
    }

    public boolean hasVersionHistory(NodeId id) {
        return this.hasItem(id);
    }

    public boolean hasVersion(NodeId id) {
        return this.hasItem(id);
    }

    protected void acquireWriteLock() {
        while (true) {
            try {
                this.rwLock.writeLock().acquire();
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    protected void releaseWriteLock() {
        this.rwLock.writeLock().release();
    }

    protected void acquireReadLock() {
        while (true) {
            try {
                this.rwLock.readLock().acquire();
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    protected void releaseReadLock() {
        this.rwLock.readLock().release();
    }

    private WriteOperation startWriteOperation() throws RepositoryException {
        boolean success = false;
        this.acquireWriteLock();
        try {
            this.stateMgr.edit();
            success = true;
            WriteOperation writeOperation = new WriteOperation();
            return writeOperation;
        }
        catch (IllegalStateException e) {
            throw new RepositoryException("Unable to start edit operation.", (Throwable)e);
        }
        finally {
            if (!success) {
                this.releaseWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionHistory getVersionHistory(Session session, NodeState node) throws RepositoryException {
        this.acquireReadLock();
        try {
            NodeId vhId = this.getVersionHistoryId(node);
            if (vhId == null) {
                VersionHistory versionHistory = null;
                return versionHistory;
            }
            VersionHistory versionHistory = (VersionHistory)((SessionImpl)session).getNodeById(vhId);
            return versionHistory;
        }
        finally {
            this.releaseReadLock();
        }
    }

    protected abstract InternalVersionItem getItem(NodeId var1) throws RepositoryException;

    protected abstract boolean hasItem(NodeId var1);

    protected abstract List getItemReferences(InternalVersionItem var1);

    InternalVersionHistory createVersionHistory(NodeState node) throws RepositoryException {
        WriteOperation operation = this.startWriteOperation();
        try {
            QName name;
            String uuid = node.getNodeId().getUUID().toString();
            NodeStateEx root = this.historyRoot;
            for (int i = 0; i < 3; ++i) {
                name = new QName("", uuid.substring(i * 2, i * 2 + 2));
                if (!root.hasNode(name)) {
                    root.addNode(name, QName.REP_VERSIONSTORAGE, null, false);
                    root.store();
                }
                root = root.getNode(name, 1);
            }
            QName historyNodeName = new QName("", uuid);
            if (root.hasNode(historyNodeName)) {
                name = null;
                return name;
            }
            InternalVersionHistoryImpl hist = InternalVersionHistoryImpl.create(this, root, new NodeId(UUID.randomUUID()), historyNodeName, node);
            operation.save();
            log.info("Created new version history " + hist.getId() + " for " + node + ".");
            InternalVersionHistoryImpl internalVersionHistoryImpl = hist;
            return internalVersionHistoryImpl;
        }
        catch (ItemStateException e) {
            throw new RepositoryException((Throwable)((Object)e));
        }
        finally {
            operation.close();
        }
    }

    private NodeId getVersionHistoryId(NodeState node) throws RepositoryException {
        String uuid = node.getNodeId().getUUID().toString();
        NodeStateEx n = this.historyRoot;
        for (int i = 0; i < 3; ++i) {
            QName name = new QName("", uuid.substring(i * 2, i * 2 + 2));
            if (!n.hasNode(name)) {
                return null;
            }
            n = n.getNode(name, 1);
        }
        QName historyNodeName = new QName("", uuid);
        if (!n.hasNode(historyNodeName)) {
            return null;
        }
        return n.getNode(historyNodeName, 1).getNodeId();
    }

    protected InternalVersion checkin(InternalVersionHistoryImpl history, NodeImpl node) throws RepositoryException {
        WriteOperation operation = this.startWriteOperation();
        try {
            String versionName = this.calculateCheckinVersionName(history, node);
            InternalVersionImpl v = history.checkin(new QName("", versionName), node);
            operation.save();
            InternalVersionImpl internalVersionImpl = v;
            return internalVersionImpl;
        }
        catch (ItemStateException e) {
            throw new RepositoryException((Throwable)((Object)e));
        }
        finally {
            operation.close();
        }
    }

    protected String calculateCheckinVersionName(InternalVersionHistoryImpl history, NodeImpl node) throws RepositoryException {
        Value[] values = node.getProperty(QName.JCR_PREDECESSORS).getValues();
        InternalVersion best = null;
        for (int i = 0; i < values.length; ++i) {
            InternalVersion pred = history.getVersion(NodeId.valueOf(values[i].getString()));
            if (best != null && pred.getName().getLocalName().length() >= best.getName().getLocalName().length()) continue;
            best = pred;
        }
        String versionName = best.getName().getLocalName();
        int pos = versionName.lastIndexOf(46);
        if (pos > 0) {
            String newVersionName = versionName.substring(0, pos + 1) + (Integer.parseInt(versionName.substring(pos + 1)) + 1);
            while (history.hasVersion(new QName("", newVersionName))) {
                newVersionName = versionName = versionName + ".0";
            }
            return newVersionName;
        }
        return String.valueOf(best.getSuccessors().length + 1) + ".0";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeVersion(InternalVersionHistoryImpl history, QName name) throws VersionException, RepositoryException {
        WriteOperation operation = this.startWriteOperation();
        try {
            history.removeVersion(name);
            operation.save();
        }
        catch (ItemStateException e) {
            log.error("Error while storing: " + e.toString());
        }
        finally {
            operation.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InternalVersion setVersionLabel(InternalVersionHistoryImpl history, QName version, QName label, boolean move) throws RepositoryException {
        WriteOperation operation = this.startWriteOperation();
        try {
            InternalVersion v = history.setVersionLabel(version, label, move);
            operation.save();
            InternalVersion internalVersion = v;
            return internalVersion;
        }
        catch (ItemStateException e) {
            log.error("Error while storing: " + e.toString());
            InternalVersion internalVersion = null;
            return internalVersion;
        }
        finally {
            operation.close();
        }
    }

    protected void versionCreated(InternalVersion version) {
    }

    protected void versionDestroyed(InternalVersion version) {
    }

    protected void itemDiscarded(InternalVersionItem item) {
    }

    private class WriteOperation {
        private boolean success = false;

        private WriteOperation() {
        }

        public void save() throws ItemStateException, RepositoryException {
            AbstractVersionManager.this.stateMgr.update();
            this.success = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            try {
                if (!this.success) {
                    AbstractVersionManager.this.stateMgr.cancel();
                }
            }
            finally {
                AbstractVersionManager.this.releaseWriteLock();
            }
        }
    }
}

