/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.core.nodetype.InvalidConstraintException;
import org.apache.jackrabbit.core.nodetype.ValueConstraint;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.name.IllegalNameException;
import org.apache.jackrabbit.name.NameFormat;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.NoPrefixDeclaredException;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.name.UnknownPrefixException;

class ReferenceConstraint
extends ValueConstraint {
    final QName ntName;

    ReferenceConstraint(String definition, NamespaceResolver nsResolver) throws InvalidConstraintException {
        super(definition);
        try {
            this.ntName = NameFormat.parse((String)definition, (NamespaceResolver)nsResolver);
        }
        catch (IllegalNameException ine) {
            String msg = "invalid node type name specified as value constraint: " + definition;
            log.debug(msg);
            throw new InvalidConstraintException(msg, ine);
        }
        catch (UnknownPrefixException upe) {
            String msg = "invalid node type name specified as value constraint: " + definition;
            log.debug(msg);
            throw new InvalidConstraintException(msg, upe);
        }
    }

    public String getDefinition(NamespaceResolver nsResolver) {
        try {
            return NameFormat.format((QName)this.ntName, (NamespaceResolver)nsResolver);
        }
        catch (NoPrefixDeclaredException npde) {
            return this.definition;
        }
    }

    QName getNodeTypeName() {
        return this.ntName;
    }

    void check(InternalValue value) throws ConstraintViolationException, RepositoryException {
        if (value == null) {
            throw new ConstraintViolationException("null value does not satisfy the constraint '" + this.definition + "'");
        }
        switch (value.getType()) {
            case 9: {
                log.info("validation of REFERENCE constraint is not yet implemented");
                return;
            }
        }
        String msg = "REFERENCE constraint can not be applied to value of type: " + PropertyType.nameFromValue((int)value.getType());
        log.debug(msg);
        throw new RepositoryException(msg);
    }
}

