/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.cluster;

import java.io.File;
import java.io.IOException;
import org.apache.jackrabbit.core.cluster.FileRecord;
import org.apache.jackrabbit.core.cluster.FileRecordLog;

class FileRecordCursor {
    private File[] logFiles;
    private long nextRevision;
    private long lastRevision;
    private FileRecordLog recordLog;
    private FileRecord record;

    public FileRecordCursor(File[] logFiles, long firstRevision, long lastRevision) {
        this.logFiles = logFiles;
        this.nextRevision = firstRevision;
        this.lastRevision = lastRevision;
    }

    public boolean hasNext() {
        return this.nextRevision < this.lastRevision;
    }

    public FileRecord next() throws IOException {
        if (!this.hasNext()) {
            String msg = "No next revision.";
            throw new IllegalStateException(msg);
        }
        if (this.record != null) {
            this.record.skip();
            this.record = null;
        }
        if (this.recordLog != null && !this.recordLog.contains(this.nextRevision)) {
            this.recordLog.close();
            this.recordLog = null;
        }
        if (this.recordLog == null) {
            this.recordLog = this.getRecordLog(this.nextRevision);
            this.recordLog.seek(this.nextRevision);
        }
        this.record = new FileRecord(this.nextRevision, this.recordLog.getInputStream());
        this.nextRevision = this.record.getNextRevision();
        return this.record;
    }

    private FileRecordLog getRecordLog(long revision) throws IOException {
        for (int i = 0; i < this.logFiles.length; ++i) {
            FileRecordLog recordLog = new FileRecordLog(this.logFiles[i]);
            if (!recordLog.contains(revision)) continue;
            return recordLog;
        }
        String msg = "No log file found containing revision: " + revision;
        throw new IOException(msg);
    }

    public void close() throws IOException {
        if (this.recordLog != null) {
            this.recordLog.close();
        }
    }
}

