/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.cluster;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jackrabbit.core.cluster.FileRecordInput;
import org.apache.jackrabbit.core.cluster.FileRecordOutput;
import org.apache.jackrabbit.name.NamespaceResolver;

class FileRecord {
    static final byte UUID_LITERAL = 76;
    static final byte UUID_INDEX = 73;
    private long revision;
    private DataInputStream in;
    private File file;
    private DataOutputStream out;
    private int length;
    private String creator;
    private int creatorLength;
    private boolean consumed;

    public FileRecord(long revision, InputStream in) throws IOException {
        this.revision = revision;
        this.in = in instanceof DataInputStream ? (DataInputStream)in : new DataInputStream(in);
        this.length = this.in.readInt();
        this.readCreator();
    }

    public FileRecord(String creator, File file) throws IOException {
        this.creator = creator;
        this.file = file;
        this.out = new DataOutputStream(new FileOutputStream(file));
        this.writeCreator();
    }

    public long getRevision() {
        return this.revision;
    }

    public void setRevision(long revision) {
        this.revision = revision;
    }

    public long getNextRevision() {
        return this.revision + (long)this.length + 4L;
    }

    public String getCreator() {
        return this.creator;
    }

    public FileRecordInput getInput(NamespaceResolver resolver) {
        this.consumed = true;
        return new FileRecordInput(this.in, resolver);
    }

    public FileRecordOutput getOutput(NamespaceResolver resolver) {
        return new FileRecordOutput(this, this.out, resolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void append(DataOutputStream out) throws IOException {
        out.writeInt(this.length);
        byte[] buffer = new byte[8192];
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.file));
        try {
            int len;
            while ((len = ((InputStream)in).read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            out.flush();
        }
        finally {
            ((InputStream)in).close();
        }
    }

    void skip() throws IOException {
        if (!this.consumed) {
            long skiplen;
            long skipped;
            for (skiplen = (long)(this.length - this.creatorLength); skiplen > 0L && (skipped = this.in.skip(skiplen)) > 0L; skiplen -= skipped) {
            }
            if (skiplen != 0L) {
                String msg = "Unable to skip remaining bytes.";
                throw new IOException(msg);
            }
        }
    }

    void closed() {
        this.length = (int)this.file.length();
    }

    private void readCreator() throws IOException {
        UTFByteCounter counter = new UTFByteCounter(this.in);
        this.creator = DataInputStream.readUTF(counter);
        this.creatorLength = counter.getBytes();
    }

    private void writeCreator() throws IOException {
        this.out.writeUTF(this.creator);
    }

    static class UTFByteCounter
    implements DataInput {
        private final DataInputStream in;
        private int bytes;

        public UTFByteCounter(DataInputStream in) {
            this.in = in;
        }

        public int getBytes() {
            return this.bytes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int readUnsignedShort() throws IOException {
            try {
                int n = this.in.readUnsignedShort();
                return n;
            }
            finally {
                this.bytes += 2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFully(byte[] b) throws IOException {
            try {
                this.in.readFully(b);
            }
            finally {
                this.bytes += b.length;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFully(byte[] b, int off, int len) throws IOException {
            try {
                this.in.readFully(b, off, len);
            }
            finally {
                this.bytes += b.length;
            }
        }

        public byte readByte() throws IOException {
            throw new IllegalStateException("Unexpected call, deliberately not implemented.");
        }

        public char readChar() throws IOException {
            throw new IllegalStateException("Unexpected call, deliberately not implemented.");
        }

        public double readDouble() throws IOException {
            throw new IllegalStateException("Unexpected call, deliberately not implemented.");
        }

        public float readFloat() throws IOException {
            throw new IllegalStateException("Unexpected call, deliberately not implemented.");
        }

        public int readInt() throws IOException {
            throw new IllegalStateException("Unexpected call, deliberately not implemented.");
        }

        public int readUnsignedByte() throws IOException {
            throw new IllegalStateException("Unexpected call, deliberately not implemented.");
        }

        public long readLong() throws IOException {
            throw new IllegalStateException("Unexpected call, deliberately not implemented.");
        }

        public short readShort() throws IOException {
            throw new IllegalStateException("Unexpected call, deliberately not implemented.");
        }

        public boolean readBoolean() throws IOException {
            throw new IllegalStateException("Unexpected call, deliberately not implemented.");
        }

        public int skipBytes(int n) throws IOException {
            throw new IllegalStateException("Unexpected call, deliberately not implemented.");
        }

        public String readLine() throws IOException {
            throw new IllegalStateException("Unexpected call, deliberately not implemented.");
        }

        public String readUTF() throws IOException {
            throw new IllegalStateException("Unexpected call, deliberately not implemented.");
        }
    }
}

