/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.uuid.UUID;

public class NodeId
extends ItemId {
    static final long serialVersionUID = 7380115476447060008L;
    private final UUID uuid;
    private final int hashCode;

    public NodeId(UUID uuid) {
        if (uuid == null) {
            throw new IllegalArgumentException("uuid can not be null");
        }
        this.uuid = uuid;
        this.hashCode = uuid.hashCode();
    }

    public boolean denotesNode() {
        return true;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public static NodeId valueOf(String s) throws IllegalArgumentException {
        if (s == null) {
            throw new IllegalArgumentException("invalid NodeId literal");
        }
        return new NodeId(new UUID(s));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NodeId) {
            return this.uuid.equals((Object)((NodeId)obj).uuid);
        }
        return false;
    }

    public String toString() {
        return this.uuid.toString();
    }

    public int hashCode() {
        return this.hashCode;
    }
}

