/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.ItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LazyItemIterator
implements NodeIterator,
PropertyIterator {
    private static Logger log = LoggerFactory.getLogger((Class)LazyItemIterator.class);
    private final ItemManager itemMgr;
    private final List idList;
    private int pos;
    private Item next;

    public LazyItemIterator(ItemManager itemMgr, List idList) {
        this.itemMgr = itemMgr;
        this.idList = new ArrayList(idList);
        this.pos = 0;
        this.prefetchNext();
    }

    private void prefetchNext() {
        this.next = null;
        while (this.next == null && this.pos < this.idList.size()) {
            ItemId id = (ItemId)this.idList.get(this.pos);
            try {
                this.next = this.itemMgr.getItem(id);
            }
            catch (ItemNotFoundException e) {
                log.debug("ignoring nonexistent item " + id);
                this.idList.remove(this.pos);
            }
            catch (RepositoryException e) {
                log.error("failed to fetch item " + id + ", skipping...", (Throwable)e);
                this.idList.remove(this.pos);
            }
        }
    }

    public Node nextNode() {
        return (Node)this.next();
    }

    public Property nextProperty() {
        return (Property)this.next();
    }

    public long getPosition() {
        return this.pos;
    }

    public long getSize() {
        return this.idList.size();
    }

    public void skip(long skipNum) {
        if (skipNum < 0L) {
            throw new IllegalArgumentException("skipNum must not be negative");
        }
        if (skipNum == 0L) {
            return;
        }
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        this.next = null;
        while (--skipNum > 0L) {
            ++this.pos;
            if (this.pos >= this.idList.size()) {
                throw new NoSuchElementException();
            }
            ItemId id = (ItemId)this.idList.get(this.pos);
            while (!this.itemMgr.itemExists(id)) {
                log.debug("ignoring nonexistent item " + id);
                this.idList.remove(this.pos);
                if (this.pos >= this.idList.size()) {
                    throw new NoSuchElementException();
                }
                id = (ItemId)this.idList.get(this.pos);
            }
        }
        ++this.pos;
        this.prefetchNext();
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public Object next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        Item item = this.next;
        ++this.pos;
        this.prefetchNext();
        return item;
    }

    public void remove() {
        throw new UnsupportedOperationException("remove");
    }
}

