/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.Map;
import javax.jcr.NamespaceException;
import org.apache.commons.collections.map.LRUMap;
import org.apache.jackrabbit.name.AbstractNamespaceResolver;
import org.apache.jackrabbit.name.IllegalNameException;
import org.apache.jackrabbit.name.NameCache;
import org.apache.jackrabbit.name.NameFormat;
import org.apache.jackrabbit.name.NamespaceListener;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.NoPrefixDeclaredException;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.name.UnknownPrefixException;

class CachingNamespaceResolver
implements NamespaceResolver,
NamespaceListener,
NameCache {
    private final AbstractNamespaceResolver base;
    private final Map qnameToJCRName;
    private final Map jcrNameToQName;

    public CachingNamespaceResolver(AbstractNamespaceResolver base, int cacheSize) {
        this.base = base;
        this.qnameToJCRName = new LRUMap(cacheSize);
        this.jcrNameToQName = new LRUMap(cacheSize);
        this.base.addListener((NamespaceListener)this);
    }

    public String getURI(String prefix) throws NamespaceException {
        return this.base.getURI(prefix);
    }

    public String getPrefix(String uri) throws NamespaceException {
        return this.base.getPrefix(uri);
    }

    public QName getQName(String name) throws IllegalNameException, UnknownPrefixException {
        return NameFormat.parse((String)name, (NamespaceResolver)this);
    }

    public String getJCRName(QName name) throws NoPrefixDeclaredException {
        return NameFormat.format((QName)name, (NamespaceResolver)this);
    }

    public void dispose() {
        this.base.removeListener((NamespaceListener)this);
    }

    public synchronized QName retrieveName(String jcrName) {
        return (QName)this.jcrNameToQName.get(jcrName);
    }

    public synchronized String retrieveName(QName name) {
        return (String)this.qnameToJCRName.get(name);
    }

    public synchronized void cacheName(String jcrName, QName name) {
        this.qnameToJCRName.put(name, jcrName);
        this.jcrNameToQName.put(jcrName, name);
    }

    public synchronized void evictAllNames() {
        this.qnameToJCRName.clear();
        this.jcrNameToQName.clear();
    }

    public void namespaceAdded(String prefix, String uri) {
    }

    public void namespaceRemapped(String oldPrefix, String newPrefix, String uri) {
        this.evictAllNames();
    }

    public void namespaceRemoved(String uri) {
        this.evictAllNames();
    }
}

