/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.resource.ContainerResourceLocator;
import org.milyn.util.ClassUtil;

public class URIResourceLocator
implements ContainerResourceLocator {
    private static final Log logger = LogFactory.getLog(URIResourceLocator.class);
    public static String SCHEME_CLASSPATH = "classpath";
    public static final String BASE_URI_SYSKEY = "org.milyn.resource.baseuri";
    private URI baseURI = URI.create(System.getProperty("org.milyn.resource.baseuri", "./"));

    public InputStream getResource(String configName, String defaultUri) throws IllegalArgumentException, IOException {
        return this.getResource(defaultUri);
    }

    public InputStream getResource(String uri) throws IllegalArgumentException, IOException {
        return this.getResource(this.resolveURI(uri));
    }

    private InputStream getResource(URI uri) throws IllegalArgumentException, IOException {
        String scheme = uri.getScheme();
        InputStream stream = null;
        if (scheme == null || scheme.equals(SCHEME_CLASSPATH)) {
            String path = uri.getPath();
            if (path == null) {
                throw new IllegalArgumentException("Unable to locate resource [" + uri + "].  Resource path not specified in URI.");
            }
            File file = new File(path);
            if (scheme == null && file.exists()) {
                stream = new FileInputStream(file);
            } else {
                if (!uri.isAbsolute()) {
                    path = "/" + path;
                }
                stream = ClassUtil.getResourceAsStream(path, this.getClass());
            }
            if (stream == null) {
                throw new IOException("Failed to access data stream for resource [" + path + "]. No scheme specified. Tried filesystem and classpath.");
            }
        } else {
            URL url = uri.toURL();
            URLConnection connection = url.openConnection();
            stream = connection.getInputStream();
            if (stream == null) {
                throw new IOException("Failed to access data stream for " + uri.getScheme() + " resource [" + uri + "].");
            }
        }
        return stream;
    }

    public URI resolveURI(String uri) {
        URI uriObj;
        if (uri == null || uri.trim().equals("")) {
            throw new IllegalArgumentException("null or empty 'uri' paramater in method call.");
        }
        if (uri.charAt(0) == '\\' || uri.charAt(0) == '/') {
            uri = uri.substring(1);
        }
        if (!(uriObj = URI.create(uri)).isAbsolute()) {
            uriObj = this.baseURI.resolve(uriObj);
        }
        return uriObj;
    }

    public void setBaseURI(URI baseURI) {
        if (baseURI == null) {
            throw new IllegalArgumentException("null 'baseURI' arg in method call.");
        }
        String baseURIString = baseURI.toString();
        char lastChar = baseURIString.charAt(baseURIString.length() - 1);
        this.baseURI = lastChar != '/' && lastChar != '\\' ? URI.create(baseURIString + '/') : baseURI;
    }
}

