/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.io;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public abstract class StreamUtils {
    public static byte[] readStream(InputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("null 'stream' arg in method call.");
        }
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        byte[] byteBuf = new byte[1024];
        int readCount = 0;
        while ((readCount = stream.read(byteBuf)) != -1) {
            bytesOut.write(byteBuf, 0, readCount);
        }
        return bytesOut.toByteArray();
    }

    public static boolean compareCharStreams(InputStream s1, InputStream s2) {
        try {
            StringBuffer s1Buf = StreamUtils.trimLines(s1);
            StringBuffer s2Buf = StreamUtils.trimLines(s2);
            return s1Buf.toString().equals(s2Buf.toString());
        }
        catch (IOException e) {
            return false;
        }
    }

    public static StringBuffer trimLines(InputStream charStream) throws IOException {
        String line;
        StringBuffer stringBuf = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(charStream, "UTF-8"));
        while ((line = reader.readLine()) != null) {
            stringBuf.append(line.trim());
        }
        return stringBuf;
    }
}

