/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.xml;

import com.ibm.wsdl.util.xml.DOMUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.bpel.BpelException;
import org.jbpm.bpel.alarm.AlarmAction;
import org.jbpm.bpel.graph.basic.Empty;
import org.jbpm.bpel.graph.def.Activity;
import org.jbpm.bpel.graph.def.BpelProcessDefinition;
import org.jbpm.bpel.graph.def.CompositeActivity;
import org.jbpm.bpel.graph.def.Import;
import org.jbpm.bpel.graph.def.ImportDefinition;
import org.jbpm.bpel.graph.scope.Catch;
import org.jbpm.bpel.graph.scope.Handler;
import org.jbpm.bpel.graph.scope.OnAlarm;
import org.jbpm.bpel.graph.scope.OnEvent;
import org.jbpm.bpel.graph.scope.Scope;
import org.jbpm.bpel.integration.def.Correlation;
import org.jbpm.bpel.integration.def.CorrelationSetDefinition;
import org.jbpm.bpel.integration.def.Correlations;
import org.jbpm.bpel.integration.def.PartnerLinkDefinition;
import org.jbpm.bpel.integration.def.ReceiveAction;
import org.jbpm.bpel.sublang.def.Expression;
import org.jbpm.bpel.sublang.def.JoinCondition;
import org.jbpm.bpel.sublang.def.Query;
import org.jbpm.bpel.variable.def.ElementType;
import org.jbpm.bpel.variable.def.MessageType;
import org.jbpm.bpel.variable.def.SchemaType;
import org.jbpm.bpel.variable.def.VariableDefinition;
import org.jbpm.bpel.variable.def.VariableType;
import org.jbpm.bpel.wsdl.PartnerLinkType;
import org.jbpm.bpel.wsdl.Property;
import org.jbpm.bpel.wsdl.PropertyAlias;
import org.jbpm.bpel.wsdl.impl.PropertyImpl;
import org.jbpm.bpel.wsdl.util.WsdlUtil;
import org.jbpm.bpel.wsdl.xml.WsdlConstants;
import org.jbpm.bpel.xml.ActivityReader;
import org.jbpm.bpel.xml.BpelConstants;
import org.jbpm.bpel.xml.ParseProblem;
import org.jbpm.bpel.xml.ProblemCounter;
import org.jbpm.bpel.xml.ProblemHandler;
import org.jbpm.bpel.xml.ProcessArchiveWsdlLocator;
import org.jbpm.bpel.xml.ProcessWsdlLocator;
import org.jbpm.bpel.xml.util.NodeIterator;
import org.jbpm.bpel.xml.util.XmlUtil;
import org.jbpm.jpdl.par.ProcessArchive;
import org.jbpm.jpdl.xml.Problem;
import org.jbpm.util.ClassLoaderUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BpelReader {
    private Map activityReaders = this.createActivityReaders();
    private ProblemHandler problemHandler;
    public static final String RESOURCE_ACTIVITY_READERS = "resource.activity.readers";
    private static final Log log = LogFactory.getLog((Class)BpelReader.class);
    private static final Map activityReaderClasses = BpelReader.readActivityReaderClasses();
    private static Templates bpelUpgradeTemplates;
    static /* synthetic */ Class class$org$jbpm$bpel$xml$ActivityReader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(BpelProcessDefinition processDefinition, InputSource source) {
        DocumentBuilder documentParser = XmlUtil.getDocumentBuilder();
        ProblemHandler problemHandler = this.getProblemHandler();
        documentParser.setErrorHandler(problemHandler.asSaxErrorHandler());
        String documentURI = source.getSystemId();
        processDefinition.setLocation(documentURI);
        try {
            Document document = documentParser.parse(source);
            if (problemHandler.getProblemCount() > 0) {
                return;
            }
            ProcessWsdlLocator wsdlLocator = null;
            if (documentURI != null) {
                wsdlLocator = new ProcessWsdlLocator(new URI(documentURI));
                wsdlLocator.setProblemHandler(problemHandler);
            }
            this.read(processDefinition, document.getDocumentElement(), wsdlLocator);
        }
        catch (Exception e) {
            problemHandler.add(new Problem(2, "could not read process document", (Throwable)e));
        }
        finally {
            documentParser.setErrorHandler(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(BpelProcessDefinition processDefinition, ProcessArchive archive) {
        String location = processDefinition.getLocation();
        byte[] bpelEntry = archive.removeEntry(location);
        if (bpelEntry == null) {
            this.getProblemHandler().add(new Problem(2, "process document entry not found"));
            return;
        }
        DocumentBuilder documentParser = XmlUtil.getDocumentBuilder();
        ProblemHandler problemHandler = this.getProblemHandler();
        documentParser.setErrorHandler(problemHandler.asSaxErrorHandler());
        try {
            Document document = documentParser.parse(new ByteArrayInputStream(bpelEntry));
            if (problemHandler.getProblemCount() > 0) {
                return;
            }
            ProcessArchiveWsdlLocator wsdlLocator = new ProcessArchiveWsdlLocator(new URI(location), archive);
            wsdlLocator.setProblemHandler(problemHandler);
            this.read(processDefinition, document.getDocumentElement(), wsdlLocator);
        }
        catch (Exception e) {
            problemHandler.add(new Problem(2, "could not read process document", (Throwable)e));
        }
        finally {
            documentParser.setErrorHandler(null);
        }
    }

    public void read(BpelProcessDefinition process, Element processElem, ProcessWsdlLocator wsdlLocator) {
        ProblemHandler problemHandler = this.getProblemHandler();
        if ("http://schemas.xmlsoap.org/ws/2003/03/business-process/".equals(processElem.getNamespaceURI())) {
            try {
                Transformer bpelUpgrader = BpelReader.getBpelUpgradeTemplates().newTransformer();
                bpelUpgrader.setErrorListener(problemHandler.asTraxErrorListener());
                Document resultDocument = XmlUtil.createDocument();
                bpelUpgrader.transform(new DOMSource(processElem.getOwnerDocument()), new DOMResult(resultDocument));
                processElem = resultDocument.getDocumentElement();
                log.debug((Object)("upgraded bpel document: " + process.getLocation()));
            }
            catch (TransformerException e) {
                Problem problem = new Problem(2, "bpel upgrade failed", (Throwable)e);
                problem.setResource(process.getLocation());
                problemHandler.add(problem);
            }
            if (problemHandler.getProblemCount() > 0) {
                return;
            }
        }
        this.readProcessAttributes(processElem, process);
        ImportDefinition importDefinition = process.getImportDefinition();
        this.readImports(processElem, importDefinition, wsdlLocator);
        if (problemHandler.getProblemCount() > 0) {
            return;
        }
        try {
            this.registerPropertyAliases(importDefinition);
            this.readScope(processElem, process.getGlobalScope());
            log.info((Object)("read bpel document: " + process.getLocation()));
        }
        catch (BpelException e) {
            problemHandler.add(new Problem(2, "bpel process is invalid", (Throwable)((Object)e)));
        }
    }

    static synchronized Templates getBpelUpgradeTemplates() {
        if (bpelUpgradeTemplates == null) {
            bpelUpgradeTemplates = XmlUtil.createTemplates(BpelReader.class.getResource("bpel-1-1-converter.xslt"));
        }
        return bpelUpgradeTemplates;
    }

    public void registerPropertyAliases(ImportDefinition importDefinition) {
        List imports = importDefinition.getImports();
        if (imports == null) {
            return;
        }
        BpelProcessDefinition process = (BpelProcessDefinition)importDefinition.getProcessDefinition();
        String queryLanguage = process.getQueryLanguage();
        int n = imports.size();
        for (int i = 0; i < n; ++i) {
            org.jbpm.bpel.graph.def.Import imp = (org.jbpm.bpel.graph.def.Import)imports.get(i);
            if (!Import.Type.WSDL.equals((Object)imp.getType())) continue;
            this.registerPropertyAliases(importDefinition, (Definition)imp.getDocument(), queryLanguage);
        }
    }

    private void registerPropertyAliases(ImportDefinition importDefinition, Definition wsdlDef, String queryLanguage) {
        BpelProcessDefinition process = (BpelProcessDefinition)importDefinition.getProcessDefinition();
        Iterator aliasIt = WsdlUtil.getExtensions(wsdlDef.getExtensibilityElements(), WsdlConstants.Q_PROPERTY_ALIAS);
        while (aliasIt.hasNext()) {
            Query query;
            Problem problem;
            PropertyAlias alias = (PropertyAlias)aliasIt.next();
            Property property = alias.getProperty();
            Message message = alias.getMessage();
            if (property.isUndefined()) {
                problem = new Problem(2, "aliasing property not found: property=" + property.getQName() + ", message=" + message.getQName());
                problem.setResource(wsdlDef.getDocumentBaseURI());
                this.getProblemHandler().add(problem);
            } else {
                importDefinition.addProperty(property);
            }
            if (message.isUndefined()) {
                problem = new Problem(2, "aliased message not found: message=" + message.getQName() + ", property=" + property.getQName());
                problem.setResource(wsdlDef.getDocumentBaseURI());
                this.getProblemHandler().add(problem);
            } else {
                MessageType type = importDefinition.getMessageType(message.getQName());
                type.addPropertyAlias(alias);
            }
            if ((query = alias.getQuery()) == null) continue;
            if (query.getLanguage() == null) {
                query.setLanguage(queryLanguage);
            }
            query.setNamespaces(process.addNamespaces(query.getNamespaces()));
            try {
                query.parse();
            }
            catch (BpelException e) {
                Problem problem2 = new Problem(2, "could not parse aliased location: property=" + property.getQName() + ", message=" + message.getQName(), (Throwable)((Object)e));
                problem2.setResource(wsdlDef.getDocumentBaseURI());
                this.getProblemHandler().add(problem2);
            }
        }
        Iterator importsIt = wsdlDef.getImports().values().iterator();
        while (importsIt.hasNext()) {
            List imports = (List)importsIt.next();
            int n = imports.size();
            for (int i = 0; i < n; ++i) {
                Import imp = (Import)imports.get(i);
                this.registerPropertyAliases(importDefinition, imp.getDefinition(), queryLanguage);
            }
        }
    }

    public void readProcessAttributes(Element processElem, BpelProcessDefinition process) {
        process.setName(processElem.getAttribute("name"));
        process.setTargetNamespace(processElem.getAttribute("targetNamespace"));
        process.setQueryLanguage(XmlUtil.getAttribute(processElem, "queryLanguage"));
        process.setExpressionLanguage(XmlUtil.getAttribute(processElem, "expressionLanguage"));
        Attr suppressAttr = processElem.getAttributeNode("suppressJoinFailure");
        process.getGlobalScope().setSuppressJoinFailure(this.readTBoolean(suppressAttr, Boolean.FALSE));
    }

    public void readImports(Element processElem, ImportDefinition importDefinition, ProcessWsdlLocator wsdlLocator) {
        Iterator importElemIt = XmlUtil.getElements(processElem, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "import");
        if (importElemIt.hasNext()) {
            do {
                Element importElem = (Element)importElemIt.next();
                org.jbpm.bpel.graph.def.Import _import = this.readImport(importElem);
                importDefinition.addImport(_import);
                if (!Import.Type.WSDL.equals((Object)_import.getType())) continue;
                this.readImportWsdlDefinition(_import, wsdlLocator);
                Definition def = (Definition)_import.getDocument();
                if (_import.getNamespace().equals(def.getTargetNamespace())) continue;
                ParseProblem problem = new ParseProblem("namespace does not match wsdl target namespace", importElem);
                this.getProblemHandler().add(problem);
            } while (importElemIt.hasNext());
        } else if (importDefinition.getImports() == null) {
            org.jbpm.bpel.graph.def.Import masterImport = this.createMasterWsdlImport(wsdlLocator);
            importDefinition.addImport(masterImport);
            this.readImportWsdlDefinition(masterImport, wsdlLocator);
            Definition masterWsdl = (Definition)masterImport.getDocument();
            masterImport.setNamespace(masterWsdl.getTargetNamespace());
        }
    }

    public org.jbpm.bpel.graph.def.Import readImport(Element importElem) {
        org.jbpm.bpel.graph.def.Import _import = new org.jbpm.bpel.graph.def.Import();
        _import.setNamespace(importElem.getAttribute("namespace"));
        _import.setLocation(importElem.getAttribute("location"));
        _import.setType(Import.Type.valueOf(importElem.getAttribute("importType")));
        return _import;
    }

    public org.jbpm.bpel.graph.def.Import createMasterWsdlImport(ProcessWsdlLocator wsdlLocator) {
        String processPath = wsdlLocator.getProcessURI().getPath();
        int beginIndex = processPath.lastIndexOf(47);
        beginIndex = beginIndex != -1 ? ++beginIndex : 0;
        int endIndex = processPath.lastIndexOf(46);
        if (endIndex == -1 || beginIndex >= endIndex) {
            Problem problem = new Problem(2, "cannot extract file name from process path: " + processPath);
            this.getProblemHandler().add(problem);
            return new org.jbpm.bpel.graph.def.Import();
        }
        String wsdlFile = processPath.substring(beginIndex, endIndex) + ".wsdl";
        org.jbpm.bpel.graph.def.Import masterImport = new org.jbpm.bpel.graph.def.Import();
        masterImport.setLocation(wsdlFile);
        masterImport.setType(Import.Type.WSDL);
        return masterImport;
    }

    public void readImportWsdlDefinition(org.jbpm.bpel.graph.def.Import _import, ProcessWsdlLocator wsdlLocator) {
        Definition definition;
        block2: {
            String location = _import.getLocation();
            try {
                wsdlLocator.resolveBaseURI(location);
                WSDLReader reader = WsdlUtil.getFactory().newWSDLReader();
                definition = reader.readWSDL((WSDLLocator)wsdlLocator);
                log.info((Object)("read wsdl document: " + location));
            }
            catch (WSDLException e) {
                this.getProblemHandler().add(new Problem(2, "could not read wsdl document", (Throwable)e));
                definition = WsdlUtil.getFactory().newDefinition();
                definition.setDocumentBaseURI(location);
                if (_import.getNamespace() == null) break block2;
                definition.setTargetNamespace(_import.getNamespace());
            }
        }
        _import.setDocument(definition);
    }

    public Boolean readTBoolean(Attr attribute, Boolean defaultValue) {
        if (attribute == null) {
            return defaultValue;
        }
        String text = attribute.getValue();
        return "yes".equals(text) ? Boolean.TRUE : ("no".equals(text) ? Boolean.FALSE : defaultValue);
    }

    public Expression readExpression(Element enclosingElem, CompositeActivity parent) {
        Expression expression = new Expression();
        this.readExpression(enclosingElem, parent, expression);
        return expression;
    }

    public JoinCondition readJoinCondition(Element conditionElem, CompositeActivity parent) {
        JoinCondition joinCondition = new JoinCondition();
        this.readExpression(conditionElem, parent, joinCondition);
        return joinCondition;
    }

    protected void readExpression(Element enclosingElem, CompositeActivity parent, Expression expression) {
        BpelProcessDefinition process = parent.getBpelProcessDefinition();
        expression.setText(DOMUtils.getChildCharacterData((Element)enclosingElem));
        expression.setNamespaces(process.addNamespaces(XmlUtil.getNamespaces(enclosingElem)));
        String language = XmlUtil.getAttribute(enclosingElem, "expressionLanguage");
        if (language == null) {
            language = process.getExpressionLanguage();
        }
        expression.setLanguage(language);
        try {
            expression.parse();
        }
        catch (BpelException e) {
            this.getProblemHandler().add(new ParseProblem("could not parse script", enclosingElem, (Throwable)((Object)e)));
        }
    }

    public void readScope(Element scopeElem, Scope scope) {
        Element terminationHandlerElem;
        Element compensationHandlerElem;
        Element setsElem;
        Element variablesElem;
        scope.installFaultExceptionHandler();
        Element partnerLinksElem = XmlUtil.getElement(scopeElem, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "partnerLinks");
        if (partnerLinksElem != null) {
            scope.setPartnerLinks(this.readPartnerLinks(partnerLinksElem, scope));
        }
        if ((variablesElem = XmlUtil.getElement(scopeElem, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "variables")) != null) {
            scope.setVariables(this.readVariables(variablesElem, scope));
        }
        if ((setsElem = XmlUtil.getElement(scopeElem, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "correlationSets")) != null) {
            scope.setCorrelationSets(this.readCorrelationSets(setsElem, scope));
        }
        Element activityElem = this.getActivityElement(scopeElem);
        this.readActivity(activityElem, scope);
        Element faultHandlersElem = XmlUtil.getElement(scopeElem, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "faultHandlers");
        if (faultHandlersElem != null) {
            this.readFaultHandlers(faultHandlersElem, scope);
        }
        if ((compensationHandlerElem = XmlUtil.getElement(scopeElem, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "compensationHandler")) != null) {
            this.readCompensationHandler(compensationHandlerElem, scope);
        }
        if ((terminationHandlerElem = XmlUtil.getElement(scopeElem, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "terminationHandler")) != null) {
            this.readTerminationHandler(terminationHandlerElem, scope);
        } else {
            Catch forcedTerminationHandler = scope.selectCatch(BpelConstants.FAULT_FORCED_TERMINATION);
            if (forcedTerminationHandler != null) {
                scope.setTerminationHandler(forcedTerminationHandler);
            }
        }
        Element eventHandlersElem = XmlUtil.getElement(scopeElem, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "eventHandlers");
        if (eventHandlersElem != null) {
            this.readEventHandlers(eventHandlersElem, scope);
        }
    }

    public void readCompensationHandler(Element handlerElem, Scope scope) {
        Handler handler = new Handler();
        scope.setCompensationHandler(handler);
        Activity activity = this.readActivity(this.getActivityElement(handlerElem), handler);
        handler.setActivity(activity);
    }

    public void readTerminationHandler(Element handlerElem, Scope scope) {
        Handler handler = new Handler();
        scope.setTerminationHandler(handler);
        Activity activity = this.readActivity(this.getActivityElement(handlerElem), handler);
        handler.setActivity(activity);
    }

    public void readFaultHandlers(Element faultHandlersElem, Scope scope) {
        Iterator catchElemIt = XmlUtil.getElements(faultHandlersElem, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "catch");
        while (catchElemIt.hasNext()) {
            Element catchElem = (Element)catchElemIt.next();
            this.readCatch(catchElem, scope);
        }
        Element catchAllElem = XmlUtil.getElement(faultHandlersElem, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "catchAll");
        if (catchAllElem != null) {
            this.readCatchAll(catchAllElem, scope);
        }
    }

    public void readCatch(Element catchElem, Scope scope) {
        Catch catcher = new Catch();
        QName faultName = this.getFaultName(catchElem);
        catcher.setFaultName(faultName);
        VariableDefinition faultVariable = this.getFaultVariable(catchElem, scope);
        if (faultVariable != null) {
            catcher.setFaultVariable(faultVariable);
        } else if (faultName == null) {
            this.getProblemHandler().add(new ParseProblem("catch must specify faultName, faultVariable or both", catchElem));
        }
        scope.addCatch(catcher);
        Activity activity = this.readActivity(this.getActivityElement(catchElem), catcher);
        catcher.setActivity(activity);
    }

    protected QName getFaultName(Element catchElem) {
        QName faultName = null;
        String faultNameAttr = XmlUtil.getAttribute(catchElem, "faultName");
        if (faultNameAttr != null) {
            faultName = XmlUtil.parseQName(faultNameAttr, catchElem);
        }
        return faultName;
    }

    protected VariableDefinition getFaultVariable(Element catchElem, Scope scope) {
        VariableDefinition faultVariable = null;
        String faultVariableAttr = XmlUtil.getAttribute(catchElem, "faultVariable");
        if (faultVariableAttr != null) {
            VariableType faultType = this.getFaultType(catchElem, scope.getBpelProcessDefinition().getImportDefinition());
            if (faultType != null) {
                faultVariable = new VariableDefinition();
                faultVariable.setName(faultVariableAttr);
                faultVariable.setType(faultType);
            } else {
                faultVariable = scope.findVariable(faultVariableAttr);
                if (faultVariable == null) {
                    this.getProblemHandler().add(new ParseProblem("variable not found", catchElem));
                } else if (!faultVariable.getType().isMessage()) {
                    this.getProblemHandler().add(new ParseProblem("catch must reference a message variable", catchElem));
                }
            }
        }
        return faultVariable;
    }

    private VariableType getFaultType(Element catchElem, ImportDefinition importDefinition) {
        VariableType type = null;
        String messageType = XmlUtil.getAttribute(catchElem, "faultMessageType");
        String elementName = XmlUtil.getAttribute(catchElem, "faultElement");
        if (messageType != null) {
            if (elementName != null) {
                this.getProblemHandler().add(new ParseProblem("found more than one fault type specifier", catchElem));
            }
            type = this.getMessageType(catchElem, messageType, importDefinition);
        } else if (elementName != null) {
            type = this.getElementType(catchElem, elementName, importDefinition);
        }
        return type;
    }

    public void readCatchAll(Element catchAllElem, Scope scope) {
        Handler handler = new Handler();
        scope.setCatchAll(handler);
        Activity activity = this.readActivity(this.getActivityElement(catchAllElem), handler);
        handler.setActivity(activity);
    }

    public void readEventHandlers(Element eventHandlersElem, Scope scope) {
        Iterator onEventElemIt = XmlUtil.getElements(eventHandlersElem, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "onEvent");
        while (onEventElemIt.hasNext()) {
            OnEvent onEvent = new OnEvent();
            scope.addOnEvent(onEvent);
            this.readOnEvent((Element)onEventElemIt.next(), onEvent);
        }
        Iterator alarmElemIt = XmlUtil.getElements(eventHandlersElem, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "onAlarm");
        while (alarmElemIt.hasNext()) {
            OnAlarm onAlarm = new OnAlarm();
            scope.addOnAlarm(onAlarm);
            this.readOnAlarm((Element)alarmElemIt.next(), onAlarm);
        }
    }

    public void readOnEvent(Element onEventElem, OnEvent onEvent) {
        String messageName = XmlUtil.getAttribute(onEventElem, "messageType");
        if (messageName != null) {
            VariableDefinition variable = new VariableDefinition();
            String name = XmlUtil.getAttribute(onEventElem, "variable");
            variable.setName(name);
            MessageType messageType = this.getMessageType(onEventElem, messageName, onEvent.getBpelProcessDefinition().getImportDefinition());
            variable.setType(messageType);
            onEvent.setVariableDefinition(variable);
        }
        ReceiveAction receiveAction = this.readReceiveAction(onEventElem, onEvent);
        onEvent.setAction(receiveAction);
        Element activityElem = this.getActivityElement(onEventElem);
        onEvent.setActivity(this.readActivity(activityElem, onEvent));
    }

    public OnAlarm readOnAlarm(Element onAlarmElem, OnAlarm onAlarm) {
        onAlarm.setAction(this.readAlarmAction(onAlarmElem, onAlarm));
        Element activityElem = this.getActivityElement(onAlarmElem);
        onAlarm.setActivity(this.readActivity(activityElem, onAlarm));
        return onAlarm;
    }

    public Map readVariables(Element variablesElem, CompositeActivity parent) {
        HashMap<String, VariableDefinition> variables = new HashMap<String, VariableDefinition>();
        ImportDefinition importDefinition = parent.getBpelProcessDefinition().getImportDefinition();
        Iterator variableElemIt = XmlUtil.getElements(variablesElem, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "variable");
        while (variableElemIt.hasNext()) {
            Element variableElem = (Element)variableElemIt.next();
            VariableDefinition variable = this.readVariable(variableElem, importDefinition);
            String variableName = variable.getName();
            if (variables.containsKey(variableName)) {
                this.getProblemHandler().add(new ParseProblem("duplicate local name", variableElem));
                continue;
            }
            variables.put(variableName, variable);
        }
        return variables;
    }

    public VariableDefinition readVariable(Element variableElem, ImportDefinition importDefinition) {
        VariableDefinition variable = new VariableDefinition();
        variable.setName(variableElem.getAttribute("name"));
        variable.setType(this.getVariableType(variableElem, importDefinition));
        return variable;
    }

    protected VariableType getVariableType(Element variableElem, ImportDefinition importDefinition) {
        VariableType type;
        String schemaType = XmlUtil.getAttribute(variableElem, "type");
        String messageType = XmlUtil.getAttribute(variableElem, "messageType");
        String elementName = XmlUtil.getAttribute(variableElem, "element");
        if (messageType != null) {
            if (schemaType != null || elementName != null) {
                this.getProblemHandler().add(new ParseProblem("more than one type specifier present", variableElem));
            }
            type = this.getMessageType(variableElem, messageType, importDefinition);
        } else if (schemaType != null) {
            if (elementName != null) {
                this.getProblemHandler().add(new ParseProblem("more than one type specifier present", variableElem));
            }
            type = this.getSchemaType(variableElem, schemaType, importDefinition);
        } else if (elementName != null) {
            type = this.getElementType(variableElem, elementName, importDefinition);
        } else {
            this.getProblemHandler().add(new ParseProblem("no type specifier present", variableElem));
            type = null;
        }
        return type;
    }

    private MessageType getMessageType(Element contextElem, String messageType, ImportDefinition importDefinition) {
        QName messageQType = XmlUtil.parseQName(messageType, contextElem);
        MessageType type = importDefinition.getMessageType(messageQType);
        if (type == null) {
            this.getProblemHandler().add(new ParseProblem("message type not found", contextElem));
            Message message = WsdlUtil.getSharedDefinition().createMessage();
            message.setQName(messageQType);
            type = new MessageType(message);
        }
        return type;
    }

    private ElementType getElementType(Element contextElem, String elementName, ImportDefinition importDefinition) {
        QName elementQName = XmlUtil.parseQName(elementName, contextElem);
        ElementType type = importDefinition.getElementType(elementQName);
        if (type == null) {
            this.getProblemHandler().add(new ParseProblem("element not found", contextElem));
            type = new ElementType(elementQName);
        }
        return type;
    }

    private SchemaType getSchemaType(Element contextElem, String schemaType, ImportDefinition importDefinition) {
        QName schemaQType = XmlUtil.parseQName(schemaType, contextElem);
        SchemaType type = importDefinition.getSchemaType(schemaQType);
        if (type == null) {
            this.getProblemHandler().add(new ParseProblem("schema type not found", contextElem));
            type = new SchemaType(schemaQType);
        }
        return type;
    }

    public Map readCorrelationSets(Element setsElem, CompositeActivity superState) {
        HashMap<String, CorrelationSetDefinition> correlationSets = new HashMap<String, CorrelationSetDefinition>();
        ImportDefinition importDefinition = superState.getBpelProcessDefinition().getImportDefinition();
        Iterator setElemIt = XmlUtil.getElements(setsElem, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "correlationSet");
        while (setElemIt.hasNext()) {
            Element setElem = (Element)setElemIt.next();
            CorrelationSetDefinition set = this.readCorrelationSet(setElem, importDefinition);
            String setName = set.getName();
            if (correlationSets.containsKey(setName)) {
                this.getProblemHandler().add(new ParseProblem("duplicate local name", setElem));
                continue;
            }
            correlationSets.put(setName, set);
        }
        return correlationSets;
    }

    public CorrelationSetDefinition readCorrelationSet(Element setElem, ImportDefinition importDefinition) {
        CorrelationSetDefinition set = new CorrelationSetDefinition();
        String[] propertyNames = setElem.getAttribute("properties").split("\\s");
        for (int p = 0; p < propertyNames.length; ++p) {
            String propertyName = propertyNames[p];
            QName propertyQName = XmlUtil.parseQName(propertyName, setElem);
            Property property = importDefinition.getProperty(propertyQName);
            if (property == null) {
                this.getProblemHandler().add(new ParseProblem("property not found: " + propertyName, setElem));
                property = new PropertyImpl();
                property.setQName(propertyQName);
            }
            set.addProperty(property);
        }
        set.setName(setElem.getAttribute("name"));
        return set;
    }

    public Map readPartnerLinks(Element partnerLinksElem, CompositeActivity parent) {
        HashMap<String, PartnerLinkDefinition> partnerLinks = new HashMap<String, PartnerLinkDefinition>();
        Iterator partnerLinkElemIt = XmlUtil.getElements(partnerLinksElem, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "partnerLink");
        while (partnerLinkElemIt.hasNext()) {
            Element partnerLinkElem = (Element)partnerLinkElemIt.next();
            PartnerLinkDefinition partnerLink = this.readPartnerLink(partnerLinkElem, parent);
            String plinkName = partnerLink.getName();
            if (partnerLinks.containsKey(plinkName)) {
                this.getProblemHandler().add(new ParseProblem("duplicate local name", partnerLinkElem));
                continue;
            }
            partnerLinks.put(plinkName, partnerLink);
        }
        return partnerLinks;
    }

    public PartnerLinkDefinition readPartnerLink(Element partnerLinkElem, CompositeActivity parent) {
        PartnerLinkDefinition partnerLink = new PartnerLinkDefinition();
        partnerLink.setName(partnerLinkElem.getAttribute("name"));
        String typeName = partnerLinkElem.getAttribute("partnerLinkType");
        QName typeQName = XmlUtil.parseQName(typeName, partnerLinkElem);
        PartnerLinkType type = parent.getBpelProcessDefinition().getImportDefinition().getPartnerLinkType(typeQName);
        if (type == null) {
            this.getProblemHandler().add(new ParseProblem("partner link type not found", partnerLinkElem));
            return partnerLink;
        }
        partnerLink.setPartnerLinkType(type);
        String myRoleName = XmlUtil.getAttribute(partnerLinkElem, "myRole");
        String partnerRoleName = XmlUtil.getAttribute(partnerLinkElem, "partnerRole");
        boolean partnerFirst = false;
        PartnerLinkType.Role role = type.getFirstRole();
        String roleName = role.getName();
        if (roleName.equals(myRoleName)) {
            partnerLink.setMyRole(role);
        } else if (roleName.equals(partnerRoleName)) {
            partnerLink.setPartnerRole(role);
            partnerFirst = true;
        } else {
            this.getProblemHandler().add(new ParseProblem("neither myRole nor partnerRole match the first role", partnerLinkElem));
            return partnerLink;
        }
        if (role.getPortType().isUndefined()) {
            this.getProblemHandler().add(new ParseProblem("port type of first role not found", partnerLinkElem));
        }
        if ((role = type.getSecondRole()) != null) {
            roleName = role.getName();
            if (partnerFirst) {
                if (!roleName.equals(myRoleName)) {
                    this.getProblemHandler().add(new ParseProblem("partnerRole matches the first role, but myRole does not match the second one", partnerLinkElem));
                }
                partnerLink.setMyRole(role);
            } else {
                if (!roleName.equals(partnerRoleName)) {
                    this.getProblemHandler().add(new ParseProblem("myRole matches the first role, but partnerRole does not match the second one", partnerLinkElem));
                }
                partnerLink.setPartnerRole(role);
            }
            if (role.getPortType().isUndefined()) {
                this.getProblemHandler().add(new ParseProblem("port type of second role not found", partnerLinkElem));
            }
        } else if (partnerFirst ? myRoleName != null : partnerRoleName != null) {
            this.getProblemHandler().add(new ParseProblem("both myRole and partnerRole are specified, but there is only one role", partnerLinkElem));
        }
        return partnerLink;
    }

    public ReceiveAction readReceiveAction(Element receiveElem, CompositeActivity parent) {
        ReceiveAction receiveAction = new ReceiveAction();
        String partnerLinkName = receiveElem.getAttribute("partnerLink");
        PartnerLinkDefinition partnerLink = parent.findPartnerLink(partnerLinkName);
        if (partnerLink == null) {
            this.getProblemHandler().add(new ParseProblem("partner link not found", receiveElem));
            return receiveAction;
        }
        receiveAction.setPartnerLink(partnerLink);
        PartnerLinkType.Role myRole = partnerLink.getMyRole();
        if (myRole == null) {
            this.getProblemHandler().add(new ParseProblem("partner link does not indicate my role", receiveElem));
            return receiveAction;
        }
        PortType portType = this.getMessageActivityPortType(receiveElem, myRole);
        Operation operation = this.getMessageActivityOperation(receiveElem, portType);
        receiveAction.setOperation(operation);
        VariableDefinition variable = this.getMessageActivityVariable(receiveElem, "variable", parent, operation.getInput().getMessage());
        receiveAction.setVariable(variable);
        receiveAction.setMessageExchange(XmlUtil.getAttribute(receiveElem, "messageExchange"));
        Element correlationsElem = XmlUtil.getElement(receiveElem, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "correlations");
        if (correlationsElem != null) {
            receiveAction.setCorrelations(this.readCorrelations(correlationsElem, parent, variable));
        }
        return receiveAction;
    }

    public Correlations readCorrelations(Element correlationsElem, CompositeActivity parent, VariableDefinition variable) {
        Correlations correlations = new Correlations();
        Iterator correlationElemIt = XmlUtil.getElements(correlationsElem, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "correlation");
        while (correlationElemIt.hasNext()) {
            Element correlationElem = (Element)correlationElemIt.next();
            Correlation correlation = this.readCorrelation(correlationElem, parent);
            this.checkVariableProperties(variable, correlation.getSet(), correlationElem);
            correlations.addCorrelation(correlation);
        }
        return correlations;
    }

    public Correlation readCorrelation(Element correlationElem, CompositeActivity parent) {
        Correlation correlation = new Correlation();
        String setName = correlationElem.getAttribute("set");
        CorrelationSetDefinition set = parent.findCorrelationSet(setName);
        if (set == null) {
            this.getProblemHandler().add(new ParseProblem("correlation set not found", correlationElem));
            set = new CorrelationSetDefinition();
            set.setName(setName);
        }
        correlation.setSet(set);
        correlation.setInitiate(Correlation.Initiate.valueOf(XmlUtil.getAttribute(correlationElem, "initiate")));
        return correlation;
    }

    PortType getMessageActivityPortType(Element serviceElem, PartnerLinkType.Role role) {
        QName portTypeQName;
        PortType implicitPortType = role.getPortType();
        String portTypeName = XmlUtil.getAttribute(serviceElem, "portType");
        if (portTypeName != null && !(portTypeQName = XmlUtil.parseQName(portTypeName, serviceElem)).equals(implicitPortType.getQName())) {
            this.getProblemHandler().add(new ParseProblem("port type mismatch between message activity and partner link", serviceElem));
        }
        return implicitPortType;
    }

    Operation getMessageActivityOperation(Element serviceElem, PortType portType) {
        String operationName = serviceElem.getAttribute("operation");
        Operation operation = portType.getOperation(operationName, null, null);
        if (operation == null) {
            this.getProblemHandler().add(new ParseProblem("operation not found", serviceElem));
            operation = WsdlUtil.getSharedDefinition().createOperation();
            operation.setName(operationName);
        } else {
            OperationType style = operation.getStyle();
            if (style == OperationType.SOLICIT_RESPONSE || style == OperationType.NOTIFICATION) {
                this.getProblemHandler().add(new ParseProblem("operation style not supported", serviceElem));
            }
        }
        return operation;
    }

    VariableDefinition getMessageActivityVariable(Element serviceElem, String variableAttr, CompositeActivity parent, Message activityMessage) {
        String variableName = XmlUtil.getAttribute(serviceElem, variableAttr);
        if (variableName == null) {
            this.getProblemHandler().add(new ParseProblem(variableAttr + " attribute is missing", serviceElem));
            VariableDefinition variable = new VariableDefinition();
            variable.setName("unnamed");
            return variable;
        }
        VariableDefinition variable = parent.findVariable(variableName);
        if (variable == null) {
            this.getProblemHandler().add(new ParseProblem(variableAttr + " not found", serviceElem));
            variable = new VariableDefinition();
            variable.setName(variableName);
            variable.setType(parent.getBpelProcessDefinition().getImportDefinition().getMessageType(activityMessage.getQName()));
        } else if (!variable.getType().getName().equals(activityMessage.getQName())) {
            this.getProblemHandler().add(new ParseProblem(variableAttr + " type is not applicable for the operation", serviceElem));
        }
        return variable;
    }

    void checkVariableProperties(VariableDefinition variable, CorrelationSetDefinition set, Element correlationElem) {
        Map varProperties = variable.getType().getPropertyAliases();
        if (varProperties != null) {
            Iterator setPropertyIt = set.getProperties().iterator();
            while (setPropertyIt.hasNext()) {
                Property setProperty = (Property)setPropertyIt.next();
                QName setPropertyName = setProperty.getQName();
                if (varProperties.containsKey(setPropertyName)) continue;
                this.getProblemHandler().add(new ParseProblem("property does not appear in variable: " + setPropertyName, correlationElem));
            }
        } else {
            this.getProblemHandler().add(new ParseProblem("variable contains no properties", correlationElem));
        }
    }

    public AlarmAction readAlarmAction(Element element, CompositeActivity parent) {
        Element forElem;
        AlarmAction alarmAction = new AlarmAction();
        Element repeatEveryElem = XmlUtil.getElement(element, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "repeatEvery");
        if (repeatEveryElem != null) {
            alarmAction.setRepeatEvery(this.readExpression(repeatEveryElem, parent));
        }
        if ((forElem = XmlUtil.getElement(element, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "for")) != null) {
            alarmAction.setFor(this.readExpression(forElem, parent));
        } else {
            Element untilElem = XmlUtil.getElement(element, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "until");
            if (untilElem != null) {
                alarmAction.setUntil(this.readExpression(untilElem, parent));
            } else if (repeatEveryElem == null) {
                this.getProblemHandler().add(new ParseProblem("alarm expression is missing", element));
            }
        }
        return alarmAction;
    }

    public Activity readActivity(Element activityElem, CompositeActivity parent) {
        if (activityElem == null) {
            return new Empty();
        }
        ActivityReader parser = (ActivityReader)this.activityReaders.get(activityElem.getLocalName());
        return parser.read(activityElem, parent);
    }

    protected Element getActivityElement(Element parent) {
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!ActivityElementPredicate.evaluate(child)) continue;
            return (Element)child;
        }
        this.getProblemHandler().add(new ParseProblem("activity not found", parent));
        return null;
    }

    protected Iterator getActivityElements(Element parent) {
        return new FilterIterator((Iterator)new NodeIterator(parent), (Predicate)new ActivityElementPredicate());
    }

    public ActivityReader getActivityReader(String name) {
        return (ActivityReader)this.activityReaders.get(name);
    }

    private Map createActivityReaders() {
        HashMap activityReaders = new HashMap();
        Iterator readerClassIt = activityReaderClasses.entrySet().iterator();
        while (readerClassIt.hasNext()) {
            Map.Entry readerClassEntry = readerClassIt.next();
            Object activityName = readerClassEntry.getKey();
            Class readerClass = (Class)readerClassEntry.getValue();
            try {
                ActivityReader reader = (ActivityReader)readerClass.newInstance();
                reader.setBpelReader(this);
                activityReaders.put(activityName, reader);
            }
            catch (InstantiationException e) {
                log.warn((Object)("reader class not instantiable: " + readerClass.getName()), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.warn((Object)("reader class or constructor not public: " + readerClass.getName()), (Throwable)e);
            }
        }
        return activityReaders;
    }

    public ProblemHandler getProblemHandler() {
        if (this.problemHandler == null) {
            this.problemHandler = new ProblemCounter();
        }
        return this.problemHandler;
    }

    public void setProblemHandler(ProblemHandler problemHandler) {
        this.problemHandler = problemHandler;
    }

    private static Map readActivityReaderClasses() {
        Element readersElem;
        String resource = JbpmConfiguration.Configs.getString((String)RESOURCE_ACTIVITY_READERS);
        try {
            readersElem = XmlUtil.parseResource(resource);
        }
        catch (SAXException e) {
            log.error((Object)("activity readers document contains invalid xml: " + resource), (Throwable)e);
            return Collections.EMPTY_MAP;
        }
        catch (IOException e) {
            log.error((Object)("could not read activity readers document: " + resource), (Throwable)e);
            return Collections.EMPTY_MAP;
        }
        HashMap<String, Class> activityReaderClasses = new HashMap<String, Class>();
        Iterator readerElemIt = XmlUtil.getElements(readersElem, null, "activityReader");
        while (readerElemIt.hasNext()) {
            String readerClassName;
            Class readerClass;
            Element readerElem = (Element)readerElemIt.next();
            String activityName = readerElem.getAttribute("name");
            if (!(class$org$jbpm$bpel$xml$ActivityReader == null ? BpelReader.class$("org.jbpm.bpel.xml.ActivityReader") : class$org$jbpm$bpel$xml$ActivityReader).isAssignableFrom(readerClass = ClassLoaderUtil.loadClass((String)(readerClassName = readerElem.getAttribute("class"))))) {
                log.warn((Object)("not an activity reader: " + readerClassName));
                continue;
            }
            activityReaderClasses.put(activityName, readerClass);
            log.debug((Object)("registered activity reader: name=" + activityName + ", class=" + readerClassName));
        }
        return activityReaderClasses;
    }

    private static class ActivityElementPredicate
    implements Predicate {
        private static String[] BPEL_2_ACTIVITIES = new String[]{"empty", "receive", "reply", "invoke", "assign", "throw", "exit", "wait", "sequence", "if", "switch", "while", "pick", "flow", "scope", "compensate", "compensateScope", "rethrow", "validate"};
        private static final Set activityNames = new HashSet<String>(Arrays.asList(BPEL_2_ACTIVITIES));

        private ActivityElementPredicate() {
        }

        public boolean evaluate(Object arg) {
            return ActivityElementPredicate.evaluate((Node)arg);
        }

        static boolean evaluate(Node node) {
            return node.getNodeType() == 1 && "http://schemas.xmlsoap.org/ws/2004/03/business-process/".equals(node.getNamespaceURI()) && activityNames.contains(node.getLocalName());
        }
    }
}

