/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.variable.def;

import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Message;
import javax.xml.namespace.QName;
import org.jbpm.bpel.graph.exe.BpelFaultException;
import org.jbpm.bpel.sublang.def.Query;
import org.jbpm.bpel.variable.def.VariableDefinition;
import org.jbpm.bpel.variable.def.VariableType;
import org.jbpm.bpel.variable.exe.MessageValue;
import org.jbpm.bpel.wsdl.PropertyAlias;
import org.jbpm.bpel.xml.BpelConstants;
import org.w3c.dom.Element;

public class MessageType
extends VariableType {
    private Message message;
    private static final long serialVersionUID = 1L;

    MessageType() {
    }

    public MessageType(Message message) {
        this.setMessage(message);
    }

    public QName getName() {
        return this.getMessage().getQName();
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public Object createValue(VariableDefinition definition) {
        return new MessageValue(this);
    }

    public boolean isInitialized(Object variableValue) {
        return ((MessageValue)variableValue).isInitialized();
    }

    public void setValue(Object currentValue, Object newValue) {
        if (!(newValue instanceof MessageValue)) {
            throw new BpelFaultException(BpelConstants.FAULT_MISMATCHED_ASSIGNMENT);
        }
        MessageValue newMessageValue = (MessageValue)newValue;
        if (!this.getName().equals(newMessageValue.getType().getName())) {
            throw new BpelFaultException(BpelConstants.FAULT_MISMATCHED_ASSIGNMENT);
        }
        MessageValue curMessageValue = (MessageValue)currentValue;
        curMessageValue.getParts().clear();
        Iterator partEntryIt = newMessageValue.getParts().entrySet().iterator();
        while (partEntryIt.hasNext()) {
            Map.Entry partEntry = partEntryIt.next();
            curMessageValue.setPart((String)partEntry.getKey(), partEntry.getValue());
        }
    }

    protected Object evaluateProperty(PropertyAlias propertyAlias, Object variableValue) {
        Element part = ((MessageValue)variableValue).getPart(propertyAlias.getPart());
        Query query = propertyAlias.getQuery();
        return query != null ? query.getEvaluator().evaluate(part) : part;
    }

    protected void assignProperty(PropertyAlias propertyAlias, Object variableValue, Object propertyValue) {
        String partName = propertyAlias.getPart();
        Query query = propertyAlias.getQuery();
        MessageValue messageValue = (MessageValue)variableValue;
        if (query == null) {
            messageValue.setPart(partName, propertyValue);
        } else {
            Element partForAssign = messageValue.getPartForAssign(partName);
            query.getEvaluator().assign(partForAssign, propertyValue);
        }
    }

    public boolean isMessage() {
        return true;
    }
}

