/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.sublang.xpath;

import java.io.Serializable;
import org.jaxen.UnresolvableException;
import org.jaxen.VariableContext;
import org.jbpm.bpel.graph.def.Activity;
import org.jbpm.bpel.variable.def.VariableDefinition;
import org.jbpm.bpel.variable.exe.MessageValue;
import org.jbpm.graph.exe.Token;

public class TokenVariableContext
implements VariableContext,
Serializable {
    private final Token token;
    private static final long serialVersionUID = 1L;

    public TokenVariableContext(Token token) {
        if (token == null) {
            throw new NullPointerException("token must not be null");
        }
        this.token = token;
    }

    public Token getToken() {
        return this.token;
    }

    public VariableDefinition findVariableDefinition(String variableName) {
        Activity activity = (Activity)this.token.getNode();
        return activity.getCompositeActivity().findVariable(variableName);
    }

    public Object getVariableValue(String namespaceURI, String prefix, String localName) throws UnresolvableException {
        Object value;
        if (namespaceURI != null) {
            throw new UnresolvableException("variable not found: " + prefix + ':' + localName);
        }
        int dotIndex = localName.indexOf(46);
        if (dotIndex == -1) {
            VariableDefinition definition = this.findVariableDefinition(localName);
            if (definition == null) {
                throw new UnresolvableException("variable not found: " + localName);
            }
            value = definition.getValue(this.token);
            if (value instanceof MessageValue) {
                throw new UnresolvableException("illegal access to message variable: " + localName);
            }
        } else {
            String messageName = localName.substring(0, dotIndex);
            VariableDefinition definition = this.findVariableDefinition(messageName);
            if (definition == null) {
                throw new UnresolvableException("variable not found: " + messageName);
            }
            value = definition.getValue(this.token);
            if (!(value instanceof MessageValue)) {
                throw new UnresolvableException("illegal access to part of non-message variable: " + localName);
            }
            MessageValue messageValue = (MessageValue)value;
            String partName = localName.substring(dotIndex + 1);
            value = messageValue.getPart(partName);
        }
        return value;
    }
}

