/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.integration.exe;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jbpm.bpel.graph.exe.BpelFaultException;
import org.jbpm.bpel.integration.def.CorrelationSetDefinition;
import org.jbpm.bpel.variable.def.MessageType;
import org.jbpm.bpel.variable.exe.MessageValue;
import org.jbpm.bpel.wsdl.Property;
import org.jbpm.bpel.xml.BpelConstants;

public class CorrelationSetInstance {
    long id;
    private CorrelationSetDefinition definition;
    private Map properties;
    private static final long serialVersionUID = 1L;

    public CorrelationSetDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(CorrelationSetDefinition definition) {
        this.definition = definition;
    }

    public boolean isInitialized() {
        return this.properties != null && this.properties.size() > 0;
    }

    public void initialize(Map propertyValues) {
        this.checkNotInitialized();
        this.properties = new HashMap();
        Iterator propertyIter = this.definition.getProperties().iterator();
        while (propertyIter.hasNext()) {
            Property property = (Property)propertyIter.next();
            QName name = property.getQName();
            this.properties.put(name, propertyValues.get(name));
        }
    }

    public void initialize(MessageValue messageValue) {
        this.checkNotInitialized();
        this.properties = new HashMap();
        MessageType messageType = messageValue.getType();
        Iterator propertyIter = this.definition.getProperties().iterator();
        while (propertyIter.hasNext()) {
            Property property = (Property)propertyIter.next();
            QName propertyName = property.getQName();
            Object propertyValue = messageType.getPropertyValue(propertyName, messageValue);
            this.properties.put(propertyName, propertyValue);
        }
    }

    public Object getProperty(QName propertyName) {
        this.checkInitialized();
        return this.properties.get(propertyName);
    }

    public Map getProperties() {
        this.checkInitialized();
        return this.properties;
    }

    public void validateConstraint(MessageValue messageValue) {
        this.checkInitialized();
        MessageType messageType = messageValue.getType();
        Iterator entryIt = this.properties.entrySet().iterator();
        while (entryIt.hasNext()) {
            Map.Entry nameValueEntry = entryIt.next();
            QName propertyName = (QName)nameValueEntry.getKey();
            Object propertyValue = nameValueEntry.getValue();
            if (propertyValue.equals(messageType.getPropertyValue(propertyName, messageValue))) continue;
            throw new BpelFaultException(BpelConstants.FAULT_CORRELATION_VIOLATION);
        }
    }

    private void checkInitialized() {
        if (!this.isInitialized()) {
            throw new BpelFaultException(BpelConstants.FAULT_CORRELATION_VIOLATION);
        }
    }

    private void checkNotInitialized() {
        if (this.isInitialized()) {
            throw new BpelFaultException(BpelConstants.FAULT_CORRELATION_VIOLATION);
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.definition.getName()).append("id", this.id).toString();
    }
}

