/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.integration.client;

import com.ibm.wsdl.extensions.soap.SOAPConstants;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.wsdl.Fault;
import javax.wsdl.Port;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jbpm.bpel.BpelException;
import org.jbpm.bpel.graph.exe.BpelFaultException;
import org.jbpm.bpel.graph.exe.FaultInstance;
import org.jbpm.bpel.integration.soap.MessageDirection;
import org.jbpm.bpel.integration.soap.SoapFormatter;
import org.jbpm.bpel.variable.def.MessageType;
import org.jbpm.bpel.variable.exe.MessageValue;
import org.jbpm.bpel.wsdl.util.WsdlUtil;
import org.jbpm.bpel.xml.util.XmlUtil;

public class SoapClient {
    private final SoapFormatter formatter;
    private final URL address;

    public SoapClient(Port port) {
        this.formatter = new SoapFormatter(port.getBinding());
        SOAPAddress soapAddress = (SOAPAddress)WsdlUtil.getExtension(port.getExtensibilityElements(), SOAPConstants.Q_ELEM_SOAP_ADDRESS);
        if (soapAddress == null) {
            throw new BpelException("non-soap ports not supported: " + port);
        }
        String location = soapAddress.getLocationURI();
        try {
            this.address = new URL(location);
        }
        catch (MalformedURLException e) {
            throw new BpelException("invalid address location: " + location, e);
        }
    }

    protected final URL getAddress() {
        return this.address;
    }

    public Map call(String operation, Map inputParts) throws BpelFaultException {
        try {
            SOAPMessage soapOutput = this.callImpl(operation, inputParts);
            HashMap outputParts = new HashMap();
            if (XmlUtil.getElement((SOAPElement)soapOutput.getSOAPBody(), "http://schemas.xmlsoap.org/soap/envelope/", "Fault") == null) {
                this.formatter.readMessage(operation, soapOutput, outputParts, MessageDirection.OUTPUT);
                return outputParts;
            }
            Fault fault = this.formatter.readFault(operation, soapOutput, outputParts);
            String targetNamespace = this.formatter.getBinding().getPortType().getQName().getNamespaceURI();
            QName faultQName = new QName(targetNamespace, fault.getName());
            MessageValue faultMessage = new MessageValue(new MessageType(fault.getMessage()));
            faultMessage.setParts(outputParts);
            FaultInstance faultInstance = new FaultInstance(faultQName, faultMessage);
            throw new BpelFaultException(faultInstance);
        }
        catch (SOAPException e) {
            throw new BpelException("failed to call soap endpoint: " + this.getAddress(), (Exception)((Object)e));
        }
    }

    public void callOneWay(String operation, Map inputParts) {
        try {
            this.callImpl(operation, inputParts);
        }
        catch (SOAPException e) {
            throw new BpelException("failed to call soap endpoint: " + this.getAddress(), (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SOAPMessage callImpl(String operation, Map inputParts) throws SOAPException {
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage soapInput = messageFactory.createMessage();
        this.formatter.writeMessage(operation, soapInput, inputParts, MessageDirection.INPUT);
        SOAPConnection soapConnection = SOAPConnectionFactory.newInstance().createConnection();
        try {
            SOAPMessage sOAPMessage = soapConnection.call(soapInput, (Object)this.getAddress());
            return sOAPMessage;
        }
        finally {
            soapConnection.close();
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("formatter", (Object)this.formatter).append("address", (Object)this.getAddress()).toString();
    }
}

