/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.integration.catalog;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.bpel.integration.catalog.ServiceCatalog;
import org.jbpm.bpel.wsdl.util.WsdlUtil;

public class URLCatalog
implements ServiceCatalog {
    private String contextURL;
    private List locations = new ArrayList();
    private Definition[] definitions;
    private static final Log log = LogFactory.getLog((Class)URLCatalog.class);

    public String getContextURL() {
        return this.contextURL;
    }

    public void setContextURL(String contextURL) {
        this.contextURL = contextURL;
    }

    public void addLocation(String location) {
        this.locations.add(location);
    }

    public List getLocations() {
        return this.locations;
    }

    protected synchronized Definition[] getDefinitions() {
        if (this.definitions == null) {
            WSDLReader reader = WsdlUtil.getFactory().newWSDLReader();
            int n = this.locations.size();
            this.definitions = new Definition[n];
            for (int i = 0; i < n; ++i) {
                Definition definition;
                String location = (String)this.locations.get(i);
                try {
                    definition = reader.readWSDL(this.contextURL, location);
                }
                catch (WSDLException e) {
                    log.debug((Object)("ignoring definition read failure: " + e.getMessage()));
                    definition = WsdlUtil.getFactory().newDefinition();
                }
                this.definitions[i] = definition;
            }
        }
        return this.definitions;
    }

    public List lookupServices(QName portTypeName) {
        ArrayList<Service> services = new ArrayList<Service>();
        Definition[] definitions = this.getDefinitions();
        int n = definitions.length;
        for (int i = 0; i < n; ++i) {
            Definition def = definitions[i];
            Iterator serviceIt = def.getServices().values().iterator();
            while (serviceIt.hasNext()) {
                Service service = (Service)serviceIt.next();
                if (!URLCatalog.serviceImplementsPortType(service, portTypeName)) continue;
                services.add(service);
                log.debug((Object)("found candidate service: name=" + service.getQName() + ", definitionURI=" + def.getDocumentBaseURI() + ", portType=" + portTypeName));
            }
        }
        return services;
    }

    protected static boolean serviceImplementsPortType(Service service, QName portTypeName) {
        Iterator portIt = service.getPorts().values().iterator();
        while (portIt.hasNext()) {
            Port port = (Port)portIt.next();
            if (!port.getBinding().getPortType().getQName().equals(portTypeName)) continue;
            return true;
        }
        return false;
    }

    public Service lookupService(QName serviceName) {
        Definition def;
        Service service = null;
        String namespace = serviceName.getNamespaceURI();
        Definition[] definitions = this.getDefinitions();
        int n = definitions.length;
        for (int i = 0; !(i >= n || namespace.equals((def = definitions[i]).getTargetNamespace()) && (service = def.getService(serviceName)) != null); ++i) {
        }
        return service;
    }
}

