/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.graph.exe.state;

import org.jbpm.bpel.graph.exe.ScopeInstance;
import org.jbpm.bpel.graph.exe.ScopeState;
import org.jbpm.bpel.graph.exe.state.CompensatingState;

public class EndedState
extends ScopeState {
    private static final long serialVersionUID = 1L;
    public static final ScopeState TERMINATED = new EndedState("terminated", 13);
    public static final ScopeState COMPENSATED = new EndedState("compensated", 14);
    public static final ScopeState COMPLETED = new EndedState("completed", 15){
        private static final long serialVersionUID = 1L;

        public void compensate(ScopeInstance scope) {
            CompensatingState.enterCompensating(scope);
        }
    };
    public static final ScopeState FAULTED = new EndedState("faulted", 17){
        private static final long serialVersionUID = 1L;

        public void terminate(ScopeInstance scope) {
        }
    };
    public static final ScopeState EXITED = new EndedState("exited", 18);

    private EndedState(String name, int code) {
        super(name, code);
    }

    public static void enterCompleted(ScopeInstance scope) {
        scope.setState(COMPLETED);
        scope.close();
    }

    public static void enterFaulted(ScopeInstance scope) {
        scope.setState(FAULTED);
        scope.getToken().end(false);
        ScopeInstance parentInstance = scope.getParent();
        if (parentInstance != null) {
            parentInstance.faulted(scope.getFaultInstance());
        }
    }

    public static void enterCompensated(ScopeInstance scope) {
        scope.setState(COMPENSATED);
        scope.getCompensator().scopeCompensated(scope);
    }

    public static void enterTerminated(ScopeInstance scope) {
        scope.setState(TERMINATED);
        ScopeInstance parent = scope.getParent();
        if (parent != null) {
            parent.scopeTerminated(scope);
        }
    }

    public static void enterExited(ScopeInstance scope) {
        scope.setState(EXITED);
        scope.close();
    }
}

