/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.ant;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class DeployProcessTask
extends Task {
    private String processfile;
    private String host = "localhost";
    private int port = 8080;
    private String context = "/jbpm-bpel/deploy";

    public void execute() throws BuildException {
        String processLocation = this.formatProcessLocation();
        URL deployUrl = this.formatDeployRequest(processLocation);
        try {
            this.connectTo(deployUrl);
        }
        catch (IOException e) {
            this.log(e.getMessage(), 0);
            throw new BuildException("cannot connect to deployment url", (Throwable)e);
        }
    }

    public void setProcessfile(String processfile) {
        this.processfile = processfile;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setContext(String context) {
        this.context = context;
    }

    private String formatProcessLocation() {
        File processFile = new File(this.processfile);
        if (!processFile.exists()) {
            throw new BuildException("process file not found: " + this.processfile);
        }
        URI processUri = processFile.toURI();
        try {
            processUri = new URI(processUri.getScheme(), "", processUri.getPath(), null);
            String processLocation = processUri.toString();
            this.log("process location: " + processLocation);
            return processLocation;
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    private URL formatDeployRequest(String processLocation) {
        String file;
        try {
            file = this.context + "?processfile=" + URLEncoder.encode(processLocation, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
        try {
            URL deployUrl = new URL("http", this.host, this.port, file);
            this.log("deployment url: " + deployUrl);
            return deployUrl;
        }
        catch (MalformedURLException e) {
            this.log(e.getMessage(), 0);
            throw new BuildException("cannot format a valid url from the given host, port and context");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectTo(URL deployUrl) throws IOException {
        HttpURLConnection httpConnection = (HttpURLConnection)deployUrl.openConnection();
        try {
            httpConnection.connect();
            int responseCode = httpConnection.getResponseCode();
            this.log("got response code: " + responseCode);
            if (responseCode != 200) {
                throw new BuildException("deployment failed; see details in the server console");
            }
        }
        finally {
            httpConnection.disconnect();
        }
    }
}

