/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.Iterator;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.Index;
import org.hibernate.util.StringHelper;

public class UniqueKey
extends Constraint {
    public String sqlConstraintString(Dialect dialect) {
        StringBuffer buf = new StringBuffer("unique (");
        Iterator iter = this.getColumnIterator();
        while (iter.hasNext()) {
            buf.append(((Column)iter.next()).getQuotedName(dialect));
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        return buf.append(')').toString();
    }

    public String sqlConstraintString(Dialect dialect, String constraintName, String defaultCatalog, String defaultSchema) {
        StringBuffer buf = new StringBuffer(dialect.getAddPrimaryKeyConstraintString(constraintName)).append('(');
        Iterator iter = this.getColumnIterator();
        while (iter.hasNext()) {
            buf.append(((Column)iter.next()).getQuotedName(dialect));
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        return StringHelper.replace(buf.append(')').toString(), "primary key", "unique");
    }

    public String sqlCreateString(Dialect dialect, Mapping p, String defaultCatalog, String defaultSchema) {
        if (dialect.supportsUniqueConstraintInCreateAlterTable()) {
            return super.sqlCreateString(dialect, p, defaultCatalog, defaultSchema);
        }
        return Index.buildSqlCreateIndexString(dialect, this.getName(), this.getTable(), this.getColumnIterator(), true, defaultCatalog, defaultSchema);
    }

    public String sqlDropString(Dialect dialect, String defaultCatalog, String defaultSchema) {
        if (dialect.supportsUniqueConstraintInCreateAlterTable()) {
            return super.sqlDropString(dialect, defaultCatalog, defaultSchema);
        }
        return Index.buildSqlDropIndexString(dialect, this.getTable(), this.getName(), defaultCatalog, defaultSchema);
    }
}

