/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.util;

import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.jboss.seam.util.EJB;
import org.jboss.seam.util.Naming;

public class Transactions {
    private static String userTransactionName = "UserTransaction";
    private static final String STANDARD_USER_TRANSACTION_NAME = "java:comp/UserTransaction";

    public static void setTransactionRollbackOnly() throws SystemException, NamingException {
        try {
            Transactions.setUTRollbackOnly();
        }
        catch (NameNotFoundException ne) {
            Transactions.setEJBCRollbackOnly();
        }
    }

    public static boolean isTransactionActive() throws SystemException, NamingException {
        try {
            return Transactions.isUTTransactionActive();
        }
        catch (NameNotFoundException ne) {
            return Transactions.isEJBCTransactionActive();
        }
        catch (IllegalStateException ise) {
            return Transactions.isEJBCTransactionActive();
        }
    }

    public static boolean isTransactionActiveOrMarkedRollback() throws SystemException, NamingException {
        try {
            return Transactions.isUTTransactionActiveOrMarkedRollback();
        }
        catch (NameNotFoundException ne) {
            return Transactions.isEJBCTransactionActiveOrMarkedRollback();
        }
        catch (IllegalStateException ise) {
            return Transactions.isEJBCTransactionActiveOrMarkedRollback();
        }
    }

    public static boolean isTransactionMarkedRollback() throws SystemException, NamingException {
        try {
            return Transactions.isUTTransactionMarkedRollback();
        }
        catch (NameNotFoundException ne) {
            return Transactions.isEJBCTransactionMarkedRollback();
        }
        catch (IllegalStateException ise) {
            return Transactions.isEJBCTransactionMarkedRollback();
        }
    }

    private static void setEJBCRollbackOnly() throws NamingException {
        EJB.getEJBContext().setRollbackOnly();
    }

    private static void setUTRollbackOnly() throws SystemException, NamingException {
        Transactions.getUserTransaction().setRollbackOnly();
    }

    private static boolean isEJBCTransactionActive() throws NamingException {
        try {
            return !EJB.getEJBContext().getRollbackOnly();
        }
        catch (IllegalStateException ise) {
            return false;
        }
    }

    private static boolean isUTTransactionActive() throws SystemException, NamingException {
        return Transactions.getUserTransaction().getStatus() == 0;
    }

    private static boolean isEJBCTransactionActiveOrMarkedRollback() throws NamingException {
        try {
            EJB.getEJBContext().getRollbackOnly();
            return true;
        }
        catch (IllegalStateException ise) {
            return false;
        }
    }

    private static boolean isUTTransactionActiveOrMarkedRollback() throws SystemException, NamingException {
        int status = Transactions.getUserTransaction().getStatus();
        return status == 0 || status == 1;
    }

    private static boolean isEJBCTransactionMarkedRollback() throws NamingException {
        try {
            return EJB.getEJBContext().getRollbackOnly();
        }
        catch (IllegalStateException ise) {
            return false;
        }
    }

    private static boolean isUTTransactionMarkedRollback() throws SystemException, NamingException {
        return Transactions.getUserTransaction().getStatus() == 1;
    }

    public static UserTransaction getUserTransaction() throws NamingException {
        try {
            try {
                return (UserTransaction)Naming.getInitialContext().lookup(userTransactionName);
            }
            catch (NameNotFoundException nnfe) {
                return (UserTransaction)Naming.getInitialContext().lookup(STANDARD_USER_TRANSACTION_NAME);
            }
        }
        catch (IllegalStateException ise) {
            throw new NameNotFoundException("Lookup " + userTransactionName + " threw IllegalStateException: " + ise.getMessage());
        }
    }

    private Transactions() {
    }

    public static void setUserTransactionName(String userTransactionName) {
        Transactions.userTransactionName = userTransactionName;
    }

    public static String getUserTransactionName() {
        return userTransactionName;
    }
}

