/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.theme;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.core.Interpolator;
import org.jboss.seam.theme.ThemeSelector;

@Scope(value=ScopeType.SESSION)
@Intercept(value=InterceptionType.NEVER)
@Name(value="org.jboss.seam.theme.theme")
@Install(precedence=0)
public class Theme
implements Serializable {
    private static final long serialVersionUID = -7003055918970882103L;
    private transient Map messages;

    private void init() {
        final ResourceBundle bundle = ThemeSelector.instance().getThemeResourceBundle();
        if (bundle != null) {
            this.messages = new AbstractMap<String, String>(){

                @Override
                public String get(Object key) {
                    if (key instanceof String) {
                        String resource;
                        String resourceKey = (String)key;
                        try {
                            resource = bundle.getString(resourceKey);
                        }
                        catch (MissingResourceException mre) {
                            return resourceKey;
                        }
                        if (resource == null) {
                            return resourceKey;
                        }
                        return Interpolator.instance().interpolate(resource, new Object[0]);
                    }
                    return null;
                }

                @Override
                public Set<Map.Entry<String, String>> entrySet() {
                    Enumeration<String> keys = bundle.getKeys();
                    HashMap<String, String> map = new HashMap<String, String>();
                    while (keys.hasMoreElements()) {
                        String key = keys.nextElement();
                        map.put(key, this.get(key));
                    }
                    return map.entrySet();
                }
            };
        }
    }

    @Unwrap
    public Map getTheme() {
        if (this.messages == null) {
            this.init();
        }
        return this.messages;
    }

    public static Map instance() {
        return (Map)Component.getInstance(Theme.class, true);
    }
}

