/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mail;

import java.io.Serializable;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.naming.NamingException;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.core.AbstractMutable;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.util.Naming;

@Name(value="org.jboss.seam.mail.mailSession")
@Install(precedence=0, classDependencies={"javax.mail.Session"})
@Scope(value=ScopeType.APPLICATION)
@Intercept(value=InterceptionType.NEVER)
public class MailSession
extends AbstractMutable
implements Serializable {
    private static final LogProvider log = Logging.getLogProvider(MailSession.class);
    private Session session;
    private String host = "localhost";
    private Integer port = 25;
    private String username;
    private String password;
    private boolean debug = false;
    private String sessionJndiName;

    @Unwrap
    public Session getSession() throws NamingException {
        if (this.session == null) {
            return (Session)Naming.getInitialContext().lookup(this.getSessionJndiName());
        }
        return this.session;
    }

    @Create
    public void create() {
        if (this.getSessionJndiName() == null) {
            this.createSession();
        }
    }

    private void createSession() {
        log.info("Creating JavaMail Session (" + this.getHost() + ':' + this.getPort() + ")");
        Properties properties = new Properties();
        properties.put("mail.debug", (Object)this.isDebug());
        if (this.getHost() != null) {
            properties.put("mail.host", this.getHost());
        }
        if (this.getPort() != null) {
            properties.put("mail.smtp.port", this.getPort().toString());
        }
        if (this.getUsername() != null && this.getPassword() == null) {
            log.warn("username supplied without a password (if an empty password is required supply an empty string)");
        }
        if (this.getUsername() == null && this.getPassword() != null) {
            log.warn("password supplied without a username (if no authentication required supply neither)");
        }
        Authenticator authenticator = null;
        if (this.getUsername() != null && this.getPassword() != null) {
            properties.put("mail.smtp.auth", "true");
            authenticator = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(MailSession.this.getUsername(), MailSession.this.getPassword());
                }
            };
        }
        properties.put("mail.smtp.starttls.enable", "true");
        this.session = Session.getInstance((Properties)properties, authenticator);
        this.session.setDebug(this.isDebug());
        log.info("connected to mail server");
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getSessionJndiName() {
        return this.sessionJndiName;
    }

    public void setSessionJndiName(String jndiName) {
        this.sessionJndiName = jndiName;
    }

    public static Session instance() {
        return (Session)Component.getInstance(MailSession.class);
    }
}

