/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jsf;

import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Exceptions;
import org.jboss.seam.core.FacesMessages;
import org.jboss.seam.jsf.AbstractSeamPhaseListener;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

public class SeamPhaseListener
extends AbstractSeamPhaseListener {
    private static final long serialVersionUID = -9127555729455066493L;
    private static final LogProvider log = Logging.getLogProvider(SeamPhaseListener.class);

    public void beforePhase(PhaseEvent event) {
        log.trace("before phase: " + event.getPhaseId());
        Lifecycle.setPhaseId(event.getPhaseId());
        try {
            this.handleTransactionsBeforePhase(event);
            if (event.getPhaseId() == PhaseId.RESTORE_VIEW) {
                Lifecycle.beginRequest(event.getFacesContext().getExternalContext());
            } else if (event.getPhaseId() == PhaseId.RENDER_RESPONSE) {
                this.beforeRender(event);
            } else if (event.getPhaseId() == PhaseId.APPLY_REQUEST_VALUES) {
                this.beforeUpdateModelValues(event);
            }
            super.beforePhase(event);
        }
        catch (Exception e) {
            log.error("uncaught exception", e);
            try {
                Exceptions.instance().handle(e);
            }
            catch (Exception ehe) {
                log.error("swallowing exception", e);
            }
        }
    }

    public void afterPhase(PhaseEvent event) {
        log.trace("after phase: " + event.getPhaseId());
        try {
            super.afterPhase(event);
            FacesContext facesContext = event.getFacesContext();
            if (event.getPhaseId() == PhaseId.RESTORE_VIEW) {
                this.afterRestoreView(facesContext);
            } else if (event.getPhaseId() == PhaseId.INVOKE_APPLICATION) {
                this.afterInvokeApplication();
            } else if (event.getPhaseId() == PhaseId.PROCESS_VALIDATIONS) {
                this.afterProcessValidations(event.getFacesContext());
            }
            FacesMessages.afterPhase();
            this.handleTransactionsAfterPhase(event);
            if (event.getPhaseId() == PhaseId.RENDER_RESPONSE) {
                this.afterRender(facesContext);
            } else if (facesContext.getResponseComplete()) {
                this.afterResponseComplete(facesContext);
            }
        }
        catch (Exception e) {
            log.error("uncaught exception", e);
            try {
                Exceptions.instance().handle(e);
            }
            catch (Exception ehe) {
                log.error("swallowing exception", e);
            }
        }
        Lifecycle.setPhaseId(null);
    }

    protected void handleTransactionsAfterPhase(PhaseEvent event) {
    }

    protected void handleTransactionsBeforePhase(PhaseEvent event) {
    }
}

