/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.interceptors;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.seam.InterceptorType;
import org.jboss.seam.annotations.AroundInvoke;
import org.jboss.seam.annotations.Interceptor;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.interceptors.AbstractInterceptor;

@Interceptor(type=InterceptorType.CLIENT)
public class SynchronizationInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = -4173880108889358566L;
    private ReentrantLock lock = new ReentrantLock(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public synchronized Object aroundInvoke(InvocationContext invocation) throws Exception {
        if (this.lock.tryLock(this.getComponent().getTimeout(), TimeUnit.MILLISECONDS)) {
            try {
                Object object = invocation.proceed();
                return object;
            }
            finally {
                this.lock.unlock();
            }
        }
        throw new IllegalStateException("could not acquire lock on @Synchronized component: " + this.getComponent().getName());
    }
}

