/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.EJBException;
import javax.ejb.Remove;
import javax.ejb.SessionSynchronization;
import javax.ejb.Stateful;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Events;
import org.jboss.seam.core.LocalTransactionListener;

@Stateful
@Scope(value=ScopeType.EVENT)
@Name(value="org.jboss.seam.core.transactionListener")
@Install(value=false, precedence=0)
public class TransactionListener
implements LocalTransactionListener,
SessionSynchronization {
    private List<Event> events = new ArrayList<Event>();

    public static LocalTransactionListener instance() {
        if (!Contexts.isEventContextActive()) {
            throw new IllegalStateException("no event context active");
        }
        return (LocalTransactionListener)Component.getInstance(TransactionListener.class, ScopeType.EVENT);
    }

    public void afterBegin() throws EJBException, RemoteException {
    }

    public void scheduleEvent(String type, Object ... parameters) {
        this.events.add(new Event(type, parameters));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(boolean success) throws EJBException, RemoteException {
        try {
            if (success) {
                for (Event event : this.events) {
                    event.call();
                }
            }
        }
        finally {
            this.events.clear();
        }
    }

    public void beforeCompletion() throws EJBException, RemoteException {
    }

    @Remove
    @Destroy
    public void destroy() {
    }

    static class Event {
        private String type;
        private Object[] parameters;

        public Event(String type, Object[] parameters) {
            this.type = type;
            this.parameters = parameters;
        }

        public void call() {
            Events.instance().raiseEvent(this.type, this.parameters);
        }
    }
}

