/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.util.TimeZone;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Events;
import org.jboss.seam.core.Selector;

@Scope(value=ScopeType.SESSION)
@Name(value="org.jboss.seam.core.timeZoneSelector")
@Intercept(value=InterceptionType.NEVER)
@Install(value=false, precedence=0)
public class TimeZoneSelector
extends Selector {
    private static final long serialVersionUID = -5013819375360015369L;
    private String id;

    @Create
    public void initTimeZone() {
        String timeZoneId = this.getCookieValue();
        if (timeZoneId != null) {
            this.setTimeZoneId(timeZoneId);
        }
    }

    protected String getCookieName() {
        return "org.jboss.seam.core.TimeZone";
    }

    public void select() {
        this.setCookieValue(this.getTimeZoneId());
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.timeZoneSelected", this.getTimeZoneId());
        }
    }

    public void setTimeZone(TimeZone timeZone) {
        this.setTimeZoneId(timeZone.getID());
    }

    public void setTimeZoneId(String id) {
        this.setDirty(this.id, id);
        this.id = id;
    }

    public String getTimeZoneId() {
        return this.id;
    }

    public TimeZone getTimeZone() {
        if (this.id == null) {
            return TimeZone.getDefault();
        }
        return TimeZone.getTimeZone(this.getTimeZoneId());
    }

    public static TimeZoneSelector instance() {
        if (!Contexts.isSessionContextActive()) {
            throw new IllegalStateException("No active session context");
        }
        return (TimeZoneSelector)Component.getInstance(TimeZoneSelector.class, ScopeType.SESSION);
    }
}

