/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.Serializable;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.PerNestedConversation;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.AbstractMutable;
import org.jboss.seam.core.Events;
import org.jboss.seam.core.FacesMessages;
import org.jboss.seam.core.FacesPage;
import org.jboss.seam.core.Jbpm;
import org.jboss.seam.core.Manager;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.pageflow.Page;
import org.jboss.seam.pageflow.PageflowHelper;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.Event;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;

@Scope(value=ScopeType.CONVERSATION)
@PerNestedConversation
@Name(value="org.jboss.seam.core.pageflow")
@Intercept(value=InterceptionType.NEVER)
@Install(dependencies={"org.jboss.seam.core.jbpm"}, precedence=0)
public class Pageflow
extends AbstractMutable
implements Serializable {
    private static final long serialVersionUID = -2337682140346213333L;
    private static final LogProvider log = Logging.getLogProvider(Pageflow.class);
    private int counter;
    private ProcessInstance processInstance;

    public boolean isInProcess() {
        return this.processInstance != null;
    }

    public ProcessInstance getProcessInstance() {
        return this.processInstance;
    }

    public void setProcessInstance(ProcessInstance processInstance) {
        this.processInstance = processInstance;
        this.setDirty();
    }

    public static Pageflow instance() {
        if (!Contexts.isConversationContextActive()) {
            throw new IllegalStateException("No active conversation context");
        }
        return (Pageflow)Component.getInstance(Pageflow.class, ScopeType.CONVERSATION);
    }

    public int getPageflowCounter() {
        return this.counter;
    }

    public void validatePageflow() {
        if (this.processInstance != null) {
            boolean canReposition;
            FacesPage page = FacesPage.instance();
            String pageflowName = page.getPageflowName();
            String pageflowNodeName = page.getPageflowNodeName();
            boolean bl = canReposition = this.getPage().isBackEnabled() && this.processInstance.getProcessDefinition().getName().equals(pageflowName) && pageflowNodeName != null;
            if (canReposition) {
                if (!pageflowNodeName.equals(this.getNode().getName())) {
                    this.reposition(pageflowNodeName);
                }
            } else {
                Integer pageCounter = FacesPage.instance().getPageflowCounter();
                if (pageCounter != null && this.getPageflowCounter() != pageCounter.intValue()) {
                    this.illegalNavigationError();
                }
            }
        }
    }

    private void illegalNavigationError() {
        FacesContext context = FacesContext.getCurrentInstance();
        this.navigate(context);
        this.illegalNavigation();
        context.renderResponse();
    }

    protected void illegalNavigation() {
        FacesMessages.instance().addFromResourceBundleOrDefault(FacesMessage.SEVERITY_WARN, "org.jboss.seam.IllegalNavigation", "Illegal navigation", new Object[0]);
    }

    public Node getNode() {
        if (this.processInstance == null) {
            return null;
        }
        Token pageFlowToken = this.processInstance.getRootToken();
        Node node = pageFlowToken.getNode();
        if (node == null) {
            throw new IllegalStateException("pageflow has not yet started");
        }
        return node;
    }

    public void reposition(String nodeName) {
        if (this.processInstance == null) {
            throw new IllegalStateException("no pageflow in progress");
        }
        Node node = this.processInstance.getProcessDefinition().getNode(nodeName);
        if (node == null) {
            throw new IllegalArgumentException("no node named: " + nodeName + " for pageflow: " + this.processInstance.getProcessDefinition().getName());
        }
        this.processInstance.getRootToken().setNode(node);
        this.setDirty();
    }

    public Page getPage() {
        Node node = this.getNode();
        if (!(node instanceof Page)) {
            throw new IllegalStateException("pageflow is not currently at a <page> or <start-page> node (note that pageflows that begin during the RENDER_RESPONSE phase should use <start-page> instead of <start-state>)");
        }
        return (Page)node;
    }

    protected void navigate(FacesContext context) {
        Page page = this.getPage();
        if (!page.isRedirect()) {
            this.render(context, page);
        } else {
            this.redirect(page);
        }
        ++this.counter;
        this.setDirty();
    }

    protected void redirect(Page page) {
        Manager.instance().redirect(this.getViewId(page));
    }

    protected void render(FacesContext context, Page page) {
        UIViewRoot viewRoot = context.getApplication().getViewHandler().createView(context, this.getViewId(page));
        context.setViewRoot(viewRoot);
    }

    protected String getViewId(Page page) {
        return page.getViewId();
    }

    public String getPageViewId() {
        return this.getViewId(this.getPage());
    }

    public boolean hasDefaultTransition() {
        return this.getNode().getLeavingTransition(null) != null;
    }

    private boolean isNullOutcome(String outcome) {
        return outcome == null || "".equals(outcome);
    }

    public boolean hasTransition(String outcome) {
        return this.isNullOutcome(outcome) ? this.hasDefaultTransition() : this.getNode().getLeavingTransition(outcome) != null;
    }

    public void navigate(FacesContext context, String outcome) {
        if (this.isNullOutcome(outcome)) {
            if (this.hasDefaultTransition()) {
                PageflowHelper.signal(this.processInstance, null);
                this.navigate(context);
            }
        } else {
            PageflowHelper.signal(this.processInstance, outcome);
            this.navigate(context);
        }
        if (this.processInstance.hasEnded()) {
            Events.instance().raiseEvent("org.jboss.seam.endPageflow." + this.processInstance.getProcessDefinition().getName(), new Object[0]);
        }
    }

    public void processEvents(String type) {
        Event event = this.getNode().getEvent(type);
        if (event != null) {
            for (Action action : event.getActions()) {
                try {
                    action.execute(ExecutionContext.currentExecutionContext());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public void begin(String pageflowDefinitionName) {
        if (log.isDebugEnabled()) {
            log.debug("beginning pageflow: " + pageflowDefinitionName);
        }
        this.processInstance = PageflowHelper.newPageflowInstance(this.getPageflowProcessDefinition(pageflowDefinitionName));
        this.setDirty();
        Events.instance().raiseEvent("org.jboss.seam.beginPageflow." + pageflowDefinitionName, new Object[0]);
        this.storePageflowToViewRootIfNecessary();
    }

    private void storePageflowToViewRootIfNecessary() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && Lifecycle.getPhaseId() == PhaseId.RENDER_RESPONSE) {
            FacesPage.instance().storePageflow();
        }
    }

    public String getNoConversationViewId(String pageflowName, String pageflowNodeName) {
        ProcessDefinition pageflowProcessDefinition = this.getPageflowProcessDefinition(pageflowName);
        Node node = pageflowProcessDefinition.getNode(pageflowNodeName);
        if (node != null && node instanceof Page) {
            return ((Page)node).getNoConversationViewId();
        }
        return null;
    }

    protected ProcessDefinition getPageflowProcessDefinition(String pageflowName) {
        ProcessDefinition pageflowProcessDefinition = Jbpm.instance().getPageflowProcessDefinition(pageflowName);
        if (pageflowProcessDefinition == null) {
            throw new IllegalArgumentException("pageflow definition not found: " + pageflowName);
        }
        return pageflowProcessDefinition;
    }

    public String toString() {
        String name = this.processInstance == null ? "null" : this.processInstance.getProcessDefinition().getName();
        return "Pageflow(" + name + ")";
    }
}

