/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.captcha;

import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.image.DefaultManageableImageCaptchaService;
import com.octo.captcha.service.image.ImageCaptchaService;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.servlet.AbstractResource;

@Startup
@Scope(value=ScopeType.APPLICATION)
@Name(value="org.jboss.seam.captcha.captchaImage")
@Intercept(value=InterceptionType.NEVER)
@Install(precedence=0, classDependencies={"com.octo.captcha.service.image.ImageCaptchaService"})
public class CaptchaImage
extends AbstractResource {
    private ImageCaptchaService service;

    public static CaptchaImage instance() {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("No application context active");
        }
        return (CaptchaImage)Contexts.getApplicationContext().get(CaptchaImage.class);
    }

    public boolean validateResponse(String id, String response) {
        try {
            return this.service.validateResponseForID(id, (Object)response);
        }
        catch (CaptchaServiceException cse) {
            return false;
        }
    }

    @Create
    public void create() {
        this.service = new DefaultManageableImageCaptchaService();
    }

    protected String getResourcePath() {
        return "/captcha";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getResource(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Lifecycle.beginRequest(this.getServletContext(), request.getSession(), (ServletRequest)request);
            String captchaId = request.getQueryString();
            BufferedImage challenge = this.service.getImageChallengeForID(captchaId, request.getLocale());
            ImageIO.write((RenderedImage)challenge, "jpeg", out);
        }
        catch (IllegalArgumentException e) {
            response.sendError(404);
            return;
        }
        catch (CaptchaServiceException e) {
            response.sendError(500);
            return;
        }
        finally {
            Lifecycle.endRequest();
        }
        response.setHeader("Cache-Control", "no-store");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setContentType("image/jpeg");
        response.getOutputStream().write(out.toByteArray());
        response.getOutputStream().flush();
        response.getOutputStream().close();
    }
}

