/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.captcha;

import java.io.Serializable;
import java.rmi.server.UID;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.captcha.CaptchaImage;
import org.jboss.seam.captcha.CaptchaResponse;
import org.jboss.seam.contexts.Contexts;

@Name(value="org.jboss.seam.captcha.captcha")
@Scope(value=ScopeType.PAGE)
@Install(dependencies={"org.jboss.seam.captcha.captchaImage"})
public class Captcha
implements Serializable {
    private String id;
    private transient String response;

    @Create
    public void init() {
        this.id = new UID().toString().replace(":", "-");
    }

    boolean validateResponse(String response) {
        boolean valid = CaptchaImage.instance().validateResponse(this.id, response);
        if (!valid) {
            this.init();
        }
        return valid;
    }

    @CaptchaResponse
    public String getResponse() {
        return this.response;
    }

    public void setResponse(String input) {
        this.response = input;
    }

    public static Captcha instance() {
        if (!Contexts.isPageContextActive()) {
            throw new IllegalStateException("No page context active");
        }
        return (Captcha)Component.getInstance(Captcha.class, ScopeType.PAGE);
    }

    public String getId() {
        return this.id;
    }
}

