/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.samples.jpetstore.web.struts;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.samples.jpetstore.domain.Order;
import org.springframework.samples.jpetstore.web.struts.OrderActionForm;
import org.springframework.samples.jpetstore.web.struts.SecureBaseAction;

public class NewOrderAction
extends SecureBaseAction {
    protected ActionForward doExecute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OrderActionForm orderForm = (OrderActionForm)form;
        if (orderForm.isShippingAddressRequired()) {
            return mapping.findForward("shipping");
        }
        if (!orderForm.isConfirmed()) {
            return mapping.findForward("confirm");
        }
        if (orderForm.getOrder() != null) {
            Order order = orderForm.getOrder();
            this.getPetStore().insertOrder(order);
            request.getSession().removeAttribute("workingOrderForm");
            request.getSession().removeAttribute("cartForm");
            request.setAttribute("order", (Object)order);
            request.setAttribute("message", (Object)"Thank you, your order has been submitted.");
            return mapping.findForward("success");
        }
        request.setAttribute("message", (Object)"An error occurred processing your order (order was null).");
        return mapping.findForward("failure");
    }
}

