/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.samples.jpetstore.dao.ibatis;

import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;
import org.springframework.samples.jpetstore.dao.OrderDao;
import org.springframework.samples.jpetstore.dao.ibatis.SqlMapSequenceDao;
import org.springframework.samples.jpetstore.domain.LineItem;
import org.springframework.samples.jpetstore.domain.Order;

public class SqlMapOrderDao
extends SqlMapClientDaoSupport
implements OrderDao {
    private SqlMapSequenceDao sequenceDao;

    public void setSequenceDao(SqlMapSequenceDao sequenceDao) {
        this.sequenceDao = sequenceDao;
    }

    public List getOrdersByUsername(String username) throws DataAccessException {
        return this.getSqlMapClientTemplate().queryForList("getOrdersByUsername", (Object)username);
    }

    public Order getOrder(int orderId) throws DataAccessException {
        Integer parameterObject = new Integer(orderId);
        Order order = (Order)this.getSqlMapClientTemplate().queryForObject("getOrder", (Object)parameterObject);
        if (order != null) {
            order.setLineItems(this.getSqlMapClientTemplate().queryForList("getLineItemsByOrderId", (Object)new Integer(order.getOrderId())));
        }
        return order;
    }

    public void insertOrder(Order order) throws DataAccessException {
        order.setOrderId(this.sequenceDao.getNextId("ordernum"));
        this.getSqlMapClientTemplate().insert("insertOrder", (Object)order);
        this.getSqlMapClientTemplate().insert("insertOrderStatus", (Object)order);
        for (int i = 0; i < order.getLineItems().size(); ++i) {
            LineItem lineItem = (LineItem)order.getLineItems().get(i);
            lineItem.setOrderId(order.getOrderId());
            this.getSqlMapClientTemplate().insert("insertLineItem", (Object)lineItem);
        }
    }
}

