/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.samples.jpetstore.dao.ibatis;

import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;
import org.springframework.samples.jpetstore.dao.AccountDao;
import org.springframework.samples.jpetstore.domain.Account;

public class SqlMapAccountDao
extends SqlMapClientDaoSupport
implements AccountDao {
    public Account getAccount(String username) throws DataAccessException {
        return (Account)this.getSqlMapClientTemplate().queryForObject("getAccountByUsername", (Object)username);
    }

    public Account getAccount(String username, String password) throws DataAccessException {
        Account account = new Account();
        account.setUsername(username);
        account.setPassword(password);
        return (Account)this.getSqlMapClientTemplate().queryForObject("getAccountByUsernameAndPassword", (Object)account);
    }

    public void insertAccount(Account account) throws DataAccessException {
        this.getSqlMapClientTemplate().insert("insertAccount", (Object)account);
        this.getSqlMapClientTemplate().insert("insertProfile", (Object)account);
        this.getSqlMapClientTemplate().insert("insertSignon", (Object)account);
    }

    public void updateAccount(Account account) throws DataAccessException {
        this.getSqlMapClientTemplate().update("updateAccount", (Object)account, 1);
        this.getSqlMapClientTemplate().update("updateProfile", (Object)account, 1);
        if (account.getPassword() != null && account.getPassword().length() > 0) {
            this.getSqlMapClientTemplate().update("updateSignon", (Object)account, 1);
        }
    }

    public List getUsernameList() throws DataAccessException {
        return this.getSqlMapClientTemplate().queryForList("getUsernameList", null);
    }
}

