/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPCellEvent;
import java.awt.Color;

public class PdfPRow {
    public static final float BOTTOM_LIMIT = -1.0737418E9f;
    protected PdfPCell[] cells;
    protected float[] widths;
    protected float maxHeight = 0.0f;
    protected boolean calculated = false;
    private int[] canvasesPos;

    public PdfPRow(PdfPCell[] cells) {
        this.cells = cells;
        this.widths = new float[cells.length];
    }

    public PdfPRow(PdfPRow row) {
        this.maxHeight = row.maxHeight;
        this.calculated = row.calculated;
        this.cells = new PdfPCell[row.cells.length];
        int k = 0;
        while (k < this.cells.length) {
            if (row.cells[k] != null) {
                this.cells[k] = new PdfPCell(row.cells[k]);
            }
            ++k;
        }
        this.widths = new float[this.cells.length];
        System.arraycopy(row.widths, 0, this.widths, 0, this.cells.length);
    }

    public boolean setWidths(float[] widths) {
        if (widths.length != this.cells.length) {
            return false;
        }
        System.arraycopy(widths, 0, this.widths, 0, this.cells.length);
        float total = 0.0f;
        this.calculated = false;
        int k = 0;
        while (k < widths.length) {
            PdfPCell cell = this.cells[k];
            cell.setLeft(total);
            int last = k + cell.getColspan();
            while (k < last) {
                total += widths[k];
                ++k;
            }
            --k;
            cell.setRight(total);
            cell.setTop(0.0f);
            ++k;
        }
        return true;
    }

    public float calculateHeights() {
        this.maxHeight = 0.0f;
        int k = 0;
        while (k < this.cells.length) {
            PdfPCell cell = this.cells[k];
            if (cell != null) {
                Image img = cell.getImage();
                if (img != null) {
                    img.scalePercent(100.0f);
                    float refWidth = img.scaledWidth();
                    if (cell.getRotation() == 90 || cell.getRotation() == 270) {
                        refWidth = img.scaledHeight();
                    }
                    float scale = (cell.right() - cell.getEffectivePaddingRight() - cell.getEffectivePaddingLeft() - cell.left()) / refWidth;
                    img.scalePercent(scale * 100.0f);
                    float refHeight = img.scaledHeight();
                    if (cell.getRotation() == 90 || cell.getRotation() == 270) {
                        refHeight = img.scaledWidth();
                    }
                    cell.setBottom(cell.top() - cell.getEffectivePaddingTop() - cell.getEffectivePaddingBottom() - refHeight);
                } else if (cell.getRotation() == 0 || cell.getRotation() == 180) {
                    float rightLimit = cell.isNoWrap() ? 20000.0f : cell.right() - cell.getEffectivePaddingRight();
                    float bry = cell.getFixedHeight() > 0.0f ? cell.top() - cell.getEffectivePaddingTop() + cell.getEffectivePaddingBottom() - cell.getFixedHeight() : -1.0737418E9f;
                    ColumnText ct = ColumnText.duplicate(cell.getColumn());
                    this.setColumn(ct, cell.left() + cell.getEffectivePaddingLeft(), bry, rightLimit, cell.top() - cell.getEffectivePaddingTop());
                    try {
                        ct.go(true);
                    }
                    catch (DocumentException e) {
                        throw new ExceptionConverter(e);
                    }
                    float yLine = ct.getYLine();
                    if (cell.isUseDescender()) {
                        yLine += ct.getDescender();
                    }
                    cell.setBottom(yLine - cell.getEffectivePaddingBottom());
                } else if (cell.getFixedHeight() > 0.0f) {
                    cell.setBottom(cell.top() - cell.getFixedHeight());
                } else {
                    ColumnText ct = ColumnText.duplicate(cell.getColumn());
                    this.setColumn(ct, 0.0f, cell.left() + cell.getEffectivePaddingLeft(), 20000.0f, cell.right() - cell.getEffectivePaddingRight());
                    try {
                        ct.go(true);
                    }
                    catch (DocumentException e) {
                        throw new ExceptionConverter(e);
                    }
                    cell.setBottom(cell.top() - cell.getEffectivePaddingTop() - cell.getEffectivePaddingBottom() - ct.getFilledWidth());
                }
                float height = cell.getFixedHeight();
                if (height <= 0.0f) {
                    height = cell.height();
                }
                if (height < cell.getFixedHeight()) {
                    height = cell.getFixedHeight();
                } else if (height < cell.getMinimumHeight()) {
                    height = cell.getMinimumHeight();
                }
                if (height > this.maxHeight) {
                    this.maxHeight = height;
                }
            }
            ++k;
        }
        this.calculated = true;
        return this.maxHeight;
    }

    public void writeBorderAndBackground(float xPos, float yPos, PdfPCell cell, PdfContentByte[] canvases) {
        PdfContentByte lines = canvases[2];
        PdfContentByte backgr = canvases[1];
        float x1 = cell.left() + xPos;
        float y2 = cell.top() + yPos;
        float x2 = cell.right() + xPos;
        float y1 = y2 - this.maxHeight;
        Color background = cell.backgroundColor();
        if (background != null) {
            backgr.setColorFill(background);
            backgr.rectangle(x1, y1, x2 - x1, y2 - y1);
            backgr.fill();
        }
        if (cell.hasBorders()) {
            if (cell.isUseVariableBorders()) {
                Rectangle borderRect = new Rectangle(cell.left() + xPos, cell.top() - this.maxHeight + yPos, cell.right() + xPos, cell.top() + yPos);
                borderRect.cloneNonPositionParameters(cell);
                borderRect.setBackgroundColor(null);
                lines.rectangle(borderRect);
            } else {
                Color color;
                if (cell.borderWidth() != -1.0f) {
                    lines.setLineWidth(cell.borderWidth());
                }
                if ((color = cell.borderColor()) != null) {
                    lines.setColorStroke(color);
                }
                if (cell.hasBorder(15)) {
                    lines.rectangle(x1, y1, x2 - x1, y2 - y1);
                } else {
                    if (cell.hasBorder(8)) {
                        lines.moveTo(x2, y1);
                        lines.lineTo(x2, y2);
                    }
                    if (cell.hasBorder(4)) {
                        lines.moveTo(x1, y1);
                        lines.lineTo(x1, y2);
                    }
                    if (cell.hasBorder(2)) {
                        lines.moveTo(x1, y1);
                        lines.lineTo(x2, y1);
                    }
                    if (cell.hasBorder(1)) {
                        lines.moveTo(x1, y2);
                        lines.lineTo(x2, y2);
                    }
                }
                lines.stroke();
                if (color != null) {
                    lines.resetRGBColorStroke();
                }
            }
        }
    }

    private void saveAndRotateCanvases(PdfContentByte[] canvases, float a, float b, float c, float d, float e, float f) {
        int last = 4;
        if (this.canvasesPos == null) {
            this.canvasesPos = new int[last * 2];
        }
        int k = 0;
        while (k < last) {
            ByteBuffer bb = canvases[k].getInternalBuffer();
            this.canvasesPos[k * 2] = bb.size();
            canvases[k].saveState();
            canvases[k].concatCTM(a, b, c, d, e, f);
            this.canvasesPos[k * 2 + 1] = bb.size();
            ++k;
        }
    }

    private void restoreCanvases(PdfContentByte[] canvases) {
        int last = 4;
        int k = 0;
        while (k < last) {
            ByteBuffer bb = canvases[k].getInternalBuffer();
            int p1 = bb.size();
            canvases[k].restoreState();
            if (p1 == this.canvasesPos[k * 2 + 1]) {
                bb.setSize(this.canvasesPos[k * 2]);
            }
            ++k;
        }
    }

    private float setColumn(ColumnText ct, float llx, float lly, float urx, float ury) {
        if (llx > urx) {
            urx = llx;
        }
        if (lly > ury) {
            ury = lly;
        }
        ct.setSimpleColumn(llx, lly, urx, ury);
        return ury;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeCells(int colStart, int colEnd, float xPos, float yPos, PdfContentByte[] canvases) {
        if (!this.calculated) {
            this.calculateHeights();
        }
        if (colEnd < 0) {
            colEnd = this.cells.length;
        }
        colEnd = Math.min(colEnd, this.cells.length);
        if (colStart < 0) {
            colStart = 0;
        }
        if (colStart >= colEnd) {
            return;
        }
        int newStart = colStart;
        while (newStart >= 0 && this.cells[newStart] == null) {
            xPos -= this.widths[newStart - 1];
            --newStart;
        }
        xPos -= this.cells[newStart].left();
        int k = newStart;
        while (true) {
            block55: {
                PdfPCell cell;
                block54: {
                    float tly;
                    block56: {
                        Object var18_30;
                        float pivotX;
                        float pivotY;
                        if (k >= colEnd) {
                            return;
                        }
                        cell = this.cells[k];
                        if (cell == null) break block55;
                        this.writeBorderAndBackground(xPos, yPos, cell, canvases);
                        Image img = cell.getImage();
                        tly = 0.0f;
                        switch (cell.getVerticalAlignment()) {
                            case 6: {
                                tly = cell.top() + yPos - this.maxHeight + cell.height() - cell.getEffectivePaddingTop();
                                break;
                            }
                            case 5: {
                                tly = cell.top() + yPos + (cell.height() - this.maxHeight) / 2.0f - cell.getEffectivePaddingTop();
                                break;
                            }
                            default: {
                                tly = cell.top() + yPos - cell.getEffectivePaddingTop();
                            }
                        }
                        if (img != null) {
                            if (cell.getRotation() != 0) {
                                img = Image.getInstance(img);
                                img.setRotation(img.getImageRotation() + (float)((double)cell.getRotation() * Math.PI / 180.0));
                            }
                            boolean vf = false;
                            if (cell.height() > this.maxHeight) {
                                img.scalePercent(100.0f);
                                float scale = (this.maxHeight - cell.getEffectivePaddingTop() - cell.getEffectivePaddingBottom()) / img.scaledHeight();
                                img.scalePercent(scale * 100.0f);
                                vf = true;
                            }
                            float left = cell.left() + xPos + cell.getEffectivePaddingLeft();
                            if (vf) {
                                switch (cell.getHorizontalAlignment()) {
                                    case 1: {
                                        left = xPos + (cell.left() + cell.getEffectivePaddingLeft() + cell.right() - cell.getEffectivePaddingRight() - img.scaledWidth()) / 2.0f;
                                        break;
                                    }
                                    case 2: {
                                        left = xPos + cell.right() - cell.getEffectivePaddingRight() - img.scaledWidth();
                                        break;
                                    }
                                }
                                tly = cell.top() + yPos - cell.getEffectivePaddingTop();
                            }
                            img.setAbsolutePosition(left, tly - img.scaledHeight());
                            try {
                                canvases[3].addImage(img);
                            }
                            catch (DocumentException e) {
                                throw new ExceptionConverter(e);
                            }
                        }
                        if (cell.getRotation() != 90 && cell.getRotation() != 270) break block56;
                        float netWidth = this.maxHeight - cell.getEffectivePaddingTop() - cell.getEffectivePaddingBottom();
                        float netHeight = cell.width() - cell.getEffectivePaddingLeft() - cell.getEffectivePaddingRight();
                        ColumnText ct = ColumnText.duplicate(cell.getColumn());
                        ct.setCanvases(canvases);
                        ct.setSimpleColumn(0.0f, 0.0f, netWidth + 0.001f, -netHeight);
                        try {
                            ct.go(true);
                        }
                        catch (DocumentException e) {
                            throw new ExceptionConverter(e);
                        }
                        float calcHeight = -ct.getYLine();
                        if (netWidth <= 0.0f || netHeight <= 0.0f) {
                            calcHeight = 0.0f;
                        }
                        if (!(calcHeight > 0.0f)) break block54;
                        if (cell.isUseDescender()) {
                            calcHeight -= ct.getDescender();
                        }
                        ct = ColumnText.duplicate(cell.getColumn());
                        ct.setCanvases(canvases);
                        ct.setSimpleColumn(0.0f, -0.001f, netWidth + 0.001f, calcHeight);
                        if (cell.getRotation() == 90) {
                            pivotY = cell.top() + yPos - this.maxHeight + cell.getEffectivePaddingBottom();
                            switch (cell.getVerticalAlignment()) {
                                case 6: {
                                    pivotX = cell.left() + xPos + cell.width() - cell.getEffectivePaddingRight();
                                    break;
                                }
                                case 5: {
                                    pivotX = cell.left() + xPos + (cell.width() + cell.getEffectivePaddingLeft() - cell.getEffectivePaddingRight() + calcHeight) / 2.0f;
                                    break;
                                }
                                default: {
                                    pivotX = cell.left() + xPos + cell.getEffectivePaddingLeft() + calcHeight;
                                }
                            }
                            this.saveAndRotateCanvases(canvases, 0.0f, 1.0f, -1.0f, 0.0f, pivotX, pivotY);
                        } else {
                            pivotY = cell.top() + yPos - cell.getEffectivePaddingTop();
                            switch (cell.getVerticalAlignment()) {
                                case 6: {
                                    pivotX = cell.left() + xPos + cell.getEffectivePaddingLeft();
                                    break;
                                }
                                case 5: {
                                    pivotX = cell.left() + xPos + (cell.width() + cell.getEffectivePaddingLeft() - cell.getEffectivePaddingRight() - calcHeight) / 2.0f;
                                    break;
                                }
                                default: {
                                    pivotX = cell.left() + xPos + cell.width() - cell.getEffectivePaddingRight() - calcHeight;
                                }
                            }
                            this.saveAndRotateCanvases(canvases, 0.0f, -1.0f, 1.0f, 0.0f, pivotX, pivotY);
                        }
                        try {
                            try {
                                ct.go();
                            }
                            catch (DocumentException e) {
                                throw new ExceptionConverter(e);
                            }
                        }
                        catch (Throwable throwable) {
                            var18_30 = null;
                            this.restoreCanvases(canvases);
                            throw throwable;
                        }
                        {
                            var18_30 = null;
                            this.restoreCanvases(canvases);
                            break block54;
                        }
                    }
                    float fixedHeight = cell.getFixedHeight();
                    float rightLimit = cell.right() + xPos - cell.getEffectivePaddingRight();
                    float leftLimit = cell.left() + xPos + cell.getEffectivePaddingLeft();
                    if (cell.isNoWrap()) {
                        switch (cell.getHorizontalAlignment()) {
                            case 1: {
                                rightLimit += 10000.0f;
                                leftLimit -= 10000.0f;
                                break;
                            }
                            case 2: {
                                leftLimit -= 20000.0f;
                                break;
                            }
                            default: {
                                rightLimit += 20000.0f;
                            }
                        }
                    }
                    ColumnText ct = ColumnText.duplicate(cell.getColumn());
                    ct.setCanvases(canvases);
                    float bry = tly - (this.maxHeight - cell.getEffectivePaddingTop() - cell.getEffectivePaddingBottom());
                    if (fixedHeight > 0.0f && cell.height() > this.maxHeight) {
                        tly = cell.top() + yPos - cell.getEffectivePaddingTop();
                        bry = cell.top() + yPos - this.maxHeight + cell.getEffectivePaddingBottom();
                    }
                    if (!(tly > bry) && !ct.zeroHeightElement() || !(leftLimit < rightLimit)) break block54;
                    ct.setSimpleColumn(leftLimit, bry - 0.001f, rightLimit, tly);
                    if (cell.getRotation() == 180) {
                        float shx = leftLimit + rightLimit;
                        float shy = yPos + yPos - this.maxHeight + cell.getEffectivePaddingBottom() - cell.getEffectivePaddingTop();
                        this.saveAndRotateCanvases(canvases, -1.0f, 0.0f, 0.0f, -1.0f, shx, shy);
                    }
                    try {
                        try {
                            ct.go();
                        }
                        catch (DocumentException e) {
                            throw new ExceptionConverter(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var17_29 = null;
                        if (cell.getRotation() == 180) {
                            this.restoreCanvases(canvases);
                        }
                        throw throwable;
                    }
                    {
                        Object var17_26 = null;
                        if (cell.getRotation() != 180) break block54;
                        this.restoreCanvases(canvases);
                    }
                }
                PdfPCellEvent evt = cell.getCellEvent();
                if (evt != null) {
                    Rectangle rect = new Rectangle(cell.left() + xPos, cell.top() + yPos - this.maxHeight, cell.right() + xPos, cell.top() + yPos);
                    evt.cellLayout(cell, rect, canvases);
                }
            }
            ++k;
        }
    }

    public boolean isCalculated() {
        return this.calculated;
    }

    public float getMaxHeights() {
        if (this.calculated) {
            return this.maxHeight;
        }
        return this.calculateHeights();
    }

    public void setMaxHeights(float maxHeight) {
        this.maxHeight = maxHeight;
    }

    float[] getEventWidth(float xPos) {
        int n = 0;
        int k = 0;
        while (k < this.cells.length) {
            if (this.cells[k] != null) {
                ++n;
            }
            ++k;
        }
        float[] width = new float[n + 1];
        n = 0;
        width[n++] = xPos;
        int k2 = 0;
        while (k2 < this.cells.length) {
            if (this.cells[k2] != null) {
                width[n] = width[n - 1] + this.cells[k2].width();
                ++n;
            }
            ++k2;
        }
        return width;
    }

    public PdfPRow splitRow(float newHeight) {
        PdfPCell cell;
        PdfPCell[] newCells = new PdfPCell[this.cells.length];
        float[] fh = new float[this.cells.length * 2];
        boolean allEmpty = true;
        int k = 0;
        while (k < this.cells.length) {
            cell = this.cells[k];
            if (cell != null) {
                fh[k * 2] = cell.getFixedHeight();
                fh[k * 2 + 1] = cell.getMinimumHeight();
                Image img = cell.getImage();
                PdfPCell c2 = new PdfPCell(cell);
                if (img != null) {
                    if (newHeight > cell.getEffectivePaddingBottom() + cell.getEffectivePaddingTop() + 2.0f) {
                        c2.setPhrase(null);
                        allEmpty = false;
                    }
                } else {
                    boolean thisEmpty;
                    int status;
                    float y;
                    ColumnText ct = ColumnText.duplicate(cell.getColumn());
                    if (cell.getRotation() == 90 || cell.getRotation() == 270) {
                        y = this.setColumn(ct, cell.top() - newHeight + cell.getEffectivePaddingBottom(), cell.left() + cell.getEffectivePaddingLeft(), cell.top() - cell.getEffectivePaddingTop(), cell.right() - cell.getEffectivePaddingRight());
                    } else {
                        float rightLimit = cell.isNoWrap() ? 20000.0f : cell.right() - cell.getEffectivePaddingRight();
                        float y1 = cell.top() - newHeight + cell.getEffectivePaddingBottom();
                        float y2 = cell.top() - cell.getEffectivePaddingTop();
                        y = this.setColumn(ct, cell.left() + cell.getEffectivePaddingLeft(), y1, rightLimit, y2);
                    }
                    try {
                        status = ct.go(true);
                    }
                    catch (DocumentException e) {
                        throw new ExceptionConverter(e);
                    }
                    boolean bl = thisEmpty = ct.getYLine() == y;
                    if (thisEmpty) {
                        ct = ColumnText.duplicate(cell.getColumn());
                    }
                    boolean bl2 = allEmpty = allEmpty && thisEmpty;
                    if ((status & 1) == 0 || thisEmpty) {
                        c2.setColumn(ct);
                        ct.setFilledWidth(0.0f);
                    } else {
                        c2.setPhrase(null);
                    }
                }
                newCells[k] = c2;
                cell.setFixedHeight(newHeight);
            }
            ++k;
        }
        if (allEmpty) {
            k = 0;
            while (k < this.cells.length) {
                cell = this.cells[k];
                if (cell != null) {
                    float f = fh[k * 2];
                    float m = fh[k * 2 + 1];
                    if (f <= 0.0f) {
                        cell.setMinimumHeight(m);
                    } else {
                        cell.setFixedHeight(f);
                    }
                }
                ++k;
            }
            return null;
        }
        this.calculateHeights();
        PdfPRow split = new PdfPRow(newCells);
        split.widths = (float[])this.widths.clone();
        split.calculateHeights();
        return split;
    }
}

