/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jms.JMSException;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.transport.stomp.ProtocolConverter;
import org.apache.activemq.transport.stomp.StompFrame;

public class StompSubscription {
    public static final String AUTO_ACK = "auto";
    public static final String CLIENT_ACK = "client";
    private final ProtocolConverter protocolConverter;
    private final String subscriptionId;
    private final ConsumerInfo consumerInfo;
    private final LinkedHashMap dispatchedMessage = new LinkedHashMap();
    private String ackMode = "auto";
    private ActiveMQDestination destination;

    public StompSubscription(ProtocolConverter stompTransport, String subscriptionId, ConsumerInfo consumerInfo) {
        this.protocolConverter = stompTransport;
        this.subscriptionId = subscriptionId;
        this.consumerInfo = consumerInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onMessageDispatch(MessageDispatch md) throws IOException, JMSException {
        ActiveMQMessage message = (ActiveMQMessage)md.getMessage();
        if (this.ackMode == CLIENT_ACK) {
            StompSubscription stompSubscription = this;
            synchronized (stompSubscription) {
                this.dispatchedMessage.put(message.getJMSMessageID(), message.getMessageId());
            }
        } else if (this.ackMode == AUTO_ACK) {
            MessageAck ack = new MessageAck(md, 2, 1);
            this.protocolConverter.getTransportFilter().sendToActiveMQ(ack);
        }
        StompFrame command = this.protocolConverter.convertMessage(message);
        command.setAction("MESSAGE");
        if (this.subscriptionId != null) {
            command.getHeaders().put("subscription", this.subscriptionId);
        }
        this.protocolConverter.getTransportFilter().sendToStomp(command);
    }

    synchronized MessageAck onStompMessageAck(String messageId) {
        if (!this.dispatchedMessage.containsKey(messageId)) {
            return null;
        }
        MessageAck ack = new MessageAck();
        ack.setDestination(this.consumerInfo.getDestination());
        ack.setAckType((byte)2);
        ack.setConsumerId(this.consumerInfo.getConsumerId());
        int count = 0;
        Iterator iter = this.dispatchedMessage.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String id = (String)entry.getKey();
            MessageId msgid = (MessageId)entry.getValue();
            if (ack.getFirstMessageId() == null) {
                ack.setFirstMessageId(msgid);
            }
            iter.remove();
            ++count;
            if (!id.equals(messageId)) continue;
            ack.setLastMessageId(msgid);
            break;
        }
        ack.setMessageCount(count);
        return ack;
    }

    public String getAckMode() {
        return this.ackMode;
    }

    public void setAckMode(String ackMode) {
        this.ackMode = ackMode;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setDestination(ActiveMQDestination destination) {
        this.destination = destination;
    }

    public ActiveMQDestination getDestination() {
        return this.destination;
    }

    public ConsumerInfo getConsumerInfo() {
        return this.consumerInfo;
    }
}

