/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadaptor;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.command.BaseCommand;
import org.apache.activemq.kaha.Marshaller;
import org.apache.activemq.store.kahadaptor.KahaTransaction;
import org.apache.activemq.store.kahadaptor.TxCommand;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.wireformat.WireFormat;

public class TransactionMarshaller
implements Marshaller {
    private WireFormat wireFormat;

    public TransactionMarshaller(WireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    public void writePayload(Object object, DataOutput dataOut) throws IOException {
        KahaTransaction kt = (KahaTransaction)object;
        List list = kt.getList();
        dataOut.writeInt(list.size());
        for (int i = 0; i < list.size(); ++i) {
            TxCommand tx = (TxCommand)list.get(i);
            Object key = tx.getMessageStoreKey();
            ByteSequence packet = this.wireFormat.marshal(key);
            dataOut.writeInt(packet.length);
            dataOut.write(packet.data, packet.offset, packet.length);
            BaseCommand command = tx.getCommand();
            packet = this.wireFormat.marshal(command);
            dataOut.writeInt(packet.length);
            dataOut.write(packet.data, packet.offset, packet.length);
        }
    }

    public Object readPayload(DataInput dataIn) throws IOException {
        KahaTransaction result = new KahaTransaction();
        ArrayList<TxCommand> list = new ArrayList<TxCommand>();
        result.setList(list);
        int number = dataIn.readInt();
        for (int i = 0; i < number; ++i) {
            TxCommand command = new TxCommand();
            int size = dataIn.readInt();
            byte[] data = new byte[size];
            dataIn.readFully(data);
            Object key = this.wireFormat.unmarshal(new ByteSequence(data));
            command.setMessageStoreKey(key);
            size = dataIn.readInt();
            data = new byte[size];
            dataIn.readFully(data);
            BaseCommand bc = (BaseCommand)this.wireFormat.unmarshal(new ByteSequence(data));
            command.setCommand(bc);
            list.add(command);
        }
        return result;
    }
}

