/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.activemq.filter.DestinationMapEntry;
import org.apache.activemq.jaas.GroupPrincipal;

public class AuthorizationEntry
extends DestinationMapEntry {
    private Set readACLs = Collections.EMPTY_SET;
    private Set writeACLs = Collections.EMPTY_SET;
    private Set adminACLs = Collections.EMPTY_SET;

    public Set getAdminACLs() {
        return this.adminACLs;
    }

    public void setAdminACLs(Set adminACLs) {
        this.adminACLs = adminACLs;
    }

    public Set getReadACLs() {
        return this.readACLs;
    }

    public void setReadACLs(Set readACLs) {
        this.readACLs = readACLs;
    }

    public Set getWriteACLs() {
        return this.writeACLs;
    }

    public void setWriteACLs(Set writeACLs) {
        this.writeACLs = writeACLs;
    }

    public void setAdmin(String roles) {
        this.setAdminACLs(this.parseACLs(roles));
    }

    public void setRead(String roles) {
        this.setReadACLs(this.parseACLs(roles));
    }

    public void setWrite(String roles) {
        this.setWriteACLs(this.parseACLs(roles));
    }

    protected Set parseACLs(String roles) {
        HashSet<GroupPrincipal> answer = new HashSet<GroupPrincipal>();
        StringTokenizer iter = new StringTokenizer(roles, ",");
        while (iter.hasMoreTokens()) {
            String name = iter.nextToken().trim();
            answer.add(new GroupPrincipal(name));
        }
        return answer;
    }
}

