/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.pool;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.pool.SessionKey;
import org.apache.activemq.pool.SessionPool;
import org.apache.activemq.util.JMSExceptionSupport;
import org.apache.commons.pool.ObjectPoolFactory;

public class ConnectionPool {
    private ActiveMQConnection connection;
    private Map cache;
    private AtomicBoolean started = new AtomicBoolean(false);
    private ObjectPoolFactory poolFactory;

    public ConnectionPool(ActiveMQConnection connection, ObjectPoolFactory poolFactory) {
        this(connection, new HashMap(), poolFactory);
    }

    public ConnectionPool(ActiveMQConnection connection, Map cache, ObjectPoolFactory poolFactory) {
        this.connection = connection;
        this.cache = cache;
        this.poolFactory = poolFactory;
    }

    public void start() throws JMSException {
        if (this.started.compareAndSet(false, true)) {
            this.connection.start();
        }
    }

    public ActiveMQConnection getConnection() {
        return this.connection;
    }

    public Session createSession(boolean transacted, int ackMode) throws JMSException {
        SessionKey key = new SessionKey(transacted, ackMode);
        SessionPool pool = (SessionPool)this.cache.get(key);
        if (pool == null) {
            pool = new SessionPool(this, key, this.poolFactory.createPool());
            this.cache.put(key, pool);
        }
        return pool.borrowSession();
    }

    public void close() throws JMSException {
        Iterator i = this.cache.values().iterator();
        while (i.hasNext()) {
            SessionPool pool = (SessionPool)i.next();
            i.remove();
            try {
                pool.close();
            }
            catch (Exception e) {
                throw JMSExceptionSupport.create(e);
            }
        }
        this.connection.close();
        this.connection = null;
    }
}

